/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.algorithmic.compression;

import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoder;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoderI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.io.InputBitStream;
import java.io.IOException;

public final class FastArithmeticDecoderPlus
implements FastArithmeticDecoderI {
    private final FastArithmeticDecoder[] delegates = new FastArithmeticDecoder[this.numCoders];
    private int previousSymbol;
    private final IntArrayList[] decodedLists = new IntArrayList[this.numCoders];
    private boolean decoded = false;
    private final int[] currentIndex;
    private int symbolRetrievalCount;
    private final int[] lengths = new int[this.numCoders];
    private final int numCoders;
    private int mostAbundantCount;
    private int mostAbundantSymbol = -1;
    private final int[] counts;

    public FastArithmeticDecoderPlus(int numSymbols) {
        this.numCoders = 2;
        for (int i = 0; i < this.numCoders; ++i) {
            this.delegates[i] = new FastArithmeticDecoder(numSymbols);
            this.decodedLists[i] = new IntArrayList(100000);
        }
        this.counts = new int[numSymbols];
        this.currentIndex = new int[this.numCoders];
    }

    @Override
    public void reset() {
        this.previousSymbol = 0;
        this.decoded = false;
        int i = 0;
        for (FastArithmeticDecoder delegate : this.delegates) {
            delegate.reset();
            this.decodedLists[i].clear();
            ++i;
        }
    }

    @Override
    public int decode(InputBitStream ibs) throws IOException {
        int symbol;
        int delegateIndex;
        if (!this.decoded) {
            for (delegateIndex = 0; delegateIndex < this.numCoders; ++delegateIndex) {
                int size = ibs.readNibble();
                FastArithmeticDecoder delegate = this.delegates[delegateIndex];
                IntArrayList decodedList = this.decodedLists[delegateIndex];
                if (size <= 0) continue;
                for (int i = 0; i < size; ++i) {
                    int x = delegate.decode(ibs);
                    decodedList.add(x);
                }
                this.reposition(ibs, delegateIndex);
            }
            this.decoded = true;
        }
        int n = delegateIndex = this.previousSymbol == this.mostAbundantSymbol ? 0 : 1;
        int n2 = this.currentIndex[n];
        this.currentIndex[n] = n2 + 1;
        int n3 = this.previousSymbol = (symbol = this.decodedLists[delegateIndex].getInt(n2));
        this.counts[n3] = this.counts[n3] + 1;
        int previousCount = this.counts[this.previousSymbol];
        if (this.mostAbundantSymbol == this.previousSymbol || previousCount > this.mostAbundantCount) {
            this.mostAbundantSymbol = this.previousSymbol;
            this.mostAbundantCount = previousCount;
        }
        return symbol;
    }

    @Override
    public void flush(InputBitStream ibs) throws IOException {
        throw new UnsupportedOperationException("flush is not supported by this implementation.");
    }

    public void flush(InputBitStream input, int delegateIndex) throws IOException {
        this.delegates[delegateIndex].flush(input);
    }

    @Override
    public long getWindow() {
        throw new UnsupportedOperationException("getWindow is not supported by this implementation.");
    }

    @Override
    public void reposition(InputBitStream input) throws IOException {
    }

    public void reposition(InputBitStream input, int delegateIndex) throws IOException {
        this.flush(input, delegateIndex);
        long readBits = input.readBits();
        long position = readBits - 63L;
        input.flush();
        if (position >= 0L) {
            input.position(position);
            input.readBits(position);
        }
    }
}

