/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.util.LocationAware;
import java.io.IOException;
import java.io.OutputStream;

final class PositionalOutputStream
extends OutputStream
implements LocationAware {
    private final OutputStream out;
    private long position = 0L;

    public PositionalOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public final void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public final void write(byte[] bytes, int startIndex, int numBytes) throws IOException {
        this.position += (long)numBytes;
        this.out.write(bytes, startIndex, numBytes);
    }

    @Override
    public final void write(int c) throws IOException {
        ++this.position;
        this.out.write(c);
    }

    @Override
    public final long getPosition() {
        return this.position;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

