/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

public class ConstructorFunctionLibrary
implements FunctionLibrary {
    private Configuration config;

    public ConstructorFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        if (arity != 1 && arity != -1) {
            return null;
        }
        String uri = functionName.getNamespaceURI();
        String local = functionName.getLocalName();
        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
            AtomicType type = (AtomicType)Type.getBuiltInItemType(uri, local);
            if (type != null && type.getFingerprint() != 531) {
                return new SequenceType[]{SequenceType.makeSequenceType(type, 24576), SequenceType.OPTIONAL_ATOMIC};
            }
            return null;
        }
        int fingerprint = this.config.getNamePool().getFingerprint(uri, local);
        if (fingerprint == -1) {
            return null;
        }
        SchemaType st = this.config.getSchemaType(fingerprint);
        if (st != null && st.isAtomicType()) {
            return new SequenceType[]{SequenceType.makeSequenceType((AtomicType)st, 24576), SequenceType.OPTIONAL_ATOMIC};
        }
        return null;
    }

    public Expression bind(StructuredQName functionName, Expression[] arguments, StaticContext env) throws XPathException {
        SchemaType st;
        int fp;
        String uri = functionName.getNamespaceURI();
        String localName = functionName.getLocalName();
        String targetURI = uri;
        boolean builtInNamespace = uri.equals("http://www.w3.org/2001/XMLSchema");
        if (builtInNamespace) {
            if (arguments.length != 1) {
                throw new XPathException("A constructor function must have exactly one argument");
            }
            AtomicType type = (AtomicType)Type.getBuiltInItemType(targetURI, localName);
            if (type == null || type.getFingerprint() == 632 || type.getFingerprint() == 531) {
                XPathException err = new XPathException("Unknown constructor function: {" + uri + '}' + localName);
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            return new CastExpression(arguments[0], type, true);
        }
        if (arguments.length == 1 && (fp = this.config.getNamePool().getFingerprint(uri, localName)) != -1 && (st = this.config.getSchemaType(fp)) != null && st.isAtomicType()) {
            return new CastExpression(arguments[0], (AtomicType)st, true);
        }
        return null;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

