/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateImageRequest
extends AmazonWebServiceRequest {
    private Boolean dryRun;
    private String instanceId;
    private String name;
    private String description;
    private Boolean noReboot;
    private List<BlockDeviceMapping> blockDeviceMapping;

    public CreateImageRequest() {
    }

    public CreateImageRequest(String instanceId, String name) {
        this.instanceId = instanceId;
        this.name = name;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public CreateImageRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public CreateImageRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateImageRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateImageRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isNoReboot() {
        return this.noReboot;
    }

    public void setNoReboot(Boolean noReboot) {
        this.noReboot = noReboot;
    }

    public CreateImageRequest withNoReboot(Boolean noReboot) {
        this.noReboot = noReboot;
        return this;
    }

    public Boolean getNoReboot() {
        return this.noReboot;
    }

    public List<BlockDeviceMapping> getBlockDeviceMapping() {
        if (this.blockDeviceMapping == null) {
            this.blockDeviceMapping = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMapping;
    }

    public void setBlockDeviceMapping(Collection<BlockDeviceMapping> blockDeviceMapping) {
        if (blockDeviceMapping == null) {
            this.blockDeviceMapping = null;
            return;
        }
        ArrayList<BlockDeviceMapping> blockDeviceMappingCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMapping.size());
        blockDeviceMappingCopy.addAll(blockDeviceMapping);
        this.blockDeviceMapping = blockDeviceMappingCopy;
    }

    public CreateImageRequest withBlockDeviceMapping(BlockDeviceMapping ... blockDeviceMapping) {
        if (this.getBlockDeviceMapping() == null) {
            this.setBlockDeviceMapping(new ArrayList<BlockDeviceMapping>(blockDeviceMapping.length));
        }
        for (BlockDeviceMapping value : blockDeviceMapping) {
            this.getBlockDeviceMapping().add(value);
        }
        return this;
    }

    public CreateImageRequest withBlockDeviceMapping(Collection<BlockDeviceMapping> blockDeviceMapping) {
        if (blockDeviceMapping == null) {
            this.blockDeviceMapping = null;
        } else {
            ArrayList<BlockDeviceMapping> blockDeviceMappingCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMapping.size());
            blockDeviceMappingCopy.addAll(blockDeviceMapping);
            this.blockDeviceMapping = blockDeviceMappingCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dryRun != null) {
            sb.append("DryRun: " + this.dryRun + ", ");
        }
        if (this.instanceId != null) {
            sb.append("InstanceId: " + this.instanceId + ", ");
        }
        if (this.name != null) {
            sb.append("Name: " + this.name + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.noReboot != null) {
            sb.append("NoReboot: " + this.noReboot + ", ");
        }
        if (this.blockDeviceMapping != null) {
            sb.append("BlockDeviceMapping: " + this.blockDeviceMapping + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.isNoReboot() == null ? 0 : this.isNoReboot().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMapping() == null ? 0 : this.getBlockDeviceMapping().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest)((Object)obj);
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.isNoReboot() == null ^ this.isNoReboot() == null) {
            return false;
        }
        if (other.isNoReboot() != null && !other.isNoReboot().equals(this.isNoReboot())) {
            return false;
        }
        if (other.getBlockDeviceMapping() == null ^ this.getBlockDeviceMapping() == null) {
            return false;
        }
        return other.getBlockDeviceMapping() == null || other.getBlockDeviceMapping().equals(this.getBlockDeviceMapping());
    }
}

