.\" -*- nroff -*-
.\" manual page [] for chat 1.8
.\" Id: chat.8,v 1.9 1999/09/06 05:10:23 paulus Exp
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH CHAT 8 "22 May 1999" "Chat Version 1.22"
.SH "NAME"
chat \- Automated conversational script with a modem
.SH "SYNOPSIS"
.B chat
[
.I options
]
.I script
.SH "DESCRIPTION"
.LP
The \fIchat\fR program defines a conversational exchange between the
computer and the modem. Its primary purpose is to establish the
connection between the Point-to-Point Protocol Daemon (\fIpppd\fR) and
the remote's \fIpppd\fR process.
.SH "OPTIONS"
.TP
.B -f \fI<chat file>
Read the chat script from the chat \fIfile\fR. The use of this option
is mutually exclusive with the chat script parameters. The user must
have read access to the file. Multiple lines are permitted in the
file. Space or horizontal tab characters should be used to separate
the strings.
.TP
.B -t \fI<timeout>
Set the timeout for the expected string to be received. If the string
is not received within the time limit then the reply string is not
sent. An alternate reply may be sent or the script will fail if there
is no alternate reply string. A failed script will cause the
\fIchat\fR program to terminate with a non-zero error code.
.TP
.B -r \fI<report file>
Set the file for output of the report strings. If you use the keyword
\fIREPORT\fR, the resulting strings are written to this file. If this
option is not used and you still use \fIREPORT\fR keywords, the
\fIstderr\fR file is used for the report strings.
.TP
.B -e
Start with the echo option turned on. Echoing may also be turned on
or off at specific points in the chat script by using the \fIECHO\fR
keyword. When echoing is enabled, all output from the modem is echoed
to \fIstderr\fR.
.TP
.B -E
Enables environment variable substituion within chat scripts using the
standard \fI$xxx\fR syntax.
.TP
.B -v
Request that the \fIchat\fR script be executed in a verbose mode. The
\fIchat\fR program will then log the execution state of the chat
script as well as all text received from the modem and the output
strings sent to the modem.  The default is to log through the SYSLOG;
the logging method may be altered with the -S and -s flags. SYSLOGs
are logged to facility LOG_LOCAL2.
.TP
.B -V
Request that the \fIchat\fR script be executed in a stderr verbose
mode. The \fIchat\fR program will then log all text received from the
modem and the output strings sent to the modem to the stderr device. This
device is usually the local console at the station running the chat or
pppd program.
.TP
.B -s
Use stderr.  All log messages from '-v' and all error messages will be
sent to stderr.
.TP
.B -S
Do not use the SYSLOG.  By default, error messages are sent to the
SYSLOG.  The use of -S will prevent both log messages from '-v' and
error messages from being sent to the SYSLOG (to facility LOG_LOCAL2).
.TP
.B -T \fI<phone number>
Pass in an arbitary string, usually a phone number, that will be
substituted for the \eT substitution metacharacter in a send string.
.TP
.B -U \fI<phone number 2>
Pass in a second string, usually a phone number, that will be
substituted for the \eU substitution metacharacter in a send string.
This is useful when dialing an ISDN terminal adapter that requires two
numbers.
.TP
.B script
If the script is not specified in a file with the \fI-f\fR option then
the script is included as parameters to the \fIchat\fR program.
.SH "CHAT SCRIPT"
.LP
The \fIchat\fR script defines the communications.
.LP
A script consists of one or more "expect-send" pairs of strings,
separated by spaces, with an optional "subexpect-subsend" string pair,
separated by a dash as in the following example:
.IP
ogin:-BREAK-ogin: ppp ssword: hello2u2
.LP
This line indicates that the \fIchat\fR program should expect the string
"ogin:". If it fails to receive a login prompt within the time interval
allotted, it is to send a break sequence to the remote and then expect the
string "ogin:". If the first "ogin:" is received then the break sequence is
not generated.
.LP
Once it received the login prompt the \fIchat\fR program will send the
string ppp and then expect the prompt "ssword:". When it receives the
prompt for the password, it will send the password hello2u2.
.LP
A carriage return is normally sent following the reply string. It is not
expected in the "expect" string unless it is specifically requested by using
the \er character sequence.
.LP
The expect sequence should contain only what is needed to identify the
string. Since it is normally stored on a disk file, it should not contain
variable information. It is generally not acceptable to look for time
strings, network identification strings, or other variable pieces of data as
an expect string.
.LP
To help correct for characters which may be corrupted during the initial
sequence, look for the string "ogin:" rather than "login:". It is possible
that the leading "l" character may be received in error and you may never
find the string even though it was sent by the system. For this reason,
scripts look for "ogin:" rather than "login:" and "ssword:" rather than
"password:".
.LP
A very simple script might look like this:
.IP
ogin: ppp ssword: hello2u2
.LP
In other words, expect ....ogin:, send ppp, expect ...ssword:, send hello2u2.
.LP
In actual practice, simple scripts are rare. At the vary least, you
should include sub-expect sequences should the original string not be
received. For example, consider the following script:
.IP
ogin:--ogin: ppp ssword: hello2u2
.LP
This would be a better script than the simple one used earlier. This would look
for the same login: prompt, however, if one was not received, a single
return sequence is sent and then it will look for login: again. Should line
noise obscure the first login prompt then sending the empty line will
usually generate a login prompt again.
.SH "COMMENTS"
Comments can be embedded in the chat script. A comment is a line which
starts with the \fB#\fR (hash) character in column 1. Such comment
lines are just ignored by the chat program. If a '#' character is to
be expected as the first character of the expect sequence, you should
quote the expect string, or give its octal value, `\e043'.
In a script file if you want to wait for a prompt that starts with a '#'
character, you would have to write something like this:
.IP
# Now wait for the prompt and send logout string
.br
\'# ' logout
.SH "SENDING DATA FROM A FILE"
If the string to send starts with an at sign (@), the rest of the
string is taken to be the name of a file to read to get the string to
send.  If the last character of the data read is a newline, it is
removed.  The file can be a named pipe (or fifo) instead of a regular
file.  This provides a way for \fBchat\fR to communicate with another
program, for example, a program to prompt the user and receive a
password typed in.
.SH "ABORT STRINGS"
Many modems will report the status of the call as a string. These
strings may be \fBCONNECTED\fR or \fBNO CARRIER\fR or \fBBUSY\fR. It
is often desirable to terminate the script should the modem fail to
connect to the remote. The difficulty is that a script would not know
exactly which modem string it may receive. On one attempt, it may
receive \fBBUSY\fR while the next time it may receive \fBNO CARRIER\fR.
.LP
These "abort" strings may be specified in the script using the \fIABORT\fR
sequence. It is written in the script as in the following example:
.IP
ABORT BUSY ABORT 'NO CARRIER' '' ATZ OK ATDT5551212 CONNECT
.LP
This sequence will expect nothing; and then send the string ATZ. The
expected response to this is the string \fIOK\fR. When it receives \fIOK\fR,
the string ATDT5551212 to dial the telephone. The expected string is
\fICONNECT\fR. If the string \fICONNECT\fR is received the remainder of the
script is executed. However, should the modem find a busy telephone, it will
send the string \fIBUSY\fR. This will cause the string to match the abort
character sequence. The script will then fail because it found a match to
the abort string. If it received the string \fINO CARRIER\fR, it will abort
for the same reason. Either string may be received. Either string will
terminate the \fIchat\fR script.
.SH "CLR_ABORT STRINGS"
This sequence allows for clearing previously set \fBABORT\fR strings.
\fBABORT\fR strings are kept in an array of a pre-determined size (at
compilation time); \fBCLR_ABORT\fR will reclaim the space for cleared
entries so that new strings can use that space.
.SH "SAY STRINGS"
The \fBSAY\fR directive allows the script to send strings to the user
at the terminal via standard error.  If \fBchat\fR is being run by
pppd, and pppd is running as a daemon (detached from its controlling
terminal), standard error will normally be redirected to the file
/etc/ppp/connect-errors.
.LP
\fBSAY\fR strings must be enclosed in single or double quotes. If
carriage return and line feed are needed in the string to be output,
you must explicitly add them to your string.
.LP
The SAY strings could be used to give progress messages in sections of
the script where you want to have 'ECHO OFF' but still let the user
know what is happening.  An example is:
.IP
ABORT BUSY
.br
ECHO OFF
.br
SAY "Dialling your ISP...\en"
.br
\'' ATDT5551212
.br
TIMEOUT 120
.br
SAY "Waiting up to 2 minutes for connection ... "
.br
CONNECT ''
.br
SAY "Connected, now logging in ...\n"
.br
ogin: account
.br
ssword: pass
.br
$ \c
SAY "Logged in OK ...\n"
\fIetc ...\fR
.LP
This sequence will only present the SAY strings to the user and all
the details of the script will remain hidden. For example, if the
above script works, the user will see:
.IP
Dialling your ISP...
.br
Waiting up to 2 minutes for connection ... Connected, now logging in ...
.br
Logged in OK ...
.LP
.SH "REPORT STRINGS"
A \fBreport\fR string is similar to the ABORT string. The difference
is that the strings, and all characters to the next control character
such as a carriage return, are written to the report file.
.LP
The report strings may be used to isolate the transmission rate of the
modem's connect string and return the value to the chat user. The
analysis of the report string logic occurs in conjunction with the
other string processing such as looking for the expect string. The use
of the same string for a report and abort sequence is probably not
very useful, however, it is possible.
.LP
The report strings to no change the completion code of the program.
.LP
These "report" strings may be specified in the script using the \fIREPORT\fR
sequence. It is written in the script as in the following example:
.IP
REPORT CONNECT ABORT BUSY '' ATDT5551212 CONNECT '' ogin: account
.LP
This sequence will expect nothing; and then send the string
ATDT5551212 to dial the telephone. The expected string is
\fICONNECT\fR. If the string \fICONNECT\fR is received the remainder
of the script is executed. In addition the program will write to the
expect-file the string "CONNECT" plus any characters which follow it
such as the connection rate.
.SH "CLR_REPORT STRINGS"
This sequence allows for clearing previously set \fBREPORT\fR strings.
\fBREPORT\fR strings are kept in an array of a pre-determined size (at
compilation time); \fBCLR_REPORT\fR will reclaim the space for cleared
entries so that new strings can use that space.
.SH "ECHO"
The echo options controls whether the output from the modem is echoed
to \fIstderr\fR. This option may be set with the \fI-e\fR option, but
it can also be controlled by the \fIECHO\fR keyword. The "expect-send"
pair \fIECHO\fR \fION\fR enables echoing, and \fIECHO\fR \fIOFF\fR
disables it. With this keyword you can select which parts of the
conversation should be visible. For instance, with the following
script:
.IP
ABORT   'BUSY'
.br
ABORT   'NO CARRIER'
.br
''      ATZ
.br
OK\er\en  ATD1234567
.br
\er\en    \ec
.br
ECHO    ON
.br
CONNECT \ec
.br
ogin:   account
.LP
all output resulting from modem configuration and dialing is not visible,
but starting with the \fICONNECT\fR (or \fIBUSY\fR) message, everything
will be echoed.
.SH "HANGUP"
The HANGUP options control whether a modem hangup should be considered
as an error or not.  This option is useful in scripts for dialling
systems which will hang up and call your system back.  The HANGUP
options can be \fBON\fR or \fBOFF\fR.
.br
When HANGUP is set OFF and the modem hangs up (e.g., after the first
stage of logging in to a callback system), \fBchat\fR will continue
running the script (e.g., waiting for the incoming call and second
stage login prompt). As soon as the incoming call is connected, you
should use the \fBHANGUP ON\fR directive to reinstall normal hang up
signal behavior.  Here is an (simple) example script:
.IP
ABORT   'BUSY'
.br
''      ATZ
.br
OK\er\en  ATD1234567
.br
\er\en    \ec
.br
CONNECT \ec
.br
\'Callback login:' call_back_ID
.br
HANGUP OFF
.br
ABORT "Bad Login"
.br
\'Callback Password:' Call_back_password
.br
TIMEOUT 120
.br
CONNECT \ec
.br
HANGUP ON
.br
ABORT "NO CARRIER"
.br
ogin:--BREAK--ogin: real_account
.br
\fIetc ...\fR
.LP
.SH "TIMEOUT"
The initial timeout value is 45 seconds. This may be changed using the \fB-t\fR
parameter.
.LP
To change the timeout value for the next expect string, the following
example may be used:
.IP
ATZ OK ATDT5551212 CONNECT TIMEOUT 10 ogin:--ogin: TIMEOUT 5 assword: hello2u2
.LP
This will change the timeout to 10 seconds when it expects the login:
prompt. The timeout is then changed to 5 seconds when it looks for the
password prompt.
.LP
The timeout, once changed, remains in effect until it is changed again.
.SH "SENDING EOT"
The special reply string of \fIEOT\fR indicates that the chat program
should send an EOT character to the remote. This is normally the
End-of-file character sequence. A return character is not sent
following the EOT.
.PR
The EOT sequence may be embedded into the send string using the
sequence \fI^D\fR.
.SH "GENERATING BREAK"
The special reply string of \fIBREAK\fR will cause a break condition
to be sent. The break is a special signal on the transmitter. The
normal processing on the receiver is to change the transmission rate.
It may be used to cycle through the available transmission rates on
the remote until you are able to receive a valid login prompt.
.PR
The break sequence may be embedded into the send string using the
\fI\eK\fR sequence.
.SH "ESCAPE SEQUENCES"
The expect and reply strings may contain escape sequences. All of the
sequences are legal in the reply string. Many are legal in the expect.
Those which are not valid in the expect sequence are so indicated.
.TP
.B ''
Expects or sends a null string. If you send a null string then it will still
send the return character. This sequence may either be a pair of apostrophe
or quote characters.
.TP
.B \eb
represents a backspace character.
.TP
.B \ec
Suppresses the newline at the end of the reply string. This is the only
method to send a string without a trailing return character. It must
be at the end of the send string. For example,
the sequence hello\ec will simply send the characters h, e, l, l, o.
.I (not valid in expect.)
.TP
.B \ed
Delay for one second. The program uses sleep(1) which will delay to a
maximum of one second.
.I (not valid in expect.)
.TP
.B \eK
Insert a BREAK
.I (not valid in expect.)
.TP
.B \en
Send a newline or linefeed character.
.TP
.B \eN
Send a null character. The same sequence may be represented by \e0.
.I (not valid in expect.)
.TP
.B \ep
Pause for a fraction of a second. The delay is 1/10th of a second.
.I (not valid in expect.)
.TP
.B \eq
Suppress writing the string to the SYSLOG. The string ?????? is
written to the log in its place.
.I (not valid in expect.)
.TP
.B \er
Send or expect a carriage return.
.TP
.B \es
Represents a space character in the string. This may be used when it
is not desirable to quote the strings which contains spaces. The
sequence 'HI\ TIM' and HI\esTIM are the same.
.TP
.B \et
Send or expect a tab character.
.TP
.B \eT
Send the phone number string as specified with the \fI-T\fR option
.I (not valid in expect.)
.TP
.B \eU
Send the phone number 2 string as specified with the \fI-U\fR option
.I (not valid in expect.)
.TP
.B \e\e
Send or expect a backslash character.
.TP
.B \eddd
Collapse the octal digits (ddd) into a single ASCII character and send that
character.
.I (some characters are not valid in expect.)
.TP
.B \^^C
Substitute the sequence with the control character represented by C.
For example, the character DC1 (17) is shown as \^^Q.
.I (some characters are not valid in expect.)
.SH "ENVIRONMENT VARIABLES"
Environment variables are available within chat scripts, if  the \fI-E\fR
option was specified in the command line. The metacharacter \fI$\fR is used
to introduce the name of the environment variable to substitute. If the
substition fails, because the requested environment variable is not set,
\fInothing\fR is replaced for the variable.
.SH "TERMINATION CODES"
The \fIchat\fR program will terminate with the following completion
codes.
.TP
.B 0
The normal termination of the program. This indicates that the script
was executed without error to the normal conclusion.
.TP
.B 1
One or more of the parameters are invalid or an expect string was too
large for the internal buffers. This indicates that the program as not
properly executed.
.TP
.B 2
An error occurred during the execution of the program. This may be due
to a read or write operation failing for some reason or chat receiving
a signal such as SIGINT.
.TP
.B 3
A timeout event occurred when there was an \fIexpect\fR string without
having a "-subsend" string. This may mean that you did not program the
script correctly for the condition or that some unexpected event has
occurred and the expected string could not be found.
.TP
.B 4
The first string marked as an \fIABORT\fR condition occurred.
.TP
.B 5
The second string marked as an \fIABORT\fR condition occurred.
.TP
.B 6
The third string marked as an \fIABORT\fR condition occurred.
.TP
.B 7
The fourth string marked as an \fIABORT\fR condition occurred.
.TP
.B ...
The other termination codes are also strings marked as an \fIABORT\fR
condition.
.LP
Using the termination code, it is possible to determine which event
terminated the script. It is possible to decide if the string "BUSY"
was received from the modem as opposed to "NO DIAL TONE". While the
first event may be retried, the second will probably have little
chance of succeeding during a retry.
.SH "SEE ALSO"
Additional information about \fIchat\fR scripts may be found with UUCP
documentation. The \fIchat\fR script was taken from the ideas proposed
by the scripts used by the \fIuucico\fR program.
.LP
uucp(1), uucico(8)
.SH "COPYRIGHT"
The \fIchat\fR program is in public domain. This is not the GNU public
license. If it breaks then you get to keep both pieces.
