#ifndef INCLUDE_INIT_H
#define INCLUDE_INIT_H
/**
 * @brief Definitions and prototypes for main program initialization
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation
 * (http://www.gnu.org/licenses/gpl.html)
 *
 * @file    src/init.h
 * @author  Matthias Grimm <matthias.grimm@users.sourceforge.net>
 */

#include <glib.h>

/* short options for optarg */
#define ARG_ALL			"hvqd::c:"
#define ARG_HELP		'h'
#define ARG_VERSION		'v'
#define ARG_DETACH		'd'
#define ARG_CONFIG		'c'
#define ARG_QUIET		'q'

#define DEFAULT_CONFIG	SYS_CONF_DIR "/pbbuttonsd.cnf"
#define DEFAULT_PIDFILE "/var/run/" PACKAGE ".pid"
#define MODULECOUNT   15

/**
 * @brief  main server data structure
 *
 * This structure contains major server data.
 *
 * Main part of this structure is the module list.
 */
struct serverdata {
	char *prgname;
	/**
	 * @brief  Name and path of configuration file
	 * configfile to read: eg. /etc/pbbuttonsd.cnf
	 * Writing the configfile will be controlled by module_system.
	 */
	char *configfile;
	GMainLoop *mainloop;
	int quiet;
	struct {
		int  (*initfunc)();
		void (*exitfunc)();
	} module[MODULECOUNT];
};

/* prototypes */
void init_serverdata (struct serverdata *sd);
int init_modules(struct serverdata *sd);
void exit_modules(struct serverdata *sd);
int evaluate_args(struct serverdata *sd, int argc, char *argv[]);
void cbSigHandlerTX (int signum);
gboolean cbSigHandlerRD (int fd, gpointer user_data);
void installSigHandler (struct serverdata *base);
int ipc_init_stub ();

#endif    /* INCLUDE_INIT_H */
