/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *
 */

#ifndef CDataClassDoc_h_
#define CDataClassDoc_h_


#include "Doc/SchemaTypesDoc/CClassInstancePropertyDoc.h"
#include "Doc/SchemaTypesDoc/CClassPropertyDoc.h"

namespace Caf {

/// Definition of a data class that may be generated by the provider
class SCHEMATYPESDOC_LINKAGE CDataClassDoc {
public:
	CDataClassDoc();
	virtual ~CDataClassDoc();

public:
	/// Initializes the object with everything required by this
	/// container. Once initialized, this object cannot
	/// be changed (i.e. it is immutable).
	void initialize(
		const std::string namespaceVal,
		const std::string name,
		const std::string version,
		const std::deque<SmartPtrCClassPropertyDoc> propertyCollection = std::deque<SmartPtrCClassPropertyDoc>(),
		const std::deque<SmartPtrCClassInstancePropertyDoc> instancePropertyCollection = std::deque<SmartPtrCClassInstancePropertyDoc>(),
		const bool unique = false,
		const bool transientVal = false,
		const std::string displayName = std::string(),
		const std::string description = std::string());

public:
	/// Accessor for the NamespaceVal
	std::string getNamespaceVal() const;

	/// Accessor for the Name
	std::string getName() const;

	/// Accessor for the Version
	std::string getVersion() const;

	/// Accessor for the Property
	std::deque<SmartPtrCClassPropertyDoc> getPropertyCollection() const;

	/// Accessor for the InstanceProperty
	std::deque<SmartPtrCClassInstancePropertyDoc> getInstancePropertyCollection() const;

	/// Indicates whether the key properties of this class are enough to guarantee uniqueness from other classes of the same type
	bool getUnique() const;

	/// Accessor for the TransientVal
	bool getTransientVal() const;

	/// A hint as to what this class should be called when displaying it to a human
	std::string getDisplayName() const;

	/// A phrase to describe the class for mouse-over text, etc
	std::string getDescription() const;

private:
	std::string _namespaceVal;
	std::string _name;
	std::string _version;
	std::deque<SmartPtrCClassPropertyDoc> _propertyCollection;
	std::deque<SmartPtrCClassInstancePropertyDoc> _instancePropertyCollection;
	bool _unique;
	bool _transientVal;
	std::string _displayName;
	std::string _description;
	bool _isInitialized;

private:
	CAF_CM_DECLARE_NOCOPY(CDataClassDoc);
};

CAF_DECLARE_SMART_POINTER(CDataClassDoc);

}

#endif
