/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.List;

@GwtCompatible
public class MultimapPutTester<K, V>
extends AbstractMultimapTester<K, V> {
    private static final Object[] EMPTY = new Object[0];

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutEmpty() {
        int size = this.getNumElements();
        Object key = this.sampleKeys().e3;
        Object value = this.sampleValues().e3;
        this.assertGet(key, EMPTY);
        MultimapPutTester.assertTrue((boolean)this.multimap().put(key, value));
        this.assertGet(key, value);
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresent() {
        int size = this.getNumElements();
        Object key = this.sampleKeys().e0;
        Object oldValue = this.sampleValues().e0;
        Object newValue = this.sampleValues().e3;
        this.assertGet(key, oldValue);
        MultimapPutTester.assertTrue((boolean)this.multimap().put(key, newValue));
        this.assertGet(key, oldValue, newValue);
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutTwoElements() {
        int size = this.getNumElements();
        Object key = this.sampleKeys().e0;
        Object v1 = this.sampleValues().e3;
        Object v2 = this.sampleValues().e4;
        List values = Helpers.copyToList(this.multimap().get(key));
        MultimapPutTester.assertTrue((boolean)this.multimap().put(key, v1));
        MultimapPutTester.assertTrue((boolean)this.multimap().put(key, v2));
        values.add(v1);
        values.add(v2);
        this.assertGet(key, values.toArray());
        MultimapPutTester.assertEquals((int)(size + 2), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutNullValue() {
        int size = this.getNumElements();
        this.multimap().put(this.sampleKeys().e3, null);
        this.assertGet(this.sampleKeys().e3, new Object[]{null});
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutNullKey() {
        int size = this.getNumElements();
        this.multimap().put(null, this.sampleValues().e3);
        this.assertGet(null, this.sampleValues().e3);
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }
}

