// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/uptime.proto

package monitoring

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_api4 "google.golang.org/genproto/googleapis/api/monitoredres"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The regions from which an uptime check can be run.
type UptimeCheckRegion int32

const (
	// Default value if no region is specified. Will result in uptime checks
	// running from all regions.
	UptimeCheckRegion_REGION_UNSPECIFIED UptimeCheckRegion = 0
	// Allows checks to run from locations within the United States of America.
	UptimeCheckRegion_USA UptimeCheckRegion = 1
	// Allows checks to run from locations within the continent of Europe.
	UptimeCheckRegion_EUROPE UptimeCheckRegion = 2
	// Allows checks to run from locations within the continent of South
	// America.
	UptimeCheckRegion_SOUTH_AMERICA UptimeCheckRegion = 3
	// Allows checks to run from locations within the Asia Pacific area (ex:
	// Singapore).
	UptimeCheckRegion_ASIA_PACIFIC UptimeCheckRegion = 4
)

var UptimeCheckRegion_name = map[int32]string{
	0: "REGION_UNSPECIFIED",
	1: "USA",
	2: "EUROPE",
	3: "SOUTH_AMERICA",
	4: "ASIA_PACIFIC",
}
var UptimeCheckRegion_value = map[string]int32{
	"REGION_UNSPECIFIED": 0,
	"USA":                1,
	"EUROPE":             2,
	"SOUTH_AMERICA":      3,
	"ASIA_PACIFIC":       4,
}

func (x UptimeCheckRegion) String() string {
	return proto.EnumName(UptimeCheckRegion_name, int32(x))
}
func (UptimeCheckRegion) EnumDescriptor() ([]byte, []int) { return fileDescriptor10, []int{0} }

// The supported resource types that can be used as values of
// group_resource.resource_type. gae_app and uptime_url are not allowed
// because group checks on App Engine modules and URLs are not allowed.
type GroupResourceType int32

const (
	// Default value (not valid).
	GroupResourceType_RESOURCE_TYPE_UNSPECIFIED GroupResourceType = 0
	// A group of instances (could be either GCE or AWS_EC2).
	GroupResourceType_INSTANCE GroupResourceType = 1
	// A group of AWS load balancers.
	GroupResourceType_AWS_ELB_LOAD_BALANCER GroupResourceType = 2
)

var GroupResourceType_name = map[int32]string{
	0: "RESOURCE_TYPE_UNSPECIFIED",
	1: "INSTANCE",
	2: "AWS_ELB_LOAD_BALANCER",
}
var GroupResourceType_value = map[string]int32{
	"RESOURCE_TYPE_UNSPECIFIED": 0,
	"INSTANCE":                  1,
	"AWS_ELB_LOAD_BALANCER":     2,
}

func (x GroupResourceType) String() string {
	return proto.EnumName(GroupResourceType_name, int32(x))
}
func (GroupResourceType) EnumDescriptor() ([]byte, []int) { return fileDescriptor10, []int{1} }

// This message configures which resources and services to monitor for
// availability.
type UptimeCheckConfig struct {
	// A unique resource name for this UptimeCheckConfig. The format is:
	//
	//
	//   `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
	//
	// This field should be omitted when creating the uptime check configuration;
	// on create, the resource name is assigned by the server and included in the
	// response.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A human-friendly name for the uptime check configuration. The display name
	// should be unique within a Stackdriver Account in order to make it easier
	// to identify; however, uniqueness is not enforced. Required.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// The resource the check is checking. Required.
	//
	// Types that are valid to be assigned to Resource:
	//	*UptimeCheckConfig_MonitoredResource
	//	*UptimeCheckConfig_ResourceGroup_
	Resource isUptimeCheckConfig_Resource `protobuf_oneof:"resource"`
	// The type of uptime check request.
	//
	// Types that are valid to be assigned to CheckRequestType:
	//	*UptimeCheckConfig_HttpCheck_
	//	*UptimeCheckConfig_TcpCheck_
	CheckRequestType isUptimeCheckConfig_CheckRequestType `protobuf_oneof:"check_request_type"`
	// How often the uptime check is performed.
	// Currently, only 1, 5, 10, and 15 minutes are supported. Required.
	Period *google_protobuf3.Duration `protobuf:"bytes,7,opt,name=period" json:"period,omitempty"`
	// The maximum amount of time to wait for the request to complete (must be
	// between 1 and 60 seconds). Required.
	Timeout *google_protobuf3.Duration `protobuf:"bytes,8,opt,name=timeout" json:"timeout,omitempty"`
	// The expected content on the page the check is run against.
	// Currently, only the first entry in the list is supported, and other entries
	// will be ignored. The server will look for an exact match of the string in
	// the page response's content. This field is optional and should only be
	// specified if a content match is required.
	ContentMatchers []*UptimeCheckConfig_ContentMatcher `protobuf:"bytes,9,rep,name=content_matchers,json=contentMatchers" json:"content_matchers,omitempty"`
	// The list of regions from which the check will be run.
	// If this field is specified, enough regions to include a minimum of
	// 3 locations must be provided, or an error message is returned.
	// Not specifying this field will result in uptime checks running from all
	// regions.
	SelectedRegions []UptimeCheckRegion `protobuf:"varint,10,rep,packed,name=selected_regions,json=selectedRegions,enum=google.monitoring.v3.UptimeCheckRegion" json:"selected_regions,omitempty"`
	// The internal checkers that this check will egress from.
	InternalCheckers []*UptimeCheckConfig_InternalChecker `protobuf:"bytes,14,rep,name=internal_checkers,json=internalCheckers" json:"internal_checkers,omitempty"`
}

func (m *UptimeCheckConfig) Reset()                    { *m = UptimeCheckConfig{} }
func (m *UptimeCheckConfig) String() string            { return proto.CompactTextString(m) }
func (*UptimeCheckConfig) ProtoMessage()               {}
func (*UptimeCheckConfig) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{0} }

type isUptimeCheckConfig_Resource interface {
	isUptimeCheckConfig_Resource()
}
type isUptimeCheckConfig_CheckRequestType interface {
	isUptimeCheckConfig_CheckRequestType()
}

type UptimeCheckConfig_MonitoredResource struct {
	MonitoredResource *google_api4.MonitoredResource `protobuf:"bytes,3,opt,name=monitored_resource,json=monitoredResource,oneof"`
}
type UptimeCheckConfig_ResourceGroup_ struct {
	ResourceGroup *UptimeCheckConfig_ResourceGroup `protobuf:"bytes,4,opt,name=resource_group,json=resourceGroup,oneof"`
}
type UptimeCheckConfig_HttpCheck_ struct {
	HttpCheck *UptimeCheckConfig_HttpCheck `protobuf:"bytes,5,opt,name=http_check,json=httpCheck,oneof"`
}
type UptimeCheckConfig_TcpCheck_ struct {
	TcpCheck *UptimeCheckConfig_TcpCheck `protobuf:"bytes,6,opt,name=tcp_check,json=tcpCheck,oneof"`
}

func (*UptimeCheckConfig_MonitoredResource) isUptimeCheckConfig_Resource()  {}
func (*UptimeCheckConfig_ResourceGroup_) isUptimeCheckConfig_Resource()     {}
func (*UptimeCheckConfig_HttpCheck_) isUptimeCheckConfig_CheckRequestType() {}
func (*UptimeCheckConfig_TcpCheck_) isUptimeCheckConfig_CheckRequestType()  {}

func (m *UptimeCheckConfig) GetResource() isUptimeCheckConfig_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}
func (m *UptimeCheckConfig) GetCheckRequestType() isUptimeCheckConfig_CheckRequestType {
	if m != nil {
		return m.CheckRequestType
	}
	return nil
}

func (m *UptimeCheckConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UptimeCheckConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *UptimeCheckConfig) GetMonitoredResource() *google_api4.MonitoredResource {
	if x, ok := m.GetResource().(*UptimeCheckConfig_MonitoredResource); ok {
		return x.MonitoredResource
	}
	return nil
}

func (m *UptimeCheckConfig) GetResourceGroup() *UptimeCheckConfig_ResourceGroup {
	if x, ok := m.GetResource().(*UptimeCheckConfig_ResourceGroup_); ok {
		return x.ResourceGroup
	}
	return nil
}

func (m *UptimeCheckConfig) GetHttpCheck() *UptimeCheckConfig_HttpCheck {
	if x, ok := m.GetCheckRequestType().(*UptimeCheckConfig_HttpCheck_); ok {
		return x.HttpCheck
	}
	return nil
}

func (m *UptimeCheckConfig) GetTcpCheck() *UptimeCheckConfig_TcpCheck {
	if x, ok := m.GetCheckRequestType().(*UptimeCheckConfig_TcpCheck_); ok {
		return x.TcpCheck
	}
	return nil
}

func (m *UptimeCheckConfig) GetPeriod() *google_protobuf3.Duration {
	if m != nil {
		return m.Period
	}
	return nil
}

func (m *UptimeCheckConfig) GetTimeout() *google_protobuf3.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *UptimeCheckConfig) GetContentMatchers() []*UptimeCheckConfig_ContentMatcher {
	if m != nil {
		return m.ContentMatchers
	}
	return nil
}

func (m *UptimeCheckConfig) GetSelectedRegions() []UptimeCheckRegion {
	if m != nil {
		return m.SelectedRegions
	}
	return nil
}

func (m *UptimeCheckConfig) GetInternalCheckers() []*UptimeCheckConfig_InternalChecker {
	if m != nil {
		return m.InternalCheckers
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UptimeCheckConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UptimeCheckConfig_OneofMarshaler, _UptimeCheckConfig_OneofUnmarshaler, _UptimeCheckConfig_OneofSizer, []interface{}{
		(*UptimeCheckConfig_MonitoredResource)(nil),
		(*UptimeCheckConfig_ResourceGroup_)(nil),
		(*UptimeCheckConfig_HttpCheck_)(nil),
		(*UptimeCheckConfig_TcpCheck_)(nil),
	}
}

func _UptimeCheckConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UptimeCheckConfig)
	// resource
	switch x := m.Resource.(type) {
	case *UptimeCheckConfig_MonitoredResource:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MonitoredResource); err != nil {
			return err
		}
	case *UptimeCheckConfig_ResourceGroup_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResourceGroup); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UptimeCheckConfig.Resource has unexpected type %T", x)
	}
	// check_request_type
	switch x := m.CheckRequestType.(type) {
	case *UptimeCheckConfig_HttpCheck_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpCheck); err != nil {
			return err
		}
	case *UptimeCheckConfig_TcpCheck_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TcpCheck); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UptimeCheckConfig.CheckRequestType has unexpected type %T", x)
	}
	return nil
}

func _UptimeCheckConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UptimeCheckConfig)
	switch tag {
	case 3: // resource.monitored_resource
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_api4.MonitoredResource)
		err := b.DecodeMessage(msg)
		m.Resource = &UptimeCheckConfig_MonitoredResource{msg}
		return true, err
	case 4: // resource.resource_group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UptimeCheckConfig_ResourceGroup)
		err := b.DecodeMessage(msg)
		m.Resource = &UptimeCheckConfig_ResourceGroup_{msg}
		return true, err
	case 5: // check_request_type.http_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UptimeCheckConfig_HttpCheck)
		err := b.DecodeMessage(msg)
		m.CheckRequestType = &UptimeCheckConfig_HttpCheck_{msg}
		return true, err
	case 6: // check_request_type.tcp_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UptimeCheckConfig_TcpCheck)
		err := b.DecodeMessage(msg)
		m.CheckRequestType = &UptimeCheckConfig_TcpCheck_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UptimeCheckConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UptimeCheckConfig)
	// resource
	switch x := m.Resource.(type) {
	case *UptimeCheckConfig_MonitoredResource:
		s := proto.Size(x.MonitoredResource)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UptimeCheckConfig_ResourceGroup_:
		s := proto.Size(x.ResourceGroup)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// check_request_type
	switch x := m.CheckRequestType.(type) {
	case *UptimeCheckConfig_HttpCheck_:
		s := proto.Size(x.HttpCheck)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UptimeCheckConfig_TcpCheck_:
		s := proto.Size(x.TcpCheck)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The resource submessage for group checks. It can be used instead of a
// monitored resource, when multiple resources are being monitored.
type UptimeCheckConfig_ResourceGroup struct {
	// The group of resources being monitored. Should be only the
	// group_id, not projects/<project_id>/groups/<group_id>.
	GroupId string `protobuf:"bytes,1,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	// The resource type of the group members.
	ResourceType GroupResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,enum=google.monitoring.v3.GroupResourceType" json:"resource_type,omitempty"`
}

func (m *UptimeCheckConfig_ResourceGroup) Reset()         { *m = UptimeCheckConfig_ResourceGroup{} }
func (m *UptimeCheckConfig_ResourceGroup) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_ResourceGroup) ProtoMessage()    {}
func (*UptimeCheckConfig_ResourceGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor10, []int{0, 0}
}

func (m *UptimeCheckConfig_ResourceGroup) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *UptimeCheckConfig_ResourceGroup) GetResourceType() GroupResourceType {
	if m != nil {
		return m.ResourceType
	}
	return GroupResourceType_RESOURCE_TYPE_UNSPECIFIED
}

// Information involved in an HTTP/HTTPS uptime check request.
type UptimeCheckConfig_HttpCheck struct {
	// If true, use HTTPS instead of HTTP to run the check.
	UseSsl bool `protobuf:"varint,1,opt,name=use_ssl,json=useSsl" json:"use_ssl,omitempty"`
	// The path to the page to run the check against. Will be combined with the
	// host (specified within the MonitoredResource) and port to construct the
	// full URL. Optional (defaults to "/").
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// The port to the page to run the check against. Will be combined with host
	// (specified within the MonitoredResource) and path to construct the full
	// URL. Optional (defaults to 80 without SSL, or 443 with SSL).
	Port int32 `protobuf:"varint,3,opt,name=port" json:"port,omitempty"`
	// The authentication information. Optional when creating an HTTP check;
	// defaults to empty.
	AuthInfo *UptimeCheckConfig_HttpCheck_BasicAuthentication `protobuf:"bytes,4,opt,name=auth_info,json=authInfo" json:"auth_info,omitempty"`
	// Boolean specifiying whether to encrypt the header information.
	// Encryption should be specified for any headers related to authentication
	// that you do not wish to be seen when retrieving the configuration. The
	// server will be responsible for encrypting the headers.
	// On Get/List calls, if mask_headers is set to True then the headers
	// will be obscured with ******.
	MaskHeaders bool `protobuf:"varint,5,opt,name=mask_headers,json=maskHeaders" json:"mask_headers,omitempty"`
	// The list of headers to send as part of the uptime check request.
	// If two headers have the same key and different values, they should
	// be entered as a single header, with the value being a comma-separated
	// list of all the desired values as described at
	// https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
	// Entering two separate headers with the same key in a Create call will
	// cause the first to be overwritten by the second.
	Headers map[string]string `protobuf:"bytes,6,rep,name=headers" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *UptimeCheckConfig_HttpCheck) Reset()                    { *m = UptimeCheckConfig_HttpCheck{} }
func (m *UptimeCheckConfig_HttpCheck) String() string            { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_HttpCheck) ProtoMessage()               {}
func (*UptimeCheckConfig_HttpCheck) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{0, 1} }

func (m *UptimeCheckConfig_HttpCheck) GetUseSsl() bool {
	if m != nil {
		return m.UseSsl
	}
	return false
}

func (m *UptimeCheckConfig_HttpCheck) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *UptimeCheckConfig_HttpCheck) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *UptimeCheckConfig_HttpCheck) GetAuthInfo() *UptimeCheckConfig_HttpCheck_BasicAuthentication {
	if m != nil {
		return m.AuthInfo
	}
	return nil
}

func (m *UptimeCheckConfig_HttpCheck) GetMaskHeaders() bool {
	if m != nil {
		return m.MaskHeaders
	}
	return false
}

func (m *UptimeCheckConfig_HttpCheck) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

// A type of authentication to perform against the specified resource or URL
// that uses username and password.
// Currently, only Basic authentication is supported in Uptime Monitoring.
type UptimeCheckConfig_HttpCheck_BasicAuthentication struct {
	// The username to authenticate.
	Username string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	// The password to authenticate.
	Password string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) Reset() {
	*m = UptimeCheckConfig_HttpCheck_BasicAuthentication{}
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) String() string {
	return proto.CompactTextString(m)
}
func (*UptimeCheckConfig_HttpCheck_BasicAuthentication) ProtoMessage() {}
func (*UptimeCheckConfig_HttpCheck_BasicAuthentication) Descriptor() ([]byte, []int) {
	return fileDescriptor10, []int{0, 1, 0}
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// Information required for a TCP uptime check request.
type UptimeCheckConfig_TcpCheck struct {
	// The port to the page to run the check against. Will be combined with host
	// (specified within the MonitoredResource) to construct the full URL.
	// Required.
	Port int32 `protobuf:"varint,1,opt,name=port" json:"port,omitempty"`
}

func (m *UptimeCheckConfig_TcpCheck) Reset()                    { *m = UptimeCheckConfig_TcpCheck{} }
func (m *UptimeCheckConfig_TcpCheck) String() string            { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_TcpCheck) ProtoMessage()               {}
func (*UptimeCheckConfig_TcpCheck) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{0, 2} }

func (m *UptimeCheckConfig_TcpCheck) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Used to perform string matching. Currently, this matches on the exact
// content. In the future, it can be expanded to allow for regular expressions
// and more complex matching.
type UptimeCheckConfig_ContentMatcher struct {
	// String content to match
	Content string `protobuf:"bytes,1,opt,name=content" json:"content,omitempty"`
}

func (m *UptimeCheckConfig_ContentMatcher) Reset()         { *m = UptimeCheckConfig_ContentMatcher{} }
func (m *UptimeCheckConfig_ContentMatcher) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_ContentMatcher) ProtoMessage()    {}
func (*UptimeCheckConfig_ContentMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor10, []int{0, 3}
}

func (m *UptimeCheckConfig_ContentMatcher) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

// Nimbus InternalCheckers.
type UptimeCheckConfig_InternalChecker struct {
	// The GCP project ID. Not necessarily the same as the project_id for the config.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The internal network to perform this uptime check on.
	Network string `protobuf:"bytes,2,opt,name=network" json:"network,omitempty"`
	// The GCP zone the uptime check should egress from. Only respected for
	// internal uptime checks, where internal_network is specified.
	GcpZone string `protobuf:"bytes,3,opt,name=gcp_zone,json=gcpZone" json:"gcp_zone,omitempty"`
	// The checker ID.
	CheckerId string `protobuf:"bytes,4,opt,name=checker_id,json=checkerId" json:"checker_id,omitempty"`
	// The checker's human-readable name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *UptimeCheckConfig_InternalChecker) Reset()         { *m = UptimeCheckConfig_InternalChecker{} }
func (m *UptimeCheckConfig_InternalChecker) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_InternalChecker) ProtoMessage()    {}
func (*UptimeCheckConfig_InternalChecker) Descriptor() ([]byte, []int) {
	return fileDescriptor10, []int{0, 4}
}

func (m *UptimeCheckConfig_InternalChecker) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UptimeCheckConfig_InternalChecker) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *UptimeCheckConfig_InternalChecker) GetGcpZone() string {
	if m != nil {
		return m.GcpZone
	}
	return ""
}

func (m *UptimeCheckConfig_InternalChecker) GetCheckerId() string {
	if m != nil {
		return m.CheckerId
	}
	return ""
}

func (m *UptimeCheckConfig_InternalChecker) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// Contains the region, location, and list of IP
// addresses where checkers in the location run from.
type UptimeCheckIp struct {
	// A broad region category in which the IP address is located.
	Region UptimeCheckRegion `protobuf:"varint,1,opt,name=region,enum=google.monitoring.v3.UptimeCheckRegion" json:"region,omitempty"`
	// A more specific location within the region that typically encodes
	// a particular city/town/metro (and its containing state/province or country)
	// within the broader umbrella region category.
	Location string `protobuf:"bytes,2,opt,name=location" json:"location,omitempty"`
	// The IP address from which the uptime check originates. This is a full
	// IP address (not an IP address range). Most IP addresses, as of this
	// publication, are in IPv4 format; however, one should not rely on the
	// IP addresses being in IPv4 format indefinitely and should support
	// interpreting this field in either IPv4 or IPv6 format.
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress" json:"ip_address,omitempty"`
}

func (m *UptimeCheckIp) Reset()                    { *m = UptimeCheckIp{} }
func (m *UptimeCheckIp) String() string            { return proto.CompactTextString(m) }
func (*UptimeCheckIp) ProtoMessage()               {}
func (*UptimeCheckIp) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{1} }

func (m *UptimeCheckIp) GetRegion() UptimeCheckRegion {
	if m != nil {
		return m.Region
	}
	return UptimeCheckRegion_REGION_UNSPECIFIED
}

func (m *UptimeCheckIp) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *UptimeCheckIp) GetIpAddress() string {
	if m != nil {
		return m.IpAddress
	}
	return ""
}

func init() {
	proto.RegisterType((*UptimeCheckConfig)(nil), "google.monitoring.v3.UptimeCheckConfig")
	proto.RegisterType((*UptimeCheckConfig_ResourceGroup)(nil), "google.monitoring.v3.UptimeCheckConfig.ResourceGroup")
	proto.RegisterType((*UptimeCheckConfig_HttpCheck)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck")
	proto.RegisterType((*UptimeCheckConfig_HttpCheck_BasicAuthentication)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication")
	proto.RegisterType((*UptimeCheckConfig_TcpCheck)(nil), "google.monitoring.v3.UptimeCheckConfig.TcpCheck")
	proto.RegisterType((*UptimeCheckConfig_ContentMatcher)(nil), "google.monitoring.v3.UptimeCheckConfig.ContentMatcher")
	proto.RegisterType((*UptimeCheckConfig_InternalChecker)(nil), "google.monitoring.v3.UptimeCheckConfig.InternalChecker")
	proto.RegisterType((*UptimeCheckIp)(nil), "google.monitoring.v3.UptimeCheckIp")
	proto.RegisterEnum("google.monitoring.v3.UptimeCheckRegion", UptimeCheckRegion_name, UptimeCheckRegion_value)
	proto.RegisterEnum("google.monitoring.v3.GroupResourceType", GroupResourceType_name, GroupResourceType_value)
}

func init() { proto.RegisterFile("google/monitoring/v3/uptime.proto", fileDescriptor10) }

var fileDescriptor10 = []byte{
	// 1021 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xdd, 0x4e, 0xe3, 0x46,
	0x14, 0x5e, 0x13, 0xc8, 0xcf, 0x21, 0xb0, 0x66, 0x4a, 0xdb, 0x60, 0x89, 0x15, 0xbb, 0xbd, 0x28,
	0xe2, 0xc2, 0xe9, 0x12, 0xf5, 0x47, 0x5b, 0x69, 0x2b, 0x27, 0xb8, 0xc4, 0x12, 0x24, 0xd1, 0x84,
	0x6c, 0xdb, 0x2d, 0xaa, 0x65, 0xec, 0x21, 0x71, 0x49, 0x3c, 0xae, 0x67, 0xcc, 0x96, 0xbe, 0x42,
	0x1f, 0xa3, 0x17, 0x95, 0xfa, 0x04, 0x7d, 0x86, 0xbe, 0x4d, 0xdf, 0xa0, 0x9a, 0xf1, 0x4c, 0x20,
	0x40, 0xb5, 0x70, 0x37, 0xdf, 0xf9, 0xf9, 0xe6, 0x1c, 0x9f, 0x9f, 0x31, 0x3c, 0x1f, 0x53, 0x3a,
	0x9e, 0x92, 0xe6, 0x8c, 0x26, 0x31, 0xa7, 0x59, 0x9c, 0x8c, 0x9b, 0x97, 0xad, 0x66, 0x9e, 0xf2,
	0x78, 0x46, 0xec, 0x34, 0xa3, 0x9c, 0xa2, 0xcd, 0xc2, 0xc4, 0xbe, 0x36, 0xb1, 0x2f, 0x5b, 0xd6,
	0x27, 0xca, 0x31, 0x48, 0x63, 0xed, 0x4c, 0x22, 0x3f, 0x23, 0x8c, 0xe6, 0x59, 0xa8, 0x5c, 0xad,
	0x67, 0xca, 0x48, 0xa2, 0xb3, 0xfc, 0xbc, 0x19, 0xe5, 0x59, 0xc0, 0x63, 0x9a, 0x14, 0xfa, 0x17,
	0xff, 0xd6, 0x61, 0x63, 0x24, 0xef, 0xea, 0x4c, 0x48, 0x78, 0xd1, 0xa1, 0xc9, 0x79, 0x3c, 0x46,
	0x08, 0x96, 0x93, 0x60, 0x46, 0x1a, 0xc6, 0x8e, 0xb1, 0x5b, 0xc3, 0xf2, 0x8c, 0x9e, 0x43, 0x3d,
	0x8a, 0x59, 0x3a, 0x0d, 0xae, 0x7c, 0xa9, 0x5b, 0x92, 0xba, 0x55, 0x25, 0xeb, 0x09, 0x93, 0x1e,
	0xa0, 0xbb, 0x81, 0x34, 0x4a, 0x3b, 0xc6, 0xee, 0xea, 0xfe, 0xb6, 0xad, 0x92, 0x08, 0xd2, 0xd8,
	0x3e, 0xd6, 0x56, 0x58, 0x19, 0x75, 0x9f, 0xe0, 0x8d, 0xd9, 0x6d, 0x21, 0xfa, 0x09, 0xd6, 0x35,
	0x8b, 0x3f, 0xce, 0x68, 0x9e, 0x36, 0x96, 0x25, 0xd7, 0xe7, 0xf6, 0x7d, 0x1f, 0xc4, 0xbe, 0x93,
	0x87, 0xad, 0x99, 0x0e, 0x85, 0x73, 0xf7, 0x09, 0x5e, 0xcb, 0x6e, 0x0a, 0x10, 0x06, 0x98, 0x70,
	0x9e, 0xfa, 0xa1, 0x70, 0x69, 0xac, 0x48, 0xee, 0x97, 0x0f, 0xe5, 0xee, 0x72, 0x9e, 0x4a, 0xdc,
	0x35, 0x70, 0x6d, 0xa2, 0x01, 0xea, 0x43, 0x8d, 0x87, 0x9a, 0xb2, 0x2c, 0x29, 0x3f, 0x7b, 0x28,
	0xe5, 0x49, 0x38, 0x67, 0xac, 0x72, 0x75, 0x46, 0x2f, 0xa1, 0x9c, 0x92, 0x2c, 0xa6, 0x51, 0xa3,
	0x22, 0xd9, 0xb6, 0x34, 0x9b, 0x2e, 0xa9, 0x7d, 0xa0, 0x4a, 0x8a, 0x95, 0x21, 0x6a, 0x41, 0x45,
	0x50, 0xd3, 0x9c, 0x37, 0xaa, 0xef, 0xf3, 0xd1, 0x96, 0x28, 0x00, 0x33, 0xa4, 0x09, 0x27, 0x09,
	0xf7, 0x67, 0x01, 0x0f, 0x27, 0x24, 0x63, 0x8d, 0xda, 0x4e, 0x69, 0x77, 0x75, 0xff, 0x8b, 0x87,
	0xc6, 0xdf, 0x29, 0xfc, 0x8f, 0x0b, 0x77, 0xfc, 0x34, 0x5c, 0xc0, 0x0c, 0x61, 0x30, 0x19, 0x99,
	0x92, 0x90, 0xcb, 0xf6, 0x18, 0xc7, 0x34, 0x61, 0x0d, 0xd8, 0x29, 0xed, 0xae, 0xef, 0x7f, 0xfa,
	0xde, 0x2b, 0xb0, 0xb4, 0xc7, 0x4f, 0x35, 0x41, 0x81, 0x19, 0x8a, 0x60, 0x23, 0x4e, 0x38, 0xc9,
	0x92, 0x60, 0x5a, 0x7c, 0x74, 0x11, 0xf7, 0xba, 0x8c, 0xfb, 0xcb, 0x87, 0xc6, 0xed, 0x29, 0x82,
	0x4e, 0xe1, 0x8f, 0xcd, 0x78, 0x51, 0xc0, 0xac, 0x5f, 0x61, 0x6d, 0xa1, 0x97, 0xd0, 0x16, 0x54,
	0x65, 0x47, 0xfa, 0x71, 0xa4, 0xa6, 0xa4, 0x22, 0xb1, 0x17, 0xa1, 0x23, 0x98, 0xb7, 0x99, 0xcf,
	0xaf, 0xd2, 0x62, 0x52, 0xfe, 0x37, 0x45, 0x49, 0xa7, 0xb9, 0x4f, 0xae, 0x52, 0x82, 0xeb, 0xd9,
	0x0d, 0x64, 0xfd, 0x5d, 0x82, 0xda, 0xbc, 0xd5, 0xd0, 0xc7, 0x50, 0xc9, 0x19, 0xf1, 0x19, 0x9b,
	0xca, 0x5b, 0xab, 0xb8, 0x9c, 0x33, 0x32, 0x64, 0x53, 0x31, 0xb1, 0x69, 0xc0, 0x27, 0x6a, 0x2a,
	0xe5, 0x59, 0xca, 0x68, 0xc6, 0xe5, 0x00, 0xae, 0x60, 0x79, 0x46, 0x67, 0x50, 0x0b, 0x72, 0x3e,
	0xf1, 0xe3, 0xe4, 0x9c, 0xaa, 0x69, 0x72, 0x1f, 0xdd, 0xf1, 0x76, 0x3b, 0x60, 0x71, 0xe8, 0xe4,
	0x7c, 0x42, 0x12, 0x1e, 0x87, 0x45, 0x23, 0x55, 0x05, 0xaf, 0x97, 0x9c, 0x53, 0xb1, 0x29, 0x66,
	0x01, 0xbb, 0xf0, 0x27, 0x24, 0x88, 0x44, 0x35, 0x56, 0x64, 0xa4, 0xab, 0x42, 0xd6, 0x2d, 0x44,
	0xe8, 0x7b, 0xa8, 0x68, 0x6d, 0x59, 0xd6, 0xea, 0xf5, 0xe3, 0x83, 0x50, 0x5c, 0x6e, 0xc2, 0xb3,
	0x2b, 0xac, 0xe9, 0xac, 0x63, 0xf8, 0xe0, 0x9e, 0xe8, 0x90, 0x05, 0xd5, 0x9c, 0x89, 0x9a, 0xce,
	0xb7, 0xda, 0x1c, 0x0b, 0x5d, 0x1a, 0x30, 0xf6, 0x8e, 0x66, 0x91, 0xfa, 0x7e, 0x73, 0x6c, 0xbd,
	0x82, 0xfa, 0xcd, 0x7b, 0x90, 0x09, 0xa5, 0x0b, 0x72, 0xa5, 0x28, 0xc4, 0x11, 0x6d, 0xc2, 0xca,
	0x65, 0x30, 0xcd, 0xf5, 0x42, 0x2c, 0xc0, 0xab, 0xa5, 0xaf, 0x0c, 0xeb, 0x19, 0x54, 0xf5, 0x44,
	0xcf, 0x6b, 0x61, 0x5c, 0xd7, 0xc2, 0xda, 0x83, 0xf5, 0xc5, 0x89, 0x41, 0x0d, 0xa8, 0xa8, 0x99,
	0xd1, 0x4d, 0xa5, 0xa0, 0xf5, 0xa7, 0x01, 0x4f, 0x6f, 0xb5, 0x29, 0xda, 0x06, 0x48, 0x33, 0xfa,
	0x33, 0x09, 0xf9, 0x75, 0x17, 0xd6, 0x94, 0xc4, 0x8b, 0x04, 0x59, 0x42, 0xf8, 0x3b, 0x9a, 0x5d,
	0xa8, 0xd0, 0x34, 0x94, 0xcd, 0x1b, 0xa6, 0xfe, 0x6f, 0x34, 0x29, 0xb6, 0xb3, 0x68, 0xde, 0x30,
	0x7d, 0x4b, 0x13, 0x22, 0x38, 0xd5, 0x14, 0x09, 0xce, 0xe5, 0x82, 0x53, 0x49, 0xbc, 0xe8, 0xce,
	0x23, 0xb0, 0x72, 0xe7, 0x11, 0x68, 0x03, 0x54, 0x75, 0x03, 0xb7, 0x37, 0x01, 0x49, 0x5f, 0x3f,
	0x23, 0xbf, 0xe4, 0x84, 0x71, 0x39, 0x0f, 0x2f, 0x7e, 0x37, 0x60, 0xed, 0x46, 0x61, 0xbd, 0x14,
	0x7d, 0x03, 0xe5, 0x62, 0x1f, 0xc8, 0x2c, 0x1e, 0xb1, 0x0e, 0x94, 0x9b, 0x28, 0xe1, 0x94, 0x16,
	0xa5, 0xd6, 0x25, 0xd4, 0x58, 0xa4, 0x14, 0xa7, 0x7e, 0x10, 0x45, 0x19, 0x61, 0x4c, 0xe5, 0x5b,
	0x8b, 0x53, 0xa7, 0x10, 0xec, 0x91, 0x85, 0x07, 0xb0, 0xe0, 0x45, 0x1f, 0x01, 0xc2, 0xee, 0xa1,
	0xd7, 0xef, 0xf9, 0xa3, 0xde, 0x70, 0xe0, 0x76, 0xbc, 0x6f, 0x3d, 0xf7, 0xc0, 0x7c, 0x82, 0x2a,
	0x50, 0x1a, 0x0d, 0x1d, 0xd3, 0x40, 0x00, 0x65, 0x77, 0x84, 0xfb, 0x03, 0xd7, 0x5c, 0x42, 0x1b,
	0xb0, 0x36, 0xec, 0x8f, 0x4e, 0xba, 0xbe, 0x73, 0xec, 0x62, 0xaf, 0xe3, 0x98, 0x25, 0x64, 0x42,
	0xdd, 0x19, 0x7a, 0x8e, 0x3f, 0x70, 0x84, 0x6b, 0xc7, 0x5c, 0xde, 0xfb, 0x11, 0x36, 0xee, 0x8c,
	0x3a, 0xda, 0x86, 0x2d, 0xec, 0x0e, 0xfb, 0x23, 0xdc, 0x71, 0xfd, 0x93, 0x1f, 0x06, 0xee, 0xad,
	0xdb, 0xea, 0x50, 0xf5, 0x7a, 0xc3, 0x13, 0xa7, 0xd7, 0x71, 0x4d, 0x03, 0x6d, 0xc1, 0x87, 0xce,
	0x77, 0x43, 0xdf, 0x3d, 0x6a, 0xfb, 0x47, 0x7d, 0xe7, 0xc0, 0x6f, 0x3b, 0x47, 0x42, 0x83, 0xcd,
	0xa5, 0xf6, 0x1f, 0x06, 0x34, 0x42, 0x3a, 0xbb, 0xf7, 0xab, 0xb5, 0x57, 0x8b, 0xf4, 0x06, 0x62,
	0xf5, 0x0f, 0x8c, 0xb7, 0xaf, 0x95, 0xd1, 0x98, 0x4e, 0x83, 0x64, 0x6c, 0xd3, 0x6c, 0xdc, 0x1c,
	0x93, 0x44, 0x3e, 0x0c, 0xcd, 0x42, 0x15, 0xa4, 0x31, 0x5b, 0xfc, 0x1d, 0xf9, 0xfa, 0x1a, 0xfd,
	0xb5, 0x64, 0x1d, 0x16, 0x04, 0x9d, 0x29, 0xcd, 0x23, 0xfd, 0x94, 0x8b, 0xbb, 0xde, 0xb4, 0xfe,
	0xd1, 0xca, 0x53, 0xa9, 0x3c, 0xbd, 0x56, 0x9e, 0xbe, 0x69, 0x9d, 0x95, 0xe5, 0x25, 0xad, 0xff,
	0x02, 0x00, 0x00, 0xff, 0xff, 0xc9, 0xa5, 0xbc, 0x87, 0xf2, 0x08, 0x00, 0x00,
}
