//==-- input_arrays.h - Helper function for LLVM fuzzer inputs -------------==//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// Define a few static variables used by the LLVM Proto Fuzzer
//
//===----------------------------------------------------------------------===//

#include <climits>

static const int kArraySize = 64;
static const int kNumArrays = 93;
static const int kTotalSize = sizeof(int) * kArraySize * kNumArrays;

// Define two arrays that will hold the input and output for the two functions
static int OptArrays[kNumArrays][kArraySize];
static int UnoptArrays[kNumArrays][kArraySize];

// Define a corpus of possible inputs
static int InputArrays[kNumArrays][kArraySize] =
{ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
  {INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX},
  {INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN},
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16},
  {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255},
  {1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024},
  {65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 0, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535},
  {-1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023},
  {INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX},
  {0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, },
  {1, 1, 0, 3, 2, 5, 6, 2, 6, 3, 0, 19, 18, 17, 16, 0, 13, 11, 9, 7, 5, 3, 1, -3000, -3000, -3000, -3000, -3000, -3000, -3000, 0, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000},
  {1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824},
  {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0},
  {0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, },
  {-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0},
  {1, 1, 2, 1, 6, 9, 10, 7, 2, 10, 4, 11, 10, 11, 0, 19, 26, 18, 10, 2, 14, 7, 0, 39, 34, 29, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91},
  {0, 0, 2, 0, 0, 1, 6, 9, 4, 12, 6, 13, 12, 0, 2, 21, 28, 20, 12, 4, 16, 9, 2, 41, 36, 31, 26, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93},
  {1, 1, 0, 2, 2, 3, 8, 11, 6, 14, 8, 15, 14, 2, 4, 23, 30, 22, 14, 6, 18, 11, 4, 43, 38, 33, 28, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95},
  {0, 0, 0, 4, 0, 0, 10, 13, 0, 16, 0, 17, 16, 4, 6, 25, 16, 24, 16, 8, 0, 13, 6, 45, 40, 35, 30, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97},
  {1, 1, 2, 3, 2, 2, 0, 1, 2, 9, 2, 19, 18, 6, 8, 27, 18, 26, 18, 10, 2, 15, 8, 1, 42, 37, 32, 27, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 107, 106, 105, 104, 103, 102, 101, 100, 99},
  {0, 0, 2, 5, 4, 4, 2, 3, 4, 11, 4, 21, 20, 8, 10, 29, 20, 28, 20, 12, 4, 17, 10, 3, 44, 39, 34, 29, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 109, 108, 107, 106, 105, 104, 103, 102, 101},
  {1, 1, 0, 1, 6, 6, 4, 5, 6, 13, 6, 1, 22, 10, 12, 1, 22, 30, 22, 14, 6, 19, 12, 5, 46, 41, 36, 31, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 40, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 110, 109, 108, 107, 106, 105, 104, 103},
  {0, 0, 0, 0, 4, 8, 0, 0, 8, 15, 8, 3, 12, 12, 0, 3, 24, 32, 24, 16, 8, 0, 14, 7, 0, 43, 38, 33, 28, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 111, 110, 109, 108, 107, 106, 105},
  {1, 1, 2, 2, 6, 5, 2, 2, 10, 17, 10, 5, 14, 14, 2, 5, 26, 17, 26, 18, 10, 2, 16, 9, 2, 45, 40, 35, 30, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 41, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 113, 112, 111, 110, 109, 108, 107},
  {0, 0, 2, 4, 0, 7, 4, 4, 12, 1, 12, 7, 16, 16, 4, 7, 28, 19, 28, 20, 12, 4, 18, 11, 4, 47, 42, 37, 32, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 40, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 114, 113, 112, 111, 110, 109},
  {1, 1, 0, 3, 2, 9, 6, 6, 14, 3, 14, 9, 18, 18, 6, 9, 30, 21, 30, 22, 14, 6, 20, 13, 6, 49, 44, 39, 34, 29, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 42, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 115, 114, 113, 112, 111},
  {1, 1, 0, 3, 2, 5, 6, 2, 6, 3, 0, 19, 18, 17, 16, 0, 13, 11, 9, 7, 5, 3, 1, -3000, -3000, -3000, -3000, -3000, -3000, -3000, 0, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000},
  {1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824},
  {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0},
  {0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, },
  {-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0},
  {1, 1, 2, 1, 6, 9, 10, 7, 2, 10, 4, 11, 10, 11, 0, 19, 26, 18, 10, 2, 14, 7, 0, 39, 34, 29, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91},
  {0, 0, 2, 0, 0, 1, 6, 9, 4, 12, 6, 13, 12, 0, 2, 21, 28, 20, 12, 4, 16, 9, 2, 41, 36, 31, 26, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93},
  {1, 1, 0, 2, 2, 3, 8, 11, 6, 14, 8, 15, 14, 2, 4, 23, 30, 22, 14, 6, 18, 11, 4, 43, 38, 33, 28, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95},
  {0, 0, 0, 4, 0, 0, 10, 13, 0, 16, 0, 17, 16, 4, 6, 25, 16, 24, 16, 8, 0, 13, 6, 45, 40, 35, 30, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97},
  {1, 1, 2, 3, 2, 2, 0, 1, 2, 9, 2, 19, 18, 6, 8, 27, 18, 26, 18, 10, 2, 15, 8, 1, 42, 37, 32, 27, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 107, 106, 105, 104, 103, 102, 101, 100, 99},
  {0, 0, 2, 5, 4, 4, 2, 3, 4, 11, 4, 21, 20, 8, 10, 29, 20, 28, 20, 12, 4, 17, 10, 3, 44, 39, 34, 29, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 109, 108, 107, 106, 105, 104, 103, 102, 101},
  {1, 1, 0, 1, 6, 6, 4, 5, 6, 13, 6, 1, 22, 10, 12, 1, 22, 30, 22, 14, 6, 19, 12, 5, 46, 41, 36, 31, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 40, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 110, 109, 108, 107, 106, 105, 104, 103},
  {0, 0, 0, 0, 4, 8, 0, 0, 8, 15, 8, 3, 12, 12, 0, 3, 24, 32, 24, 16, 8, 0, 14, 7, 0, 43, 38, 33, 28, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 111, 110, 109, 108, 107, 106, 105},
  {1, 1, 2, 2, 6, 5, 2, 2, 10, 17, 10, 5, 14, 14, 2, 5, 26, 17, 26, 18, 10, 2, 16, 9, 2, 45, 40, 35, 30, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 41, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 113, 112, 111, 110, 109, 108, 107},
  {0, 0, 2, 4, 0, 7, 4, 4, 12, 1, 12, 7, 16, 16, 4, 7, 28, 19, 28, 20, 12, 4, 18, 11, 4, 47, 42, 37, 32, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 40, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 114, 113, 112, 111, 110, 109},
  {1, 1, 0, 3, 2, 9, 6, 6, 14, 3, 14, 9, 18, 18, 6, 9, 30, 21, 30, 22, 14, 6, 20, 13, 6, 49, 44, 39, 34, 29, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 42, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 115, 114, 113, 112, 111},
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
  {INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX},
  {INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN},
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16},
  {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255},
  {1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024},
  {65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 0, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535},
  {-1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023},
  {INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX},
  {0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, },
  {0, 0, 2, 0, 0, 1, 6, 9, 4, 12, 6, 13, 12, 0, 2, 21, 28, 20, 12, 4, 16, 9, 2, 41, 36, 31, 26, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93},
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 0, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535},
  {INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX},
  {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16},
  {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255},
  {0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, 0, -1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, },
  {1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024},
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  {0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, },
  {1, 1, 0, 3, 2, 5, 6, 2, 6, 3, 0, 19, 18, 17, 16, 0, 13, 11, 9, 7, 5, 3, 1, -3000, -3000, -3000, -3000, -3000, -3000, -3000, 0, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000},
  {0, 0, 2, 5, 4, 4, 2, 3, 4, 11, 4, 21, 20, 8, 10, 29, 20, 28, 20, 12, 4, 17, 10, 3, 44, 39, 34, 29, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 109, 108, 107, 106, 105, 104, 103, 102, 101},
  {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
  {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0},
  {-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0},
  {1, 1, 2, 1, 6, 9, 10, 7, 2, 10, 4, 11, 10, 11, 0, 19, 26, 18, 10, 2, 14, 7, 0, 39, 34, 29, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91},
  {0, 0, 2, 4, 0, 7, 4, 4, 12, 1, 12, 7, 16, 16, 4, 7, 28, 19, 28, 20, 12, 4, 18, 11, 4, 47, 42, 37, 32, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 40, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 114, 113, 112, 111, 110, 109},
  {1, 1, 0, 2, 2, 3, 8, 11, 6, 14, 8, 15, 14, 2, 4, 23, 30, 22, 14, 6, 18, 11, 4, 43, 38, 33, 28, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95},
  {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
  {INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN, INT_MIN},
  {0, 0, 0, 4, 0, 0, 10, 13, 0, 16, 0, 17, 16, 4, 6, 25, 16, 24, 16, 8, 0, 13, 6, 45, 40, 35, 30, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97},
  {1, 1, 2, 3, 2, 2, 0, 1, 2, 9, 2, 19, 18, 6, 8, 27, 18, 26, 18, 10, 2, 15, 8, 1, 42, 37, 32, 27, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 107, 106, 105, 104, 103, 102, 101, 100, 99},
  {1, 1, 0, 1, 6, 6, 4, 5, 6, 13, 6, 1, 22, 10, 12, 1, 22, 30, 22, 14, 6, 19, 12, 5, 46, 41, 36, 31, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 40, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7, 4, 1, 110, 109, 108, 107, 106, 105, 104, 103},
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  {-1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023, -1023},
  {0, 0, 0, 0, 4, 8, 0, 0, 8, 15, 8, 3, 12, 12, 0, 3, 24, 32, 24, 16, 8, 0, 14, 7, 0, 43, 38, 33, 28, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 111, 110, 109, 108, 107, 106, 105},
  {1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824, 1073741824},
  {1, 1, 2, 2, 6, 5, 2, 2, 10, 17, 10, 5, 14, 14, 2, 5, 26, 17, 26, 18, 10, 2, 16, 9, 2, 45, 40, 35, 30, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 41, 38, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 5, 2, 113, 112, 111, 110, 109, 108, 107},
  {1, 1, 0, 3, 2, 9, 6, 6, 14, 3, 14, 9, 18, 18, 6, 9, 30, 21, 30, 22, 14, 6, 20, 13, 6, 49, 44, 39, 34, 29, 54, 50, 46, 42, 38, 34, 30, 26, 22, 18, 14, 10, 6, 2, 42, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 115, 114, 113, 112, 111},
  {INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX, INT_MAX, INT_MIN, INT_MAX, INT_MAX, INT_MAX} };
