; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+xtheadbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32XTHEADBS

define i32 @th_tst_i32(i32 %a) nounwind {
; RV32I-LABEL: th_tst_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 26
; RV32I-NEXT:    srli a0, a0, 31
; RV32I-NEXT:    ret
;
; RV32XTHEADBS-LABEL: th_tst_i32:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV32XTHEADBS-NEXT:    ret
  %shr = lshr i32 %a, 5
  %and = and i32 %shr, 1
  ret i32 %and
}

define i64 @th_tst_i64(i64 %a) nounwind {
; RV32I-LABEL: th_tst_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 26
; RV32I-NEXT:    srli a0, a0, 31
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32XTHEADBS-LABEL: th_tst_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV32XTHEADBS-NEXT:    li a1, 0
; RV32XTHEADBS-NEXT:    ret
  %shr = lshr i64 %a, 5
  %and = and i64 %shr, 1
  ret i64 %and
}

define signext i32 @th_tst_i32_cmp(i32 signext %a) nounwind {
; RV32I-LABEL: th_tst_i32_cmp:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 26
; RV32I-NEXT:    srli a0, a0, 31
; RV32I-NEXT:    ret
;
; RV32XTHEADBS-LABEL: th_tst_i32_cmp:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV32XTHEADBS-NEXT:    ret
  %and = and i32 %a, 32
  %cmp = icmp ne i32 %and, 0
  %zext = zext i1 %cmp to i32
  ret i32 %zext
}

define i64 @th_tst_i64_cmp(i64 %a) nounwind {
; RV32I-LABEL: th_tst_i64_cmp:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 26
; RV32I-NEXT:    srli a0, a0, 31
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32XTHEADBS-LABEL: th_tst_i64_cmp:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV32XTHEADBS-NEXT:    li a1, 0
; RV32XTHEADBS-NEXT:    ret
  %and = and i64 %a, 32
  %cmp = icmp ne i64 %and, 0
  %zext = zext i1 %cmp to i64
  ret i64 %zext
}

