/* math-function-popover.c generated by valac 0.40.6, the Vala compiler
 * generated from math-function-popover.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_MATH_FUNCTION_POPOVER (math_function_popover_get_type ())
#define MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover))
#define MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))
#define IS_MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPOVER))
#define IS_MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPOVER))
#define MATH_FUNCTION_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))

typedef struct _MathFunctionPopover MathFunctionPopover;
typedef struct _MathFunctionPopoverClass MathFunctionPopoverClass;
typedef struct _MathFunctionPopoverPrivate MathFunctionPopoverPrivate;
enum  {
	MATH_FUNCTION_POPOVER_0_PROPERTY,
	MATH_FUNCTION_POPOVER_NUM_PROPERTIES
};
static GParamSpec* math_function_popover_properties[MATH_FUNCTION_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MathFunctionPopover {
	GtkPopover parent_instance;
	MathFunctionPopoverPrivate * priv;
};

struct _MathFunctionPopoverClass {
	GtkPopoverClass parent_class;
};

struct _MathFunctionPopoverPrivate {
	MathEquation* equation;
	GtkListBox* function_list;
	GtkEntry* function_name_entry;
	gboolean function_name_entry_placeholder_reseted;
	GtkButton* add_function_button;
	GtkSpinButton* add_arguments_button;
};

struct _Block1Data {
	int _ref_count_;
	MathFunctionPopover* self;
	GtkListBoxRow* row;
	MathFunction* function;
};


static gpointer math_function_popover_parent_class = NULL;
static gchar** math_function_popover_FUNCTION_ARGS;
static gint math_function_popover_FUNCTION_ARGS_length1;
static gchar** math_function_popover_FUNCTION_ARGS = NULL;
static gint math_function_popover_FUNCTION_ARGS_length1 = 0;
static gint _math_function_popover_FUNCTION_ARGS_size_ = 0;

GType math_function_popover_get_type (void) G_GNUC_CONST;
#define MATH_FUNCTION_POPOVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverPrivate))
MathFunctionPopover* math_function_popover_new (MathEquation* equation);
MathFunctionPopover* math_function_popover_construct (GType object_type,
                                                      MathEquation* equation);
static GtkListBoxRow* math_function_popover_make_function_row (MathFunctionPopover* self,
                                                        MathFunction* function);
static gint math_function_popover_function_list_sort (MathFunctionPopover* self,
                                               GtkListBoxRow* row1,
                                               GtkListBoxRow* row2);
static gint _math_function_popover_function_list_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                       GtkListBoxRow* row2,
                                                                       gpointer self);
static void __lambda17_ (MathFunctionPopover* self,
                  MathFunction* function);
static void ___lambda17__function_manager_function_added (FunctionManager* _sender,
                                                   MathFunction* function,
                                                   gpointer self);
static void __lambda18_ (MathFunctionPopover* self,
                  MathFunction* function);
static GtkListBoxRow* math_function_popover_find_row_for_function (MathFunctionPopover* self,
                                                            MathFunction* function);
static void ___lambda18__function_manager_function_edited (FunctionManager* _sender,
                                                    MathFunction* new_function,
                                                    gpointer self);
static void __lambda20_ (MathFunctionPopover* self,
                  MathFunction* function);
static void ___lambda20__function_manager_function_deleted (FunctionManager* _sender,
                                                     MathFunction* function,
                                                     gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda19_ (Block1Data* _data1_,
                  GtkWidget* child);
static void ___lambda19__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void math_function_popover_insert_function_cb (MathFunctionPopover* self,
                                               GtkListBoxRow* row);
static void _math_function_popover_insert_function_cb_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                           GtkListBoxRow* row,
                                                                           gpointer self);
static gboolean math_function_popover_function_name_mouse_click_cb (MathFunctionPopover* self,
                                                             GtkWidget* widget,
                                                             GdkEventButton* event);
static gboolean _math_function_popover_function_name_mouse_click_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                            GdkEventButton* event,
                                                                                            gpointer self);
static gboolean math_function_popover_function_name_key_press_cb (MathFunctionPopover* self,
                                                           GtkWidget* widget,
                                                           GdkEventKey* event);
static gboolean _math_function_popover_function_name_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                       GdkEventKey* event,
                                                                                       gpointer self);
static void math_function_popover_function_name_changed_cb (MathFunctionPopover* self);
static void _math_function_popover_function_name_changed_cb_gtk_editable_changed (GtkEditable* _sender,
                                                                           gpointer self);
static void math_function_popover_add_function_cb (MathFunctionPopover* self,
                                            GtkWidget* widget);
static void _math_function_popover_add_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void math_function_popover_save_function_cb (MathFunctionPopover* self,
                                             GtkWidget* widget);
static void math_function_popover_delete_function_cb (MathFunctionPopover* self,
                                               GtkWidget* widget);
static void _math_function_popover_save_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _math_function_popover_delete_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void math_function_popover_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gint
_math_function_popover_function_list_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                  GtkListBoxRow* row2,
                                                                  gpointer self)
{
	gint result;
	result = math_function_popover_function_list_sort ((MathFunctionPopover*) self, row1, row2);
	return result;
}


static void
__lambda17_ (MathFunctionPopover* self,
             MathFunction* function)
{
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (function != NULL);
	_tmp0_ = self->priv->function_list;
	_tmp1_ = math_function_popover_make_function_row (self, function);
	_tmp2_ = _tmp1_;
	gtk_container_add ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda17__function_manager_function_added (FunctionManager* _sender,
                                              MathFunction* function,
                                              gpointer self)
{
	__lambda17_ ((MathFunctionPopover*) self, function);
}


static void
__lambda18_ (MathFunctionPopover* self,
             MathFunction* function)
{
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	g_return_if_fail (function != NULL);
	_tmp0_ = self->priv->function_list;
	_tmp1_ = math_function_popover_find_row_for_function (self, function);
	_tmp2_ = _tmp1_;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->function_list;
	_tmp4_ = math_function_popover_make_function_row (self, function);
	_tmp5_ = _tmp4_;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp5_);
	_g_object_unref0 (_tmp5_);
}


static void
___lambda18__function_manager_function_edited (FunctionManager* _sender,
                                               MathFunction* new_function,
                                               gpointer self)
{
	__lambda18_ ((MathFunctionPopover*) self, new_function);
}


static void
__lambda20_ (MathFunctionPopover* self,
             MathFunction* function)
{
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (function != NULL);
	_tmp0_ = self->priv->function_list;
	_tmp1_ = math_function_popover_find_row_for_function (self, function);
	_tmp2_ = _tmp1_;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda20__function_manager_function_deleted (FunctionManager* _sender,
                                                MathFunction* function,
                                                gpointer self)
{
	__lambda20_ ((MathFunctionPopover*) self, function);
}


MathFunctionPopover*
math_function_popover_construct (GType object_type,
                                 MathEquation* equation)
{
	MathFunctionPopover * self = NULL;
	MathEquation* _tmp0_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp1_;
	gchar** names = NULL;
	FunctionManager* _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_;
	gint names_length1;
	gint _names_size_;
	GtkListBox* _tmp19_;
	FunctionManager* _tmp20_;
	FunctionManager* _tmp21_;
	FunctionManager* _tmp22_;
	GtkSpinButton* _tmp23_;
	GtkSpinButton* _tmp24_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathFunctionPopover*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp0_;
	_tmp1_ = function_manager_get_default_function_manager ();
	function_manager = _tmp1_;
	_tmp2_ = function_manager;
	_tmp4_ = function_manager_get_names (_tmp2_, &_tmp3_);
	names = _tmp4_;
	names_length1 = _tmp3_;
	_names_size_ = names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				const gchar* _tmp9_;
				MathFunction* function = NULL;
				FunctionManager* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				const gchar* _tmp13_;
				MathFunction* _tmp14_;
				GtkListBox* _tmp15_;
				MathFunction* _tmp16_;
				GtkListBoxRow* _tmp17_;
				GtkListBoxRow* _tmp18_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = names;
				_tmp7__length1 = names_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = function_manager;
				_tmp11_ = names;
				_tmp11__length1 = names_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp14_ = function_manager_get (_tmp10_, _tmp13_);
				function = _tmp14_;
				_tmp15_ = self->priv->function_list;
				_tmp16_ = function;
				_tmp17_ = math_function_popover_make_function_row (self, _tmp16_);
				_tmp18_ = _tmp17_;
				gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp18_);
				_g_object_unref0 (_tmp18_);
				_g_object_unref0 (function);
			}
		}
	}
	_tmp19_ = self->priv->function_list;
	gtk_list_box_set_sort_func (_tmp19_, _math_function_popover_function_list_sort_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp20_ = function_manager;
	g_signal_connect_object (_tmp20_, "function-added", (GCallback) ___lambda17__function_manager_function_added, self, 0);
	_tmp21_ = function_manager;
	g_signal_connect_object (_tmp21_, "function-edited", (GCallback) ___lambda18__function_manager_function_edited, self, 0);
	_tmp22_ = function_manager;
	g_signal_connect_object (_tmp22_, "function-deleted", (GCallback) ___lambda20__function_manager_function_deleted, self, 0);
	_tmp23_ = self->priv->add_arguments_button;
	gtk_spin_button_set_range (_tmp23_, (gdouble) 1, (gdouble) 10);
	_tmp24_ = self->priv->add_arguments_button;
	gtk_spin_button_set_increments (_tmp24_, (gdouble) 1, (gdouble) 1);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (function_manager);
	return self;
}


MathFunctionPopover*
math_function_popover_new (MathEquation* equation)
{
	return math_function_popover_construct (TYPE_MATH_FUNCTION_POPOVER, equation);
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MathFunctionPopover* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->function);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
__lambda19_ (Block1Data* _data1_,
             GtkWidget* child)
{
	MathFunctionPopover* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data1_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = math_function_get_name (_data1_->function);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_object_get_data ((GObject*) child, "function");
	_tmp3_ = math_function_get_name ((MathFunction*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp1_, _tmp4_) == 0) {
		_data1_->row = G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) child) : NULL;
	}
}


static void
___lambda19__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda19_ (self, widget);
}


static GtkListBoxRow*
math_function_popover_find_row_for_function (MathFunctionPopover* self,
                                             MathFunction* function)
{
	GtkListBoxRow* result = NULL;
	Block1Data* _data1_;
	MathFunction* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (function != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (function);
	_g_object_unref0 (_data1_->function);
	_data1_->function = _tmp0_;
	_data1_->row = NULL;
	_tmp1_ = self->priv->function_list;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda19__gtk_callback, _data1_);
	_tmp2_ = _g_object_ref0 (_data1_->row);
	result = _tmp2_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void
math_function_popover_insert_function_cb (MathFunctionPopover* self,
                                          GtkListBoxRow* row)
{
	MathFunction* function = NULL;
	gconstpointer _tmp0_;
	MathFunction* _tmp1_;
	MathEquation* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkTextIter end = {0};
	MathEquation* _tmp7_;
	MathEquation* _tmp8_;
	GtkTextMark* _tmp9_;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_;
	GtkTextIter _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = g_object_get_data ((GObject*) row, "function");
	_tmp1_ = _g_object_ref0 ((MathFunction*) _tmp0_);
	function = _tmp1_;
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_function_get_name (function);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "()", NULL);
	_tmp6_ = _tmp5_;
	math_equation_insert (_tmp2_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->equation;
	_tmp8_ = self->priv->equation;
	_tmp9_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp8_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp10_, _tmp9_);
	end = _tmp10_;
	gtk_text_iter_backward_chars (&end, 1);
	_tmp11_ = self->priv->equation;
	_tmp12_ = end;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp11_, &_tmp12_);
	_g_object_unref0 (function);
}


static void
_math_function_popover_insert_function_cb_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                      GtkListBoxRow* row,
                                                                      gpointer self)
{
	math_function_popover_insert_function_cb ((MathFunctionPopover*) self, row);
}


static gboolean
math_function_popover_function_name_mouse_click_cb (MathFunctionPopover* self,
                                                    GtkWidget* widget,
                                                    GdkEventButton* event)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->function_name_entry_placeholder_reseted;
	if (!_tmp0_) {
		GtkEntry* _tmp1_;
		self->priv->function_name_entry_placeholder_reseted = TRUE;
		_tmp1_ = self->priv->function_name_entry;
		gtk_entry_set_text (_tmp1_, "");
	}
	result = FALSE;
	return result;
}


static gboolean
_math_function_popover_function_name_mouse_click_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self)
{
	gboolean result;
	result = math_function_popover_function_name_mouse_click_cb ((MathFunctionPopover*) self, _sender, event);
	return result;
}


static gboolean
math_function_popover_function_name_key_press_cb (MathFunctionPopover* self,
                                                  GtkWidget* widget,
                                                  GdkEventKey* event)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->function_name_entry_placeholder_reseted = TRUE;
	_tmp1_ = event->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_space)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_;
		_tmp2_ = event->keyval;
		_tmp0_ = _tmp2_ == ((guint) GDK_KEY_KP_Space);
	}
	if (_tmp0_) {
		event->keyval = (guint) GDK_KEY_underscore;
	}
	result = FALSE;
	return result;
}


static gboolean
_math_function_popover_function_name_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                              GdkEventKey* event,
                                                                              gpointer self)
{
	gboolean result;
	result = math_function_popover_function_name_key_press_cb ((MathFunctionPopover*) self, _sender, event);
	return result;
}


static void
math_function_popover_function_name_changed_cb (MathFunctionPopover* self)
{
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->add_function_button;
	_tmp1_ = self->priv->function_name_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, g_strcmp0 (_tmp2_, "") != 0);
}


static void
_math_function_popover_function_name_changed_cb_gtk_editable_changed (GtkEditable* _sender,
                                                                      gpointer self)
{
	math_function_popover_function_name_changed_cb ((MathFunctionPopover*) self);
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static void
math_function_popover_add_function_cb (MathFunctionPopover* self,
                                       GtkWidget* widget)
{
	gchar* name = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gint arguments = 0;
	GtkSpinButton* _tmp5_;
	gchar* formatted_args = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	MathEquation* _tmp16_;
	MathEquation* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->function_name_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = name;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		_g_free0 (name);
		return;
	}
	_tmp5_ = self->priv->add_arguments_button;
	arguments = gtk_spin_button_get_value_as_int (_tmp5_);
	_tmp6_ = g_strdup ("");
	formatted_args = _tmp6_;
	_tmp7_ = arguments;
	if (_tmp7_ > 0) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = math_function_popover_FUNCTION_ARGS;
		_tmp8__length1 = math_function_popover_FUNCTION_ARGS_length1;
		_tmp9_ = arguments;
		_tmp10_ = _vala_g_strjoinv ("; ", _tmp8_ + 0, _tmp9_ - 0);
		_g_free0 (formatted_args);
		formatted_args = _tmp10_;
	}
	_tmp11_ = name;
	_tmp12_ = formatted_args;
	_tmp13_ = g_strdup_printf ("(%s)=", _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
	_g_free0 (name);
	name = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = self->priv->equation;
	math_equation_clear (_tmp16_);
	_tmp17_ = self->priv->equation;
	_tmp18_ = name;
	math_equation_insert (_tmp17_, _tmp18_);
	_g_free0 (formatted_args);
	_g_free0 (name);
}


static void
_math_function_popover_add_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	math_function_popover_add_function_cb ((MathFunctionPopover*) self, _sender);
}


static void
math_function_popover_save_function_cb (MathFunctionPopover* self,
                                        GtkWidget* widget)
{
	MathFunction* function = NULL;
	gconstpointer _tmp0_;
	MathFunction* _tmp1_;
	gchar* function_to_edit = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	MathEquation* _tmp14_;
	MathEquation* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_object_get_data ((GObject*) widget, "function");
	_tmp1_ = _g_object_ref0 ((MathFunction*) _tmp0_);
	function = _tmp1_;
	_tmp2_ = math_function_get_name (function);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_function_get_arguments (function, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _vala_g_strjoinv (";", _tmp5_, _tmp5__length1);
	_tmp7_ = _tmp6_;
	_tmp8_ = math_function_get_expression (function);
	_tmp9_ = _tmp8_;
	_tmp10_ = math_function_get_description (function);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s(%s)=%s@%s", _tmp3_, _tmp7_, _tmp9_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp7_);
	function_to_edit = _tmp13_;
	_tmp14_ = self->priv->equation;
	math_equation_clear (_tmp14_);
	_tmp15_ = self->priv->equation;
	math_equation_insert (_tmp15_, function_to_edit);
	_g_free0 (function_to_edit);
	_g_object_unref0 (function);
}


static void
math_function_popover_delete_function_cb (MathFunctionPopover* self,
                                          GtkWidget* widget)
{
	MathFunction* function = NULL;
	gconstpointer _tmp0_;
	MathFunction* _tmp1_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_object_get_data ((GObject*) widget, "function");
	_tmp1_ = _g_object_ref0 ((MathFunction*) _tmp0_);
	function = _tmp1_;
	_tmp2_ = function_manager_get_default_function_manager ();
	function_manager = _tmp2_;
	_tmp3_ = math_function_get_name (function);
	_tmp4_ = _tmp3_;
	function_manager_delete (function_manager, _tmp4_);
	_g_object_unref0 (function_manager);
	_g_object_unref0 (function);
}


static void
_math_function_popover_save_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	math_function_popover_save_function_cb ((MathFunctionPopover*) self, _sender);
}


static void
_math_function_popover_delete_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	math_function_popover_delete_function_cb ((MathFunctionPopover*) self, _sender);
}


static GtkListBoxRow*
math_function_popover_make_function_row (MathFunctionPopover* self,
                                         MathFunction* function)
{
	GtkListBoxRow* result = NULL;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkListBoxRow* _tmp3_;
	MathFunction* _tmp4_;
	GtkListBoxRow* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp10_;
	gchar* expression = NULL;
	gchar* _tmp11_;
	GtkLabel* label = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkBox* _tmp26_;
	GtkLabel* _tmp27_;
	GtkListBoxRow* _tmp44_;
	GtkBox* _tmp45_;
	GtkListBoxRow* _tmp46_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (function != NULL, NULL);
	_tmp0_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "popover-row");
	_tmp3_ = row;
	_tmp4_ = _g_object_ref0 (function);
	g_object_set_data_full ((GObject*) _tmp3_, "function", _tmp4_, g_object_unref);
	_tmp5_ = row;
	_tmp6_ = math_function_get_description (function);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%s", _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp10_);
	hbox = _tmp10_;
	_tmp11_ = g_strdup ("(x)");
	expression = _tmp11_;
	if (math_function_is_custom_function (function)) {
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = math_function_get_arguments (function, &_tmp12__length1);
		_tmp13_ = _tmp12_;
		_tmp13__length1 = _tmp12__length1;
		_tmp14_ = _vala_g_strjoinv (";", _tmp13_, _tmp13__length1);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("(%s)", _tmp15_);
		_g_free0 (expression);
		expression = _tmp16_;
		_g_free0 (_tmp15_);
	}
	_tmp17_ = math_function_get_name (function);
	_tmp18_ = _tmp17_;
	_tmp19_ = expression;
	_tmp20_ = g_strdup_printf ("<b>%s</b>%s", _tmp18_, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	label = _tmp23_;
	_tmp24_ = label;
	gtk_label_set_use_markup (_tmp24_, TRUE);
	_tmp25_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_START);
	_tmp26_ = hbox;
	_tmp27_ = label;
	gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, TRUE, TRUE, (guint) 0);
	if (math_function_is_custom_function (function)) {
		GtkButton* button = NULL;
		GtkButton* _tmp28_;
		GtkButton* _tmp29_;
		GtkStyleContext* _tmp30_;
		GtkButton* _tmp31_;
		MathFunction* _tmp32_;
		GtkButton* _tmp33_;
		GtkBox* _tmp34_;
		GtkButton* _tmp35_;
		GtkButton* _tmp36_;
		GtkButton* _tmp37_;
		GtkStyleContext* _tmp38_;
		GtkButton* _tmp39_;
		MathFunction* _tmp40_;
		GtkButton* _tmp41_;
		GtkBox* _tmp42_;
		GtkButton* _tmp43_;
		_tmp28_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp28_);
		button = _tmp28_;
		_tmp29_ = button;
		_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
		gtk_style_context_add_class (_tmp30_, "flat");
		_tmp31_ = button;
		_tmp32_ = _g_object_ref0 (function);
		g_object_set_data_full ((GObject*) _tmp31_, "function", _tmp32_, g_object_unref);
		_tmp33_ = button;
		g_signal_connect_object (_tmp33_, "clicked", (GCallback) _math_function_popover_save_function_cb_gtk_button_clicked, self, 0);
		_tmp34_ = hbox;
		_tmp35_ = button;
		gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, TRUE, (guint) 0);
		_tmp36_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp36_);
		_g_object_unref0 (button);
		button = _tmp36_;
		_tmp37_ = button;
		_tmp38_ = gtk_widget_get_style_context ((GtkWidget*) _tmp37_);
		gtk_style_context_add_class (_tmp38_, "flat");
		_tmp39_ = button;
		_tmp40_ = _g_object_ref0 (function);
		g_object_set_data_full ((GObject*) _tmp39_, "function", _tmp40_, g_object_unref);
		_tmp41_ = button;
		g_signal_connect_object (_tmp41_, "clicked", (GCallback) _math_function_popover_delete_function_cb_gtk_button_clicked, self, 0);
		_tmp42_ = hbox;
		_tmp43_ = button;
		gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (button);
	}
	_tmp44_ = row;
	_tmp45_ = hbox;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = row;
	gtk_widget_show_all ((GtkWidget*) _tmp46_);
	result = row;
	_g_object_unref0 (label);
	_g_free0 (expression);
	_g_object_unref0 (hbox);
	return result;
}


static gint
math_function_popover_function_list_sort (MathFunctionPopover* self,
                                          GtkListBoxRow* row1,
                                          GtkListBoxRow* row2)
{
	gint result = 0;
	MathFunction* function1 = NULL;
	gconstpointer _tmp0_;
	MathFunction* _tmp1_;
	MathFunction* function2 = NULL;
	gconstpointer _tmp2_;
	MathFunction* _tmp3_;
	GCompareFunc _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = g_object_get_data ((GObject*) row1, "function");
	_tmp1_ = _g_object_ref0 ((MathFunction*) _tmp0_);
	function1 = _tmp1_;
	_tmp2_ = g_object_get_data ((GObject*) row2, "function");
	_tmp3_ = _g_object_ref0 ((MathFunction*) _tmp2_);
	function2 = _tmp3_;
	_tmp4_ = g_strcmp0;
	_tmp5_ = math_function_get_name (function1);
	_tmp6_ = _tmp5_;
	_tmp7_ = math_function_get_name (function2);
	_tmp8_ = _tmp7_;
	result = _tmp4_ (_tmp6_, _tmp8_);
	_g_object_unref0 (function2);
	_g_object_unref0 (function1);
	return result;
}


static void
math_function_popover_class_init (MathFunctionPopoverClass * klass)
{
	gint MathFunctionPopover_private_offset;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	math_function_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathFunctionPopoverPrivate));
	G_OBJECT_CLASS (klass)->finalize = math_function_popover_finalize;
	MathFunctionPopover_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-function-popover.ui");
	_tmp0_ = g_strdup ("x");
	_tmp1_ = g_strdup ("y");
	_tmp2_ = g_strdup ("z");
	_tmp3_ = g_strdup ("u");
	_tmp4_ = g_strdup ("v");
	_tmp5_ = g_strdup ("w");
	_tmp6_ = g_strdup ("a");
	_tmp7_ = g_strdup ("b");
	_tmp8_ = g_strdup ("c");
	_tmp9_ = g_strdup ("d");
	_tmp10_ = g_new0 (gchar*, 10 + 1);
	_tmp10_[0] = _tmp0_;
	_tmp10_[1] = _tmp1_;
	_tmp10_[2] = _tmp2_;
	_tmp10_[3] = _tmp3_;
	_tmp10_[4] = _tmp4_;
	_tmp10_[5] = _tmp5_;
	_tmp10_[6] = _tmp6_;
	_tmp10_[7] = _tmp7_;
	_tmp10_[8] = _tmp8_;
	_tmp10_[9] = _tmp9_;
	math_function_popover_FUNCTION_ARGS = _tmp10_;
	math_function_popover_FUNCTION_ARGS_length1 = 10;
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "function_list", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, function_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "function_name_entry", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, function_name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_function_button", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, add_function_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_arguments_button", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, add_arguments_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "insert_function_cb", G_CALLBACK(_math_function_popover_insert_function_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "function_name_mouse_click_cb", G_CALLBACK(_math_function_popover_function_name_mouse_click_cb_gtk_widget_button_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "function_name_key_press_cb", G_CALLBACK(_math_function_popover_function_name_key_press_cb_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "function_name_changed_cb", G_CALLBACK(_math_function_popover_function_name_changed_cb_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "add_function_cb", G_CALLBACK(_math_function_popover_add_function_cb_gtk_button_clicked));
}


static void
math_function_popover_instance_init (MathFunctionPopover * self)
{
	self->priv = MATH_FUNCTION_POPOVER_GET_PRIVATE (self);
	self->priv->function_name_entry_placeholder_reseted = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
math_function_popover_finalize (GObject * obj)
{
	MathFunctionPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->function_list);
	_g_object_unref0 (self->priv->function_name_entry);
	_g_object_unref0 (self->priv->add_function_button);
	_g_object_unref0 (self->priv->add_arguments_button);
	G_OBJECT_CLASS (math_function_popover_parent_class)->finalize (obj);
}


GType
math_function_popover_get_type (void)
{
	static volatile gsize math_function_popover_type_id__volatile = 0;
	if (g_once_init_enter (&math_function_popover_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathFunctionPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_function_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathFunctionPopover), 0, (GInstanceInitFunc) math_function_popover_instance_init, NULL };
		GType math_function_popover_type_id;
		math_function_popover_type_id = g_type_register_static (gtk_popover_get_type (), "MathFunctionPopover", &g_define_type_info, 0);
		g_once_init_leave (&math_function_popover_type_id__volatile, math_function_popover_type_id);
	}
	return math_function_popover_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



