;; Scheduling description for z10 (cpu 2097).
;; Copyright (C) 2008-2015 Free Software Foundation, Inc.
;; Contributed by Wolfgang Gellerich (gellerich@de.ibm.com).


; General naming conventions used in this file:
; - The two pipelines are called S and T, respectively.
; - A name ending "_S" or "_T" indicates that something happens in
;   (or belongs to) this pipeline.
; - A name ending "_ANY" indicates that something happens in (or belongs
;   to) either of the two pipelines.
; - A name ending "_BOTH" indicates that something happens in (or belongs
;   to) both pipelines.


;; Automaton and components.

(define_automaton "z10_cpu")

(define_cpu_unit "z10_e1_S, z10_e1_T"  "z10_cpu")
(define_reservation "z10_e1_ANY" "(z10_e1_S | z10_e1_T)")
(define_reservation "z10_e1_BOTH" "(z10_e1_S + z10_e1_T)")


; Both pipelines can execute a branch instruction, and branch
; instructions can be grouped with all other groupable instructions
; but not with a second branch instruction.

(define_cpu_unit "z10_branch_ANY"  "z10_cpu")

(define_insn_reservation "z10_branch" 4
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "branch"))
  "z10_branch_ANY + z10_e1_ANY, z10_Gate_ANY")


; Z10 operand and result forwarding.

; Instructions marked with the attributes as z10_fwd or z10_fr can
; forward a value they load from one of their operants into a register
; if the instruction in the second pipeline reads the same register.
; The second operation must be superscalar.  Instructions marked as
; z10_rec or z10_fr can receive a value they read from a register is
; this register gets updated by an instruction in the first pipeline.
; The first instruction must be superscalar.


; Forwarding from z10_fwd and z10_fr to z10_super.

(define_bypass 0 "z10_la_fwd, z10_la_fwd_A1, z10_larl_fwd, z10_larl_fwd_A3, \
                  z10_load_fwd, z10_load_fwd_A3, \
                  z10_other_fwd, z10_other_fwd_A1, z10_other_fwd_A3, \
	 	  z10_other_fr, z10_other_fr_A3, z10_other_fr_E1, \
                  z10_other_fwd_E1, z10_lr_fr, z10_lr_fr_E1, \
                  z10_int_fwd, z10_int_fwd_A1, z10_int_fwd_A3, \
                  z10_int_fwd_E1, z10_int_fr, z10_int_fr_E1, \
                  z10_int_fr_A3"
                  "z10_other_super, z10_other_super_c_E1, z10_other_super_E1, \
                  z10_int_super, z10_int_super_E1, \
                  z10_lr, z10_store_super"
                  " ! s390_agen_dep_p")


; Forwarding from z10_super to frz10_ and z10_rec.

(define_bypass 0 "z10_other_super, z10_other_super_E1, z10_other_super_c_E1, \
                  z10_int_super, z10_int_super_E1, \
                  z10_larl_super_E1, z10_larl_super, \
                  z10_store_super"
                  "z10_int_fr, z10_int_fr_E1, z10_int_fr_A3, \
                  z10_other_fr, z10_other_fr_A3, z10_lr_fr, z10_lr_fr_E1, \
                  z10_other_fr_E1, z10_store_rec"
                  " ! s390_agen_dep_p")


; Forwarding from z10_fwd and z10_fr to z10_rec and z10_fr.

(define_bypass 0 "z10_la_fwd, z10_la_fwd_A1, z10_larl_fwd, z10_larl_fwd_A3, \
                  z10_load_fwd, z10_load_fwd_A3, \
                  z10_other_fwd, z10_other_fwd_A1, z10_other_fwd_A3, \
                  z10_other_fr, z10_other_fr_A3, z10_other_fr_E1, \
                  z10_other_fwd_E1, \
                  z10_lr_fr, z10_lr_fr_E1, \
                  z10_int_fwd, z10_int_fwd_A1, z10_int_fwd_A3, \
                  z10_int_fwd_E1, z10_int_fr, z10_int_fr_E1, \
                  z10_int_fr_A3"
                  "z10_int_fr, z10_int_fr_E1, z10_int_fr_A3, \
                  z10_other_fr, z10_other_fr_A3, z10_lr_fr, z10_lr_fr_E1, \
                  z10_other_fr_E1, z10_store_rec"
                  " ! s390_agen_dep_p")


;
; Simple insns
;

; Here is the cycle diagram for FXU-executed instructions:
; ... A1 A2 A3 E1 P1 P2 P3 R0 ...
;        ^              ^  ^
;        |              |  updated GPR is available
;        |              write to GPR
;        instruction reads GPR during this cycle


; Variants of z10_int follow.

(define_insn_reservation "z10_int" 6
  (and (and (eq_attr "cpu" "z10")
            (eq_attr "type" "integer"))
       (and (eq_attr "atype" "reg")
             (and (and (eq_attr "z10prop" "!z10_super")
                       (eq_attr "z10prop" "!z10_super_c"))
                  (and (and (and (and (eq_attr "z10prop" "!z10_super_E1")
                                      (eq_attr "z10prop" "!z10_super_c_E1"))
                                  (eq_attr "z10prop" "!z10_fwd"))
                             (and (eq_attr "z10prop" "!z10_fwd_A1")
                                  (eq_attr "z10prop" "!z10_fwd_A3")))
                        (and (and (eq_attr "z10prop" "!z10_fwd_E1")
                                  (eq_attr "z10prop" "!z10_fr"))
                             (and (eq_attr "z10prop" "!z10_fr_E1")
                                  (eq_attr "z10prop" "!z10_fr_A3")))))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_super" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (ior (eq_attr "z10prop" "z10_super")
                      (eq_attr "z10prop" "z10_super_c")))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_super_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (ior (eq_attr "z10prop" "z10_super_E1")
                      (eq_attr "z10prop" "z10_super_c_E1")))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_fwd" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (eq_attr "z10prop" "z10_fwd"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_fwd_A1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (eq_attr "z10prop" "z10_fwd_A1"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_fwd_A3" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (eq_attr "z10prop" "z10_fwd_A3"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_fwd_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (eq_attr "z10prop" "z10_fwd_E1"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_fr" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (eq_attr "z10prop" "z10_fr"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_fr_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (eq_attr "z10prop" "z10_fr_E1"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_int_fr_A3" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (and (eq_attr "atype" "reg")
                 (eq_attr "z10prop" "z10_fr_A3"))))
  "z10_e1_ANY, z10_Gate_ANY")

; END of z10_int variants


(define_insn_reservation "z10_agen" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "integer")
            (eq_attr "atype" "agen")))
  "z10_e1_ANY, z10_Gate_ANY")


(define_insn_reservation "z10_lr" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "lr")
            (and (eq_attr "z10prop" "!z10_fr")
                 (eq_attr "z10prop" "!z10_fr_E1"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_lr_fr" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "lr")
            (eq_attr "z10prop" "z10_fr")))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_lr_fr_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "lr")
            (eq_attr "z10prop" "z10_fr_E1")))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_la" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "la")
            (and (eq_attr "z10prop" "!z10_fwd")
                 (eq_attr "z10prop" "!z10_fwd_A1"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_la_fwd" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "la")
            (eq_attr "z10prop" "z10_fwd")))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_la_fwd_A1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "la")
            (eq_attr "z10prop" "z10_fwd_A1")))
  "z10_e1_ANY, z10_Gate_ANY")


; larl-type instructions

(define_insn_reservation "z10_larl" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "larl")
                 (and (eq_attr "z10prop" "!z10_super_A1")
                      (and (eq_attr "z10prop" "!z10_fwd")
                           (and (eq_attr "z10prop" "!z10_fwd_A3")
                                (and (eq_attr "z10prop" "!z10_super")
                                     (eq_attr "z10prop" "!z10_super_c"))
                                (and (eq_attr "z10prop" "!z10_super_E1")
                                     (eq_attr "z10prop" "!z10_super_c_E1")))))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_larl_super" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "larl")
            (and (eq_attr "z10prop" "z10_super")
                 (eq_attr "z10prop" "z10_super_c"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_larl_fwd" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "larl")
            (eq_attr "z10prop" "z10_fwd")))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_larl_fwd_A3" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "larl")
            (eq_attr "z10prop" "z10_fwd_A3")))
  "z10_e1_ANY, z10_Gate_ANY")


(define_insn_reservation "z10_larl_A1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "larl")
            (eq_attr "z10prop" "z10_super_A1")))
  "z10_e1_ANY, z10_Gate_ANY")
;  "z10_e1_ANY")

(define_insn_reservation "z10_larl_super_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "larl")
            (ior (eq_attr "z10prop" "z10_super_E1")
                 (eq_attr "z10prop" "z10_super_c_E1"))))
  "z10_e1_ANY, z10_Gate_ANY")
;  "z10_e1_ANY")


(define_insn_reservation "z10_load" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "load")
            (and (eq_attr "z10prop" "!z10_fwd")
                 (eq_attr "z10prop" "!z10_fwd_A3"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_load_fwd" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "load")
            (eq_attr "z10prop" "z10_fwd")))
  "z10_e1_ANY, z10_Gate_ANY")
;  "z10_e1_ANY")

(define_insn_reservation "z10_load_fwd_A3" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "load")
            (eq_attr "z10prop" "z10_fwd_A3")))
  "z10_e1_ANY, z10_Gate_ANY")
;  "z10_e1_ANY")

(define_insn_reservation "z10_store" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "store")
            (and (eq_attr "z10prop" "!z10_rec")
                 (and (eq_attr "z10prop" "!z10_super")
                      (eq_attr "z10prop" "!z10_super_c")))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_store_super" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "store")
            (ior (eq_attr "z10prop" "z10_super")
                 (eq_attr "z10prop" "z10_super_c"))))
  "z10_e1_ANY, z10_Gate_ANY")

(define_insn_reservation "z10_store_rec" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "store")
            (eq_attr "z10prop" "z10_rec")))
  "z10_e1_ANY, z10_Gate_ANY")

; The default_latency is chosen to drain off the pipeline.
(define_insn_reservation "z10_call" 14
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "jsr"))
  "z10_e1_BOTH*4, z10_Gate_BOTH")

; The default latency is for worst case.  CS and CSG take one
; cycle only (i.e. latency would be 6).
(define_insn_reservation "z10_sem" 9
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "sem"))
  "z10_e1_BOTH*5, z10_Gate_ANY")

(define_insn_reservation "z10_cs" 6
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "cs"))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_vs" 6
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "vs"))
  "z10_e1_BOTH*4, z10_Gate_BOTH")

; Load and store multiple. Actual number of cycles
; in unknown at compile.time.
(define_insn_reservation "z10_stm" 10
  (and (eq_attr "cpu" "z10")
       (ior (eq_attr "type" "stm")
            (eq_attr "type" "lm")))
  "z10_e1_BOTH*4, z10_Gate_BOTH")


; Subsets of z10_other follow.

(define_insn_reservation "z10_other" 6
  (and (and (eq_attr "cpu" "z10")
            (eq_attr "type" "other"))
       (and (and (eq_attr "z10prop" "!z10_fwd")
                 (eq_attr "z10prop" "!z10_fwd_A1"))
            (and (and  (and (eq_attr "z10prop" "!z10_fr_A3")
                            (eq_attr "z10prop" "!z10_fwd_A3"))
                       (and (eq_attr "z10prop" "!z10_fr")
                            (eq_attr "z10prop" "!z10_fr_E1")))
                 (and  (and (and (eq_attr "z10prop" "!z10_super")
                                  (eq_attr "z10prop" "!z10_super_c"))
                            (eq_attr "z10prop" "!z10_super_c_E1"))
                       (and (eq_attr "z10prop" "!z10_super_E1")
                            (eq_attr "z10prop" "!z10_fwd_E1"))))))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_fr_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_fr_E1")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_super_c_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_super_c_E1")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_super_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_super_E1")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_fwd_E1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_fwd_E1")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_fwd" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_fwd")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_fwd_A3" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_fwd_A3")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_fwd_A1" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_fwd_A1")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_fr" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_fr")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_fr_A3" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (eq_attr "z10prop" "z10_fr_A3")))
  "z10_e1_BOTH, z10_Gate_BOTH")

(define_insn_reservation "z10_other_super" 6
  (and (eq_attr "cpu" "z10")
       (and (eq_attr "type" "other")
            (ior (eq_attr "z10prop" "z10_super")
                 (eq_attr "z10prop" "z10_super_c"))))
  "z10_e1_BOTH, z10_Gate_BOTH")

; END of z10_other subsets.


;
; Floating point insns
;

; Z10 executes the following integer operations in the BFU pipeline.

(define_insn_reservation "z10_mul_sidi" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "imulsi,imuldi,imulhi"))
  "z10_e1_BOTH, z10_Gate_FP")

; Some variants take fewer cycles, but that is not relevant here.
(define_insn_reservation "z10_div" 162
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "idiv"))
  "z10_e1_BOTH*4, z10_Gate_FP")


; BFP multiplication and general instructions

(define_insn_reservation "z10_fsimpdf" 6
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsimpdf,fmuldf,fmadddf"))
  "z10_e1_BOTH, z10_Gate_FP")

(define_insn_reservation "z10_fsimpsf" 6
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsimpsf,fmulsf,fmaddsf"))
  "z10_e1_BOTH, z10_Gate_FP")

(define_insn_reservation "z10_fmultf" 52
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fmultf"))
  "z10_e1_BOTH*4, z10_Gate_FP")

(define_insn_reservation "z10_fsimptf" 14
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsimptf"))
  "z10_e1_BOTH*2, z10_Gate_FP")


; BFP division

(define_insn_reservation "z10_fdivtf" 113
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fdivtf"))
  "z10_e1_T*4, z10_Gate_FP")

(define_insn_reservation "z10_fdivdf" 41
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fdivdf"))
  "z10_e1_T*4, z10_Gate_FP")

(define_insn_reservation "z10_fdivsf" 34
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fdivsf"))
  "z10_e1_T*4, z10_Gate_FP")


; BFP sqrt

(define_insn_reservation "z10_fsqrtsf" 41
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsqrtsf"))
  "z10_e1_T*4, z10_Gate_FP")

(define_insn_reservation "z10_fsqrtdf" 54
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsqrtdf"))
  "z10_e1_T*4, z10_Gate_FP")

(define_insn_reservation "z10_fsqrtf" 122
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsqrttf"))
  "z10_e1_T*4, z10_Gate_FP")


; BFP load and store

(define_insn_reservation "z10_floadtf" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "floadtf"))
  "z10_e1_T, z10_Gate_FP")

(define_insn_reservation "z10_floaddf" 1
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "floaddf"))
  "z10_e1_T, z10_Gate_FP")

(define_insn_reservation "z10_floadsf" 1
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "floadsf"))
  "z10_e1_T, z10_Gate_FP")

(define_insn_reservation "z10_fstoredf" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fstoredf,fstoredd"))
  "z10_e1_T, z10_Gate_FP")

(define_insn_reservation "z10_fstoresf" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fstoresf,fstoresd"))
  "z10_e1_T, z10_Gate_FP")


; BFP truncate
(define_insn_reservation "z10_ftrunctf" 16
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "ftrunctf"))
  "z10_e1_T, z10_Gate_FP")

(define_insn_reservation "z10_ftruncdf" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "ftruncdf"))
  "z10_e1_T, z10_Gate_FP")


; Conversion between BFP and int.
(define_insn_reservation "z10_ftoi" 13
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "ftoi"))
  "z10_e1_T, z10_Gate_FP")

(define_insn_reservation "z10_itoftf" 14
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "itoftf"))
  "z10_e1_T*2, z10_Gate_FP")

(define_insn_reservation "z10_itofsfdf" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "itofdf,itofsf"))
  "z10_e1_T, z10_Gate_FP")



; BFP-related bypasses.  There is no bypass for extended mode.
(define_bypass 1 "z10_fsimpdf" "z10_fstoredf")
(define_bypass 1 "z10_fsimpsf" "z10_fstoresf")
(define_bypass 1 "z10_floaddf" "z10_fsimpdf, z10_fstoredf")
(define_bypass 1 "z10_floadsf" "z10_fsimpsf, z10_fstoresf")


;
; insn_reservations for DFP instructions.
;

; Exact number of cycles is not known at compile-time.
(define_insn_reservation "z10_fdivddtd" 40
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fdivdd,fdivtd"))
  "z10_e1_BOTH,z10_Gate_DFU")

(define_insn_reservation "z10_ftruncsd" 38
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "ftruncsd"))
  "z10_e1_BOTH*4,z10_Gate_DFU")

(define_insn_reservation "z10_ftruncdd" 340
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "ftruncsd"))
  "z10_e1_BOTH*4,z10_Gate_DFU")

(define_insn_reservation "z10_floaddd" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "floaddd"))
  "z10_e1_BOTH,z10_Gate_DFU")

(define_insn_reservation "z10_floadsd" 12
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "floadsd"))
  "z10_e1_BOTH,z10_Gate_DFU")

; Exact number of cycles is not known at compile-time.
(define_insn_reservation "z10_fmulddtd" 35
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fmuldd,fmultd"))
  "z10_e1_BOTH,z10_Gate_DFU")

(define_insn_reservation "z10_fsimpdd" 17
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsimpdd"))
  "z10_e1_BOTH,z10_Gate_DFU")

(define_insn_reservation "z10_fsimpsd" 17
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsimpsd"))
  "z10_e1_BOTH,z10_Gate_DFU")

(define_insn_reservation "z10_fsimptd" 18
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "fsimptd"))
  "z10_e1_BOTH,z10_Gate_DFU")

(define_insn_reservation "z10_itofdd" 36
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "itofdd"))
  "z10_e1_BOTH*3,z10_Gate_DFU")

(define_insn_reservation "z10_itoftd" 49
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "itoftd"))
  "z10_e1_BOTH*3,z10_Gate_DFU")

; Exact number of cycles is not known at compile-time.
(define_insn_reservation "z10_ftoidfp" 30
  (and (eq_attr "cpu" "z10")
       (eq_attr "type" "ftoidfp"))
  "z10_e1_BOTH*3,z10_Gate_DFU")


;
; Address-related bypasses
;

; Here is the cycle diagram for address-related bypasses:
; ... G1 G2 G3 A0 A1 A2 A3 E1 P1 P2 P3 R0 ...
;         ^  ^    ^     ^  ^        ^
;         |  |    |     |  |        without bypass, its available AFTER this cycle
;         |  |    |     |  E1-type bypasses provide the new value AFTER this cycle
;         |  |    |     A3-type bypasses provide the new value AFTER this cycle
;         |  |    A1-type bypasses provide the new value AFTER this cycle
;         |  AGI resolution, actual USE of new value is DURING this cycle
;         AGI detection

(define_bypass 3 "z10_larl_A1, z10_la_fwd_A1, z10_other_fwd_A1, \
                  z10_int_fwd_A1"
                 "z10_agen, z10_la, z10_branch, z10_call, z10_load, \
                  z10_store, \
                  z10_cs, z10_stm, z10_other"
	         "s390_agen_dep_p")

(define_bypass 5 "z10_larl_fwd_A3, z10_load_fwd_A3, z10_other_fwd_A3, \
                  z10_other_fr_A3, z10_int_fwd_A3, z10_int_fr_A3"
                 "z10_agen, z10_la, z10_branch, z10_call, z10_load, \
                  z10_store, \
                  z10_cs, z10_stm, z10_other"
	         "s390_agen_dep_p")

(define_bypass 6 "z10_other_fr_E1, z10_other_super_c_E1, z10_other_super_E1, \
                  z10_other_fwd_E1, \
                  z10_lr_fr_E1, z10_larl_super_E1, \
                  z10_int_super_E1, z10_int_fwd_E1, z10_int_fr_E1"
                 "z10_agen, z10_la, z10_branch, z10_call, z10_load, \
                  z10_store, \
                  z10_cs, z10_stm, z10_other"
 	         "s390_agen_dep_p")

(define_bypass 9 "z10_int_super, z10_int_fwd, z10_int_fr"
                 "z10_agen, z10_la, z10_branch, z10_call, z10_load, \
                  z10_store, \
                  z10_cs, z10_stm, z10_other"
 	         "s390_agen_dep_p")



;
; Try to avoid transitions between DFU-, BFU- and FXU-executed instructions as there is a
; dispatch delay required.
;


; Declaration for some pseudo-pipeline stages that reflect the
; dispatch gap when issuing an INT/FXU/BFU-executed instruction after
; an instruction executed by a different unit has been executed.  The
; approach is that we pretend a pipelined execution of BFU operations
; with as many stages as the gap is long and request that none of
; these stages is busy when issuing a FXU- or DFU-executed
; instruction.  Similar for FXU- and DFU-executed instructions.

; Declaration for FPU stages.
(define_cpu_unit "z10_f0, z10_f1, z10_f2, z10_f3, z10_f4, z10_f5, z10_f6, \
                  z10_f7, z10_f8, z10_f9, z10_f10, z10_f11, z10_f12" "z10_cpu")
(define_reservation "z10_FP_PP" "z10_f0, z10_f1, z10_f2, z10_f3, z10_f4, \
                  z10_f5, z10_f6, z10_f7, z10_f8, z10_f9, z10_f10, z10_f11, \
                  z10_f12")

; Declaration for FXU stages.
(define_cpu_unit "z10_S1, z10_S2, z10_S3, z10_S4, z10_S5, z10_S6"  "z10_cpu")
(define_cpu_unit "z10_T1, z10_T2, z10_T3, z10_T4, z10_T5, z10_T6"  "z10_cpu")
(define_reservation "z10_INT_PP" "z10_S1 | z10_T1, z10_S2 | z10_T2, z10_S3 \
                                  | z10_T3, z10_S4 | z10_T4, z10_S5 | \
                                  z10_T5, z10_S6 | z10_T6")

; Declaration for DFU stages.
(define_cpu_unit "z10_d0, z10_d1, z10_d2, z10_d3, z10_d4, z10_d5, z10_d6"
                 "z10_cpu")
(define_reservation "z10_DFU_PP" "z10_d0, z10_d1, z10_d2, z10_d3, z10_d4, \
                                 z10_d5, z10_d6")


; Pseudo-units representing whether the respective unit is available
; in the sense that using it does not cause a dispatch delay.

(define_cpu_unit "z10_S_avail, z10_T_avail, z10_FP_avail, z10_DFU_avail"
                 "z10_cpu")

(absence_set "z10_FP_avail"
             "z10_S1, z10_S2, z10_S3, z10_S4, z10_S5, z10_S6, z10_T1, z10_T2, z10_T3, z10_T4, \
              z10_T5, z10_T6, \
              z10_d0, z10_d1, z10_d2, z10_d3, z10_d4, z10_d5, z10_d6")

(absence_set "z10_S_avail,z10_T_avail"
             "z10_f0, z10_f1, z10_f2, z10_f3, z10_f4, z10_f5, z10_f6, z10_f7, \
              z10_f8, z10_f9, z10_f10, z10_f11, z10_f12, \
              z10_d0, z10_d1, z10_d2, z10_d3, z10_d4, z10_d5, z10_d6")

(absence_set "z10_DFU_avail"
             "z10_S1, z10_S2, z10_S3, z10_S4, z10_S5, z10_S6, z10_T1, z10_T2, z10_T3, z10_T4, \
              z10_T5, z10_T6, \
              z10_f0, z10_f1, z10_f2, z10_f3, z10_f4, z10_f5, z10_f6, z10_f7, \
              z10_f8, z10_f9, z10_f10, z10_f11, z10_f12")


; Pseudo-units to be used in insn_reservations.

(define_reservation "z10_Gate_ANY" "((z10_S_avail | z10_T_avail), z10_INT_PP)")
(define_reservation "z10_Gate_BOTH" "((z10_S_avail + z10_T_avail), z10_INT_PP)")

(define_reservation "z10_Gate_FP" "z10_FP_avail, z10_FP_PP")

(define_reservation "z10_Gate_DFU" "z10_DFU_avail, z10_DFU_PP")
