/*---
{
    "custom": true
}
---*/

/*===
object
object
RangeError
object
object
RangeError
object
object
RangeError
===*/

/* JSON parse() recursion limit is hit if C recursion through object
 * and/or array traversal becomes too deep.
 *
 * Note: we don't check the parse result now; using JSON.stringify()
 * to print the result would hit stringify()'s recursion limit.  So
 * if printing is added, do it with ECMAScript and avoid ECMAScript
 * recursion limit.
 *
 * To ensure recursion limit is reached for even a deep stack configuration,
 * use n=2000.
 */

function objectRecursionTest(n) {
    var txt = '"foo"';
    var i;

    for (i = 0; i < n; i++) {
        txt = "{\"foo\":" + txt + "}";
    }

    print(typeof JSON.parse(txt));
}

function arrayRecursionTest(n) {
    var txt = '"bar"';
    var i;

    for (i = 0; i < n; i++) {
        txt = "[" + txt + "]";
    }

    print(typeof JSON.parse(txt));
}

function objectAndArrayRecursionTest(n) {
    var txt = '"bar"';
    var i;

    for (i = 0; i < n; i++) {
        if (i % 2) {
            txt = "{\"foo\":" + txt + "}";
        } else {
            txt = "[" + txt + "]";
        }
    }

    print(typeof JSON.parse(txt));
}

try {
    objectRecursionTest(10);
    objectRecursionTest(80);
    objectRecursionTest(2000);
} catch (e) {
    print(e.name);
}

try {
    arrayRecursionTest(10);
    arrayRecursionTest(80);
    arrayRecursionTest(2000);
} catch (e) {
    print(e.name);
}

try {
    objectAndArrayRecursionTest(10);
    objectAndArrayRecursionTest(80);
    objectAndArrayRecursionTest(2000);
} catch (e) {
    print(e.name);
}

/*===
[{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}]]
[{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}]]
[{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}],{"foo":1,"bar":[1,2]},[1,{"foo":1}]]
===*/

/* A very wide structure is not an issue, as long as there is no (C)
 * recursion.  This test ensures that the recursion tracking works
 * correctly, i.e. is increased and decreased where appropriate.
 *
 * Here we rely on neither parse() nor stringify() hitting any limits,
 * so we can print the result.
 */

function noRecursionTest(n) {
    var txt = [];
    var i;

    for (i = 0; i < n; i++) {
        if (i % 2) {
            txt.push("[1, {\"foo\":1}]");
        } else {
            txt.push("{\"foo\":1, \"bar\":[1,2]}");
        }
    }

    txt = "[" + txt.join(", ") + "]";
    print(JSON.stringify(JSON.parse(txt)));
}

try {
    noRecursionTest(10);
    noRecursionTest(100);
    noRecursionTest(1000);
} catch (e) {
    print(e.name, e);
}
