/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _SOCKETS_H
#define _SOCKETS_H

#include "platform.h"

#if defined(_YICS_WIN32)
#  include <windows.h>
#  include <winsock.h>
#  define closesock(s) closesocket(s)
#  define EWOULDBLOCK 		(WSAEWOULDBLOCK)
#  define ENOTSOCK		(WSAENOTSOCK)
#  define ECONNRESET		(WSAECONNRESET)
#  define ECONNREFUSED		(WSAECONNREFUSED)
#  define ENOTSOCK		(WSAENOTSOCK)
#  define NOTINITIALISED        (WSANOTINITIALISED)
#  define ETIMEDOUT		(WSAETIMEDOUT)
#  define ENOBUFS		(WSAENOBUFS)
#elif defined(_YICS_POSIX)
#  include <sys/socket.h>
#  include <netinet/in.h>
#  include <netdb.h>
#  include <unistd.h>
#  define closesock(s) close(s)
#endif

#endif
