.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
geodesic \- animates a mesh geodesic sphere.
.SH SYNOPSIS
.B geodesic
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-mode \fImode\fP]
[\-no-wander]
[\-no-spin]
[\-fps]
[\-delay \fInumber\fP]
[\-speed \fInumber\fP]
[\-count \fInumber\fP]
.SH DESCRIPTION
Animates a mesh geodesic sphere of increasing and decreasing complexity. A
geodesic sphere is an icosohedron whose equilateral faces are sub-divided
into non-equilateral triangles to more closely approximate a sphere.

The animation shows the equilateral triangles subdivided into four
coplanar equilateral triangles; and then inflated outward, causing the
sub-triangles to no longer be equilateral, but to more closely
approximate the surface of a sphere.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-mode mesh | solid | stellated | stellated2 | wire
Face/edge display style. Default mesh.
.TP 8
.B \-wander | \-no-wander
Whether the object should wander around the screen.
.TP 8
.B \-spin | \-no-spin
Whether the object should spin.
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds).
.TP 8
.B \-speed \fInumber\fP
Animation speed.  2.0 means twice as fast, 0.5 means half as fast.
.TP 8
.B \-count \fInumber\fP
Depth (frequency) of the geodesic sphere.  Default: 4.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2013 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski.
