/*
 *========================================================================
 * $Id: xmlsysd_quit.c 77 2002-04-02 07:49:26Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */


#include "xmlsysd.h"

/*
 * This is the quit routine.  It closes the socket or output
 * stream and exits.
 */

void xmlsysd_quit()
{

 if((verbose == D_ALL) || (verbose == D_QUIT)) {
   printf("D_QUIT: xmlsysd_quit().  Use -v %d to focus.\n",D_QUIT);
 }

 /*
  * To quit, we close the fd, then exit.  The primary daemon or xinetd
  * remains to listen for new connections.
  */
 close(client_fd);
 if((verbose == D_ALL) || (verbose == D_QUIT)) {
   printf("D_QUIT: Socket %x closed, forked daemon exiting.\n",client_fd);
   printf("D_QUIT: (Toplevel daemon still available for new connections.)\n");
 }

 exit(0);

}
