#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3


from winswitch.virt.utmp_wrapper import getutents, python_utmp_getutents, pyutmp_getutents, utmp_rec


def dump_records(method):
	recs = method()
	print " found %s records using %s:" % (len(recs), method)
	header = utmp_rec()
	header.ut_type = "ut_type"
	header.ut_pid = "ut_pid"
	header.ut_line = "ut_line"
	header.ut_id = "ut_id"
	header.ut_user = "ut_user"
	header.ut_host = "ut_host"
	header.ut_exit = "ut_exit"
	header.ut_session = "ut_session"
	header.ut_time = "ut_time"
	header.ut_addr = "ut_addr"
	print str(header)
	for rec in recs:
		print str(rec)

def test_getutents():
	print "test_getutents()"
	dump_records(getutents)

def test_python_utmp():
	print "test_python_utmp()"
	dump_records(python_utmp_getutents)

def test_pyutmp():
	print "test_pyutmp()"
	dump_records(pyutmp_getutents)


if __name__ == "__main__":
#	test_python_utmp()
#	test_python_last_getutents()
#	test_pyutmp()
	test_getutents()
