/*
* Copyright (c) 1999 Sun Microsystems, Inc. All Rights Reserved.
*
* This software is the confidential and proprietary information of Sun
* Microsystems, Inc. ("Confidential Information").  You shall not
* disclose such Confidential Information and shall use it only in
* accordance with the terms of the license agreement you entered into
* with Sun.
*
* SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
* SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
* IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
* PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
* THIS SOFTWARE OR ITS DERIVATIVES.
*/

/*
// $Workfile: KeyPair.java $
// $Revision: 1.1 $
// $Date: 2007-09-26 14:32:59 $
// $Author: marche $
// $Archive: /Products/Europa/api21/javacard/security/KeyPair.java $
// $Modtime: 5/02/00 8:48p $
// Original author:  Andy
// */

package javacard.security;

/**
 * This class is a container for a key pair (a public key and a
 * private key). It does not enforce any security, and, when initialized,
 * should be treated like a PrivateKey.
 * <p>In addition, this class features a key generation method.
 *
 * @see PublicKey
 * @see PrivateKey
 */

public final class KeyPair {

    /**
     * <code>KeyPair</code> object containing a RSA key pair.
     */
	public static final byte ALG_RSA               = 1;
	
	/**
     * <code>KeyPair</code> object containing a RSA key pair with private key in
     * its Chinese Remainder Theorem form.
     */
	public static final byte ALG_RSA_CRT           = 2;
	
	
	/**
     * <code>KeyPair</code> object containing a DSA key pair.
     */
	public static final byte ALG_DSA               = 3;
	
		
    private PrivateKey privateKey;
    private PublicKey publicKey;

    
    /**
     * (Re)Initializes the key objects encapsulated in this <code>KeyPair</code> instance 
     * with new key values. The initialized public and private key objects
     * encapsulated in this instance will then be suitable for use with the
	 * <code>Signature</code> and <code>Cipher</code> objects. 
	 * An internal secure random number generator is used during new key pair generation.
     * <p>Notes:<ul>
     * <li><em>For the RSA algorithm, if the exponent value in the public key object is pre-initialized,
     * it will be retained; Otherwise a default value of 65537 will be used.</em>
     * <li><em>For the DSA algorithm, if the p, q and g parameters of the public key object are pre-initialized,
     * it will be retained; Otherwise default precomputed parameter sets will be used. The required 
     * default precomputed values are listed in </em>Appendix B<em> of </em>Java Cryptography Architecture
     * API Specification & Reference<em> document.</em>
     * <li><em>If the time taken to generate the key values is excessive, the implementation may automatically
     * request additional APDU processing time from the CAD.</em>
     * </ul>
	 * @exception CryptoException with the following reason codes:<ul>
     * <li><code>CryptoException.ILLEGAL_VALUE</code> if the exponent value parameter in RSA or the
     * p,q,g parameter set in DSA is invalid.
     * </ul>
     * @see javacard.framework.APDU
     * @see Signature
     * @see javacardx.crypto.Cipher
     */
    public final void genKeyPair() throws CryptoException {}
    
    /**
     * Constructs a <code>KeyPair</code> instance for the specified algorithm and keylength.&nbsp
     * The encapsulated keys are uninitialized.
     * To initialize the <code>KeyPair</code> instance use the <code>genKeyPair()</code> method.<p> 
     * The encapsulated key objects are of the specified <code>keyLength</code> size and 
	 * implement the appropriate <code>Key</code> interface associated with the specified algorithm
	 * (example - <code>RSAPublicKey</code> interface for the public key and <code>RSAPrivateKey</code>
	 * interface for the private key within an <code>ALG_RSA</code> key pair).<p>
	 * <p>Notes:<ul>
	 * <li><em>The key objects encapsulated in the generated </em><code>KeyPair</code><em> object
     * need not support the </em><code>KeyEncryption</code><em> interface.</em>
     * </ul>
 	 * @param algorithm the type of algorithm whose key pair needs to be generated.
	 * Valid codes listed in <code>ALG_..</code> constants above.
	 * @param keyLength the key size in bits. The valid key bit lengths are key type dependent.
	 * See the <code>KeyBuilder</code> class.
	 * @exception CryptoException with the following reason codes:<ul>
     * <li><code>CryptoException.NO_SUCH_ALGORITHM</code> if the requested algorithm
     * associated with the specified type, size of key is not supported.</ul>
     * @see KeyBuilder
     * @see Signature
     * @see javacardx.crypto.Cipher
 	 * @see javacardx.crypto.KeyEncryption
     */
    public KeyPair(byte algorithm, short keyLength) throws CryptoException
    {
    	CryptoException.throwIt( CryptoException.NO_SUCH_ALGORITHM );
    }   
        
    /**
     * Constructs a new <code>KeyPair</code> object containing the specified 
     * public key and private key.
     *
     * <p>Note that this constructor only stores references to the public
     * and private key components in the generated <code>KeyPair</code> object. 
     *
     * @param publicKey the public key.
     * @param privateKey the private key.
     * @exception CryptoException with the following reason codes:<ul>
     * <li><code>CryptoException.ILLEGAL_VALUE</code> if the input parameter key
     * objects are inconsistent with each other - i.e mismatched algorithm, size etc.
     * <li><code>CryptoException.NO_SUCH_ALGORITHM</code> if the algorithm
     * associated with the specified type, size of key is not supported.
     * </ul>
     */
    public KeyPair(PublicKey krak_publicKey, PrivateKey krak_privateKey)
    throws CryptoException
    {
    	CryptoException.throwIt( CryptoException.NO_SUCH_ALGORITHM );
    }

    /**
     * Returns a reference to the public key component of this <code>KeyPair</code> object.
     *
     * @return a reference to the public key.
     */
    public PublicKey getPublic() {
	return publicKey;
    }

     /**
     * Returns a reference to the private key component of this <code>KeyPair</code> object.
     *
     * @return a reference to the private key.
     */
   public PrivateKey getPrivate() {
	return privateKey;
    }
}
