


VTPRINTCAP(5)              FILE FORMATS             VTPRINTCAP(5)


NNAAMMEE
       vtprintcap - database of terminal printer control codes

SSYYNNOOPPSSIISS
       //uussrr//llooccaall//lliibb//vvttpprriinntt//vvttpprriinnttccaapp

DDEESSCCRRIIPPTTIIOONN
       vvttpprriinnttccaapp  is  a  simple  flat file database containing a
       list of the names of various terminals and the codes those
       terminals use to start and stop an attached printer (media
       hard copy).  This  database  is  used  by  vvttpprriinntt(1)  and
       related programs.

       Each  entry is composed of three lines.  The first line is
       a comma-delimited list of names which may be used to  ref-
       erence  this entry.  The second line the sequence of char-
       acters used by the terminal to turn on  an  attached  hard
       copy  device  and  redirect  output  to that device.   The
       third line contains the sequence  of  characters  used  to
       turn  the  device  off  and  restore  normal output to the
       screen.

       An entry must have all three lines to be considered valid.
       Currently  no comment lines are permitted to exist between
       these lines:  such  lines  would  be  interpreted  as  the
       printer control codes themselves!

       The  rules  for  selecting a terminal name are simple: you
       must follow the same rules as for  //eettcc//tteerrmmccaapp(5)  names.
       Terminal      names      should      be     entered     in
       //uussrr//llooccaall//lliibb//vvttpprriinntt//vvttpprriinnttccaapp with  exactly  the  same
       names as are in //eettcc//tteerrmmccaapp.

       The  control code strings in the second and third lines of
       an entry are governed as follows: ANSI C style escapes for
       character  constants  (e.g. \n for newline) are permitted,
       constant strings are permitted, and quotes may be used  to
       as  delimiters in the string.  (This is useful if you wish
       you use a digit immediately following  a  numeric  escape.
       For  example,  ESC-5  should  be represented as \033"5" to
       avoid confusion in with \335.  In general, the rules  out-
       lined for ANSI constant escaping are enforced.

       Additionally,  //uussrr//llooccaall//lliibb//vvttpprriinntt//vvttpprriinnttccaapp  may con-
       tain comment lines, which are indicated by placing a  hash
       mark  (#)  in the first column of the line.  Remember how-
       ever that entries must _n_o_t be broken up by comment  lines!

EEXXAAMMPPLLEE
       Here  is a sample entry common to DEC vt100 and vt102 ter-
       minals:


              #  Sample  vtprintcap  entry  for  vt100  &   vt102



vtprint v2.0.2           25 October 1994                        1





VTPRINTCAP(5)              FILE FORMATS             VTPRINTCAP(5)


              terminals
              vt100, vt102
              \033[5i
              \033[4i

       This entry would be used whenever the user's TERM environ-
       ment variable was set to "vt102" or "vt100", using ESC [5i
       and ESC [4i as the printer control codes to turn a printer
       on and off, respectively.

DDIISSTTRRIIBBUUTTIIOONN
       vvttpprriinnttccaapp is part of the vvttpprriinntt package,  which  can  be
       obtained   by   anonymous   ftp  at  ftp.sdsu.edu  in  the
       //ppuubb//vvttpprriinntt directory.  Please read the IINNDDEEXX and  RREEAADDMMEE
       files before downloading.

       If  you do not have ftp availability, then you can request
       a uuencoded copy of vvttpprriinntt be sent to you via e-mail from
       the  author.   The  author  is  also willing to make other
       arrangements as needed, within certain limitations.

FFIILLEESS
       //eettcc//tteerrmmccaapp
       //uussrr//llooccaall//lliibb//vvttpprriinntt//vvttpprriinnttccaapp

BBUUGGSS
       vvttpprriinnttccaapp handling code currently could get confused if a
       printer  control code is exactly the same as the name of a
       terminal, or contained the name of a terminal delimited by
       commas.   As  this  is  very  unlikely  to every occur, it
       shouldn't be a problem.

SSEEEE AALLSSOO
       tteerrmmccaapp(5) vvttpprriinntt(1)























vtprint v2.0.2           25 October 1994                        2


