# -*- coding: utf-8 -*-

## This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
import sys
import subprocess
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from SND_editorDlg import *

debug=0

class SND_Process() :
    def __init__(self, VideoporamaInstance, RenderDlg) :
      self.VideoporamaInstance = VideoporamaInstance
      self.RenderDlg = RenderDlg
      self.soundToProcess = None
      
    def setSoundToProcess(self, xmlSound, outputSound, soundLenght) :
      self.soundToProcess = xmlSound
      self.outputSound = outputSound
      self.lenght = soundLenght


    def runnuxOld (self) :
      """Process to execute"""
      if self.soundToProcess == None : 
        mainTrackProcess = QProcess()
        command = u"\"%ssox\" -V3 -r 48000 -n \"%s\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.outputSound, self.lenght)
        #print command
        mainTrackProcess.start(QString(command))
        mainTrackProcess.waitForFinished()
        return True
      
      # 1. Main soundTrack process
      commandMain = u"\"%ssox\" --combine concatenate " % (self.VideoporamaInstance.S)
      if len(self.soundToProcess.getElementsByTagName('mainTrack')[0].getElementsByTagName('soundObject')) > 0 :
        soundList = self.soundToProcess.getElementsByTagName('mainTrack')[0].getElementsByTagName('soundObject')
        for sndPart in soundList :
          if sndPart.getAttribute('silence') == u"1" :
            commandMain += u"\"| \"%ssox\" -n -c 2 -r 48000 -p fade 00:00:00.0 %s 00:00:00.0\" " % (self.VideoporamaInstance.S, secondToPos(sndPart.getAttribute('silenceD')))  
          else :
            commandMain += u" -t raw  -c 2 -r 48000 -b 16 --endian little -e signed-integer \"| %sffmpeg  -ss %s -t %s -i '%s' -vol %d -f s16le -acodec pcm_s16le -ar 48000 -ac 2 - | %ssox -t raw  -c 2 -r 48000 -b 16 --endian little -e signed-integer -  -t raw  -c 2 -r 48000 -b 16 --endian little -e signed-integer - fade h %s %s %s\" " % (self.VideoporamaInstance.I,
                 secondToPos(sndPart.getAttribute('TstartV')),
                 secondToPos(float(sndPart.getAttribute('TendV'))-float(sndPart.getAttribute('TstartV'))),
                 MakeAbsolut(self.VideoporamaInstance.ProjectFilePathName, sndPart.getAttribute('urlFile')), 
                 256+int(sndPart.getAttribute('gain'))*12,
                 self.VideoporamaInstance.S, 
                 sndPart.getAttribute('fadein'),
                 secondToPos(float(sndPart.getAttribute('TendV'))-float(sndPart.getAttribute('TstartV'))),
                 sndPart.getAttribute('fadeout'))  
        # Finish command line and starts it
        commandMain += u"\"%saudioMain.tmp.wav\"" % (self.VideoporamaInstance.T)
        mainTrackProcess = QProcess() 
        #print commandMain
        mainTrackProcess.start(QString(commandMain))
        self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Converting main soundtrack"),25)
        #print "convert main track"     
        
      else :
        mainTrackProcess = QProcess()
        command = u"\"%ssox\" -V3 -r 48000 -n \"%saudioMain.tmp.wav\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T, self.lenght)
        #print command
        mainTrackProcess.start(QString(command))

      mainTrackProcess.waitForFinished()
      
      # 2. Comment soundTrack process
      commandComment = u"\"%ssox\" --combine concatenate " % (self.VideoporamaInstance.S)
      if len(self.soundToProcess.getElementsByTagName('commentTrack')[0].getElementsByTagName('soundObject')) > 0 :
        for sndPart in self.soundToProcess.getElementsByTagName('commentTrack')[0].getElementsByTagName('soundObject') :
          if sndPart.getAttribute('silence') == u"1" :
            commandComment += u"\"| %ssox -n -c 2 -r 48000 -p fade 00:00:00.0 %s 00:00:00.0\" " % (self.VideoporamaInstance.S, secondToPos(sndPart.getAttribute('silenceD')))  
          else :
            commandComment += u" -t raw  -c 2 -r 48000 -b 16 --endian little -e signed-integer \"| %sffmpeg  -ss %s -t %s -i '%s' -vol %d -f s16le -acodec pcm_s16le -ar 48000 -ac 2 - | %ssox -t raw  -c 2 -r 48000 -b 16 --endian little -e signed-integer -  -t raw  -c 2 -r 48000 -b 16 --endian little -e signed-integer - fade h %s %s %s\" " % (self.VideoporamaInstance.I,
                 secondToPos(sndPart.getAttribute('TstartV')),
                 secondToPos(float(sndPart.getAttribute('TendV'))-float(sndPart.getAttribute('TstartV'))),
                 MakeAbsolut(self.VideoporamaInstance.ProjectFilePathName, sndPart.getAttribute('urlFile')), 
                 256+int(sndPart.getAttribute('gain'))*12,
                 self.VideoporamaInstance.S,
                 sndPart.getAttribute('fadein'),
                 secondToPos(float(sndPart.getAttribute('TendV'))-float(sndPart.getAttribute('TstartV'))),
                 sndPart.getAttribute('fadeout'))           
        # Finish command line and starts it
        commandComment += u"\"%saudioComment.tmp.wav\"" % (self.VideoporamaInstance.T)
        commentTrackProcess = QProcess()
        #print commandComment
        commentTrackProcess.start(QString(commandComment))
        self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Converting comment soundtrack"),50)
        #print "convert comment track"
        
      else :
        commentTrackProcess = QProcess()
        command = u"\"%ssox\" -V3 -r 48000 -n \"%saudioComment.tmp.wav\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T, self.lenght)
        #print command
        commentTrackProcess.start(QString(command))
      
      # 3. Mix soundTrack together
      commentTrackProcess.waitForFinished()
      commandMix = u"\"%ssox\" --combine mix-power \"%saudioMain.tmp.wav\" \"%saudioComment.tmp.wav\" \"%s\" norm fade h 00:00:00.0 %s 00:00:01.00" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T, self.VideoporamaInstance.T, self.outputSound, self.lenght)
      mixProcess = QProcess()
      #print commandMix
      mixProcess.start(QString(commandMix))
      #print "Mix sound track"
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Mix main and comment soundtrack"),75)
      
      mixProcess.waitForFinished()
      #print "process convertion sound OK"
      return True
      
    def run (self) :
      """Process to execute"""
      if self.soundToProcess == None : 
        mainTrackProcess = QProcess()
        command = u"\"%ssox\" -V3 -r 48000 -n \"%s\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.outputSound, self.lenght)
        print command
        mainTrackProcess.start(QString(command))
        mainTrackProcess.waitForFinished()
        return True
      
      # 1. Main soundTrack process
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Converting main soundtrack"),0)
      
      commandMain = u"\"%ssox\" --combine concatenate " % (self.VideoporamaInstance.S)
      tmpMain = 0
      if len(self.soundToProcess.getElementsByTagName('mainTrack')[0].getElementsByTagName('soundObject')) > 0 :
        soundList = self.soundToProcess.getElementsByTagName('mainTrack')[0].getElementsByTagName('soundObject')
        for sndPart in soundList :
          if sndPart.getAttribute('silence') == "1" :
            command = u"\"%ssox\" -n -c 2 -r 48000 %s fade 00:00:00.0 %s 00:00:00.0\" " % (self.VideoporamaInstance.S, self.VideoporamaInstance.T+u"tmpMain"+str(tmpMain)+u".wav", secondToPos(sndPart.getAttribute('silenceD')))
            P = QProcess()
            #print command
            P.start(QString(command))
            P.waitForFinished()
            if P.exitStatus() != QProcess.NormalExit : return False
          else :
            if not buildSound(self.VideoporamaInstance, 
                urlIn=MakeAbsolut(self.VideoporamaInstance.ProjectFilePathName, sndPart.getAttribute('urlFile')),
                urlOut=self.VideoporamaInstance.T+u"tmpMain"+str(tmpMain)+u".wav",
                TstartV=float(sndPart.getAttribute('TstartV')),
                duration=float(sndPart.getAttribute('TendV'))-float(sndPart.getAttribute('TstartV')),
                vol=256+int(sndPart.getAttribute('gain'))*12, 
                fadeIn=float(sndPart.getAttribute('fadein')), 
                fadeOut=float(sndPart.getAttribute('fadeout'))) : return False
          
          commandMain += u" \"%stmpMain%d.wav\"" % (self.VideoporamaInstance.T, tmpMain)
          tmpMain += 1

        # Finish command line and starts it
        self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Finish render main soundtrack"),15)
        commandMain += u" \"%saudioMain.tmp.wav\"" % (self.VideoporamaInstance.T)
        mainTrackProcess = QProcess() 
        #print commandMain
        mainTrackProcess.start(QString(commandMain))
        #print "convert main track"     
        
      else :
        mainTrackProcess = QProcess()
        command = u"\"%ssox\" -V3 -r 48000 -n \"%saudioMain.tmp.wav\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T, self.lenght)
        #print command
        mainTrackProcess.start(QString(command))

      mainTrackProcess.waitForFinished()
      
      # 2. Comment soundTrack process
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Converting comment soundtrack"),25)
      commandComment = u"\"%ssox\" --combine concatenate " % (self.VideoporamaInstance.S)
      tmpCom = 0
      if self.soundToProcess.getElementsByTagName('commentTrack')[0].getElementsByTagName('soundObject') > 0 :
        for sndPart in self.soundToProcess.getElementsByTagName('commentTrack')[0].getElementsByTagName('soundObject') :
          if sndPart.getAttribute('silence') == "1" :
            command = u"\"%ssox\" -n -c 2 -r 48000 \"%s\" fade 00:00:00.0 %s 00:00:00.0" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T+u"tmpCom"+str(tmpCom)+u".wav", secondToPos(sndPart.getAttribute('silenceD')))  
            P = QProcess()
            #print command
            P.start(QString(command))
            P.waitForFinished()
            if P.exitStatus() != QProcess.NormalExit : return False
          else :
            if not buildSound(self.VideoporamaInstance, 
                urlIn=MakeAbsolut(self.VideoporamaInstance.ProjectFilePathName, sndPart.getAttribute('urlFile')),
                urlOut=self.VideoporamaInstance.T+u"tmpCom"+str(tmpCom)+u".wav",
                TstartV=float(sndPart.getAttribute('TstartV')),
                duration=float(sndPart.getAttribute('TendV'))-float(sndPart.getAttribute('TstartV')),
                vol=256+int(sndPart.getAttribute('gain'))*12, 
                fadeIn=float(sndPart.getAttribute('fadein')), 
                fadeOut=float(sndPart.getAttribute('fadeout'))) : return False
          
          commandComment += u" \"%stmpCom%d.wav\"" % (self.VideoporamaInstance.T, tmpCom)
          tmpCom += 1

        # Finish command line and starts it
        self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Finish render comment soundtrack"),40)
        commandComment += u" \"%saudioComment.tmp.wav\"" % (self.VideoporamaInstance.T)
        commentTrackProcess = QProcess()
        #print commandComment
        commentTrackProcess.start(QString(commandComment))
        #print "convert comment track"
      else :
        commentTrackProcess = QProcess()
        command = u"\"%ssox\" -V3 -r 48000 -n \"%saudioComment.tmp.wav\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T, self.lenght)
        #print command
        commentTrackProcess.start(QString(command))
      commentTrackProcess.waitForFinished()
      
      # 3. Make video soundtrack
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Render Video soundtrack"),50)
      commandVideoTrack = u"\"%ssox\" --combine concatenate " % (self.VideoporamaInstance.S)
      # Initialise follow up index
      silenceIndex = 0 # counter of silence file
      silenceTime = 0.0 # length of silence file
      videoIndex = 0 # counter for sound from video file
      hasPrevious = 0 # to know if the previous sequence is movie
      urlPrevious = None # temporary value to mix fade in and fade out together
      mainTimeline = self.VideoporamaInstance.win.timeline
      i=0
      while i < mainTimeline.columnCount() :
        if i == mainTimeline.columnCount()-1 : last = 1
        else : last = 0
        img = mainTimeline.cellWidget(0,i).CalcImageTime(25)
        seq = mainTimeline.cellWidget(0,i)
        if seq.ObjectType == 2 : # Selected sequence is movie
          TstartVid = seq.StartVideo.hour()*3600.0+seq.StartVideo.minute()*60.0+seq.StartVideo.second()+seq.StartVideo.msec()/1000.0
          durationVid = seq.DurationVideo.hour()*3600.0+seq.DurationVideo.minute()*60.0+seq.DurationVideo.second()+seq.DurationVideo.msec()/1000.0
          fadeInSeq = img[2] 
          fadeOutSeq = img[4]
          
          # Check if there is silence file to make
          if silenceTime > 0.0 :
            if debug : print "first movie object - seq = ", i, " previous silence"
            command = u"\"%ssox\" -V3 -r 48000 -n \"%ssilence%d.wav\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T, silenceIndex, silenceTime)
            P = QProcess()
            P.start(QString(command))
            P.waitForFinished()
            commandVideoTrack += u"\"%ssilence%d.wav\" " % (self.VideoporamaInstance.T, silenceIndex)
            silenceIndex += 1 # increment silence index
            silenceTime = 0.0 # Reset total value silence
          if not last :	
            seqPlus1OT = mainTimeline.cellWidget(0,i+1).ObjectType
          else :
            seqPlus1OT = 0
          if not hasPrevious : # movie sound without mixing
            if debug : print "Seq = ", i, " Case no previous"
            if seqPlus1OT != 2 :
              if not buildSound(self.VideoporamaInstance, urlIn=seq.urlim, urlOut=self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", TstartV=TstartVid, duration=durationVid, vol=256, fadeIn=fadeInSeq, fadeOut=fadeOutSeq) : return False
              if debug : print u"Created file : \"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
              commandVideoTrack += u"\"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
              videoIndex += 1
            else :
              # 1. Fade In + core sequence
              if not buildSound(self.VideoporamaInstance, urlIn=seq.urlim, urlOut=self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", TstartV=TstartVid, duration=durationVid-fadeOutSeq, vol=256, fadeIn=fadeInSeq, fadeOut=0.0) : return False
              if debug : print u"Created file : \"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
              # add it to commandVideoTrack
              commandVideoTrack += u"\"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
              videoIndex += 1
              # 2. Fade out for mix with following fade in
              if not buildSound(self.VideoporamaInstance, urlIn=seq.urlim, urlOut=self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", TstartV=TstartVid+durationVid-fadeOutSeq, duration=fadeOutSeq, vol=256, fadeIn=0.0, fadeOut=fadeOutSeq) : return False
              if debug : print u"Created file : \"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
              # add it to commandVideoTrack
              commandVideoTrack += u"\"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
              urlPrevious = self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"              
              videoIndex += 1

          elif hasPrevious : # Movie sound with mixing with previous part
            if debug : print "Seq = ", i, " Case previous"
            # fadeIn of current sequence
            if not buildSound(self.VideoporamaInstance, urlIn=seq.urlim, urlOut=self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", TstartV=TstartVid, duration=fadeInSeq, vol=256, fadeIn=fadeInSeq, fadeOut=0.0) : return False
            if debug : print "Fade in file : ", self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"
            videoIndex += 1
            # mix with previous fadeOut
            commandMix = u"\"%ssox\" --combine mix-power \"%s\" \"%s\" -t wav -c 2 -r 48000 -b 16 --endian little -e signed-integer \"%s\" fade h 0.0 %f 0.0" % (self.VideoporamaInstance.S, urlPrevious, self.VideoporamaInstance.T+u"video"+str(videoIndex-1)+u".wav", self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", fadeInSeq)
            Pm = QProcess()
            Pm.start(QString(commandMix))
            Pm.waitForFinished()
            if debug : print "Mix with previous Fade in file : ", self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"
            commandVideoTrack += u"\"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
            videoIndex += 1
            if seqPlus1OT != 2 :
              if debug : print "No following video", self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"
              # core+fadeOut file
              if not buildSound(self.VideoporamaInstance, urlIn=seq.urlim, urlOut=self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", TstartV=TstartVid+fadeInSeq, duration=img[0]-fadeInSeq, vol=256, fadeIn=0.0, fadeOut=fadeOutSeq) : return False
              if debug : print "core file with Fade out : ", self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"
            else :
              # fadeOut file
              if debug : print "With following video"
              if not buildSound(self.VideoporamaInstance, urlIn=seq.urlIm, urlOut=self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", TstartV=TstartVid+img[0]-fadeOutSeq, duration=fadeOutSeq, vol=256, fadeIn=0.0, fadeOut=fadeOutSeq) : return False
              if debug : print "core file without Fade out : ", self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"
              urlPrevious = self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"
              videoIndex += 1
              # core file + add to commandVideoTrack
              if not buildSound(self.VideoporamaInstance, urlIn=seq.urlim, urlOut=self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav", TstartV=TstartVid+fadeInSeq, duration=img[0]-fadeInSeq-fadeOutSeq, vol=256, fadeIn=0.0, fadeOut=0.0) : return False
              if debug : print "Fade out file (to mix with following one) : ", self.VideoporamaInstance.T+u"video"+str(videoIndex)+u".wav"
            commandVideoTrack += u"\"%svideo%d.wav\" " % (self.VideoporamaInstance.T, videoIndex)
            videoIndex += 1
          hasPrevious = 1    			  
        else : # current sequence is not movie
          if debug : print "Current sequence : ", i, "is not movie, add silenceTime" 
          timeAdd = img[0]-img[4]		  
          if hasPrevious :
            silenceTime += timeAdd-img[2]
            hasPrevious = 0
          else :
            silenceTime += timeAdd
            hasPrevious = 0
          if last :
            silenceTime += img[4]
            command = u"\"%ssox\" -V3 -r 48000 -n \"%ssilence%d.wav\" fade 00:00:00.000 %s 00:00:00.000 channels 2" % (self.VideoporamaInstance.S, self.VideoporamaInstance.T, silenceIndex, silenceTime)
            P = QProcess()
            P.start(QString(command))
            P.waitForFinished()
            if debug : print "Last silence, create file", self.VideoporamaInstance.T+u"silence"+str(silenceIndex)+u".wav"
            commandVideoTrack += u"\"%ssilence%d.wav\" " % (self.VideoporamaInstance.T, silenceIndex)
        i += 1  
      # Finalise the command line and make the movie soundtrack
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Mix Video soundtrack"),70)
      
      commandVideoTrack += u"-t wav -c 2 -r 48000 -b 16 --endian little -e signed-integer \"%s\" fade h 0.0 %f 0.0" % (self.VideoporamaInstance.T+u"audioMovie.tmp.wav", self.lenght)
      if debug : print "Videotrack command : ", commandVideoTrack

      P = QProcess()
      P.start(QString(commandVideoTrack))
      P.waitForFinished()
      if not QFile(QString(self.VideoporamaInstance.T+u"audioMovie.tmp.wav")).exists() : return False
      
      # 4. Mix soundTrack together
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Mix main, comment and video soundtrack"),85)
      commentTrackProcess.waitForFinished()
      if QFile(QString(self.VideoporamaInstance.T+u"audioMain.tmp.wav")).exists() :
        urlMain = u"\"%saudioMain.tmp.wav\"" % (self.VideoporamaInstance.T)
      else : urlMain = u""
      if QFile(QString(self.VideoporamaInstance.T+u"audioComment.tmp.wav")).exists() :
        urlComment = u"\"%saudioComment.tmp.wav\"" % (self.VideoporamaInstance.T)
      else : urlComment = u""
      if QFile(QString(self.VideoporamaInstance.T+u"audioMovie.tmp.wav")).exists() :
        urlMovie = u"\"%saudioMovie.tmp.wav\"" % (self.VideoporamaInstance.T)
      else : urlMovie = u""
      commandMix = u"\"%ssox\" --combine mix-power %s %s %s -t wav -c 2 -r 48000 -b 16 --endian little -e signed-integer \"%s\" norm fade h 00:00:00.0 %s 00:00:01.0" % (self.VideoporamaInstance.S, urlMain, urlComment, urlMovie, self.outputSound, self.lenght)
      print "durée total : ", self.lenght
      mixProcess = QProcess()
      print commandMix
      mixProcess.start(QString(commandMix))
      #print "Mix sound track"
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Making soundtrack finished"),100)
      
      mixProcess.waitForFinished()
      #print "process convertion sound OK"
      if not debug :
        # Delete temporary sound file
        # Filters
        filters = QStringList()
        filters << "tmpMain*.wav" << "tmpCom*.wav" << "silence*.wav" << "video*.wav" << "audioMain.tmp.wav" << "audioComment.tmp.wav" << "audioMovie.tmp.wav" 
        files=QDir(QString(self.VideoporamaInstance.T)).entryList(filters, QDir.Files)
        i=0
        while i < files.count() :
          ffile = u"%s%s" % (self.VideoporamaInstance.T, files[i])
          if not QFile(ffile).remove() : print "Echec suppression fichier : ", ffile
          i += 1
      return True