/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_textwidget.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBTextWidget
// put here vdk class name string
#define VDK_CLASS "VDKTextView"
// put here vdk class name 
#define VDK_ANCESTOR  VDKTextView
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "text"

extern char* wi_widget_prompts[];
static char buff[128];

// used to autogenerate default
// labelbutton  names and captions

int CLASS::Counter = 0;
/* 
 label properties names
 */
char* vdktextwidget_props[] =
{ 
EDITABLE,0
};
/*
text widget signal names && nicknames
Default response method name will be made by:
On<object name><nickname>.
For instance if object name = <Abutton> and nickname = <Click>
default response method name will be: <OnAbuttonClick>
*/
char* vdktextwidget_signals[] = { SIGNAL_REALIZED,0 };
char* vdktextwidget_nicknames[] = { NICK_REALIZED,0 };

//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
///////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDK_ANCESTOR(owner),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list label button properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdktextwidget_props[t]; t++)
    proplist.add(VDKBProperty(vdktextwidget_props[t]));
  // add to VDKBObject signal list  signals
  for(t=0; vdktextwidget_signals[t]; t++)
    siglist.add(VDKBSignal(vdktextwidget_signals[t],
			   this,
			   vdktextwidget_nicknames[t]));
  SetPropValue(EDITABLE,CHECK_TRUE);
  SetPropValue(WORDWRAP,CHECK_FALSE);
  // connects events.
  CONNECT_COMMON_EVENTS;

  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s\"%s\";",
	  PROP_EDITABLE,(char*) GetProp(EDITABLE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_WORDWRAP,(char*) GetProp(WORDWRAP));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* text = NULL;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    text = new CLASS(buff,owner);
  // add widget to form
  return owner->AddToSelf(text,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char obj_editable[16];
  char arg[64];
  char tmp[256];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  if(parser.GetParam(obj_editable,buffer,PROP_EDITABLE) && 
     strcmp(obj_editable,NIHIL_PROP))
    ;
  else
    strcpy(obj_editable,CHECK_TRUE);
  sprintf(tmp,"\n%s = new %s(this);", obj_name,VDK_CLASS);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  CLASS* text = NULL;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return false;
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      text = new CLASS(obj_name,owner);
      /*
      if(parser.GetParam(arg,buffer,PROP_WORDWRAP) && 
	 strcmp(arg,NIHIL_PROP))
	{
	  text->WordWrap = !strcmp(arg,CHECK_TRUE);
	  text->SetPropValue(WORDWRAP,arg);
	}
      */
      // pack widget to container
      return owner->PackToSelf(text, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  /*
  wrap = new VDKCheckButton(inspector,_("WordWrap"));
  bframe->Add(wrap);
  wrap->Checked = GetProp(WORDWRAP) == True;
  // this after (so no signal hang)
  wrap->Parent(this);
  SignalConnect(wrap,"toggled",&CLASS::OnSetWordWrap);
  */
  editable = new VDKCheckButton(inspector,_(wi_widget_prompts[2]));
  bframe->Add(editable);
  editable->Checked = GetProp(EDITABLE) == True;
  // this after (so no signal hang)
  editable->Parent(this);
  SignalConnect(editable,"toggled",&CLASS::OnSetEditable);
  return bframe; 
}
//////////////////////////////////////////////////////
// These response methods actually change both 
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
/*
bool
CLASS::OnSetWordWrap(VDKObject*)
{
  SetPropValue(WORDWRAP, wrap->Checked ? CHECK_TRUE : CHECK_FALSE);
  WordWrap = wrap->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true; 
}
*/ 
/*
 */
bool
CLASS::OnSetEditable(VDKObject*)
{
  SetPropValue(EDITABLE, editable->Checked ? CHECK_TRUE : CHECK_FALSE);
  Editable = editable->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}








