/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _dnd_main_form_h_
#define _dnd_main_form_h_
#include <vdk/vdk.h>
// Dnd FORM  CLASS

class TrashcanForm;

class DndForm: public VDKForm
{
// gui object declarations
private:
// vdkbuilder reserved gui construction
  void GUISetup(void);
  VDKDnD *dnd;
  TrashcanForm* child;
 public:
  DndForm(VDKForm* owner, char* title);
  ~DndForm();
  void Setup(void);
  bool OnDrop(VDKObject* object);
  bool OnSourceGetData(VDKObject* object);
  VDKDnD* DnD() { return dnd; }
 protected:
  VDKBox*  vbox2;
  VDKBox*  hbox4;
  VDKBox*  button_area;
  VDKCustomButton*  button1, *button2, * button3, *button4, *button6;
  VDKBox*  widget_area;
  VDKCustomList*  customlist0;
  VDKEntry*  entry0;
  VDKSeparator*  separator0;
  VDKBox*  hbox5;
  VDKBox*  target_area1;
  VDKSeparator*  separator1;
  VDKBox*  target_area2;
  void OnShow(VDKForm* sender);
  void OnMove(VDKForm* sender);
 public:
  DECLARE_SIGNAL_MAP(DndForm);
};

// Trashcan FORM  CLASS
class TrashcanForm: public VDKForm
{
 private:
  void GUISetup(void);
  DndForm* dndform;
 protected:
  VDKBox*  vbox12;
  VDKFrame*  frame1;
  VDKBox*  VBox13;
  VDKBox*  vbox1;
  VDKPixmap*  trashcan;
  VDKSeparator*  separator0;
  VDKBox*  hbox10;
  VDKCustomButton*  restore;
  void OnShow(VDKForm* sender);
 public:
  TrashcanForm(VDKForm* owner, char* title);
  ~TrashcanForm();
  void Setup(void);
  bool OnDragLeave(VDKObject* object);
  bool OnDragMotion(VDKObject* object);
  bool OnDropTrash(VDKObject* target);
  DECLARE_SIGNAL_MAP(TrashcanForm);
  bool OnrestoreClick(VDKObject* sender);
};

// Dnd APPLICATION  CLASS
class DndApp: public VDKApplication
{

 public:
  DndApp(int* argc, char** argv);
  ~DndApp();
  void Setup(void);
};

#endif
