/*
 *   This file is part of VBA Express.
 *
 *   Copyright (c) 2005-2006 Achraf cherti <achrafcherti@gmail.com>
 * 
 *   VBA Express is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   VBA Express is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with VBA Express; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/*********************************************************
 * Classe pour les routines internes de configuration
 * elle fait le travail "cach" pour qu'ensuite
 * elle communique les rsultats  l'interface
 *
 * Auteur: Achraf cherti
 * Email:  achrafcherti@gmail.com
 *
 * Licence:
 *---------
 * Cette source est distribue sous Licence GNU General
 * Public licence version 2 (ou ultrieure).
 *********************************************************/

#include <stdio.h>
#include <stdlib.h> //atoi
#include "lcfg.h"
#include "vbaconfig.h"

/*****************************************************
 * Constructeur et destructeur
 *****************************************************/
VbaConfig::VbaConfig()
{ 
	lcfg_new(&lcfg,0); lcfg_loaded=0; SetDefault(); 
}

VbaConfig::~VbaConfig()
{
	lcfg_free(&lcfg);
}

/*****************************************************
 * Sauvegarde d'un fichier config
 *****************************************************/
#define INT(var_str,var) sprintf(num,"%i",var); lcfg_var_value(&lcfg,var_str,num); 
#define INTHEX(var_str,var) sprintf(num,"%04x",var); lcfg_var_value(&lcfg,var_str,num);
#define INTHEX_normal(var_str,var) sprintf(num,"%0x",var); lcfg_var_value(&lcfg,var_str,num);
#define BOOL(var_str,var) if(var) lcfg_var_value(&lcfg,var_str,"1"); else lcfg_var_value(&lcfg,var_str,"0");
#define STRING(var_str,var) lcfg_var_value(&lcfg,var_str,var.ptr());
bool VbaConfig::SaveConfig(const char *filename)
{
	char num[256];
	_fix_and_verify();

	//si non charg alors il va creer nouveau fichier vide
	if(!lcfg_loaded) {
		CreateConfig(filename);
		//charge les paramtres du fichier...
		if(lcfg_load(&lcfg,filename)) {
			return true;
		}
	}

	//les keys
	INTHEX("Joy0_Left",Joy0_Left);
	INTHEX("Joy0_Right",Joy0_Right);
	INTHEX("Joy0_Up",Joy0_Up);
	INTHEX("Joy0_Down",Joy0_Down);
	INTHEX("Joy0_A",Joy0_A);
	INTHEX("Joy0_B",Joy0_B);
	INTHEX("Joy0_L",Joy0_L);
	INTHEX("Joy0_R",Joy0_R);
	INTHEX("Joy0_Start",Joy0_Start);
	INTHEX("Joy0_Select",Joy0_Select);
	INTHEX("Joy0_Speed",Joy0_Speed);
	INTHEX("Joy0_Capture",Joy0_Capture);
	INTHEX("Motion_Left",Motion_Left);
	INTHEX("Motion_Right",Motion_Right);
	INTHEX("Motion_Up",Motion_Up);
	INTHEX("Motion_Down",Motion_Down);
	
	INT("frameSkip",frameSkip);
	INT("gbFrameSkip",gbFrameSkip);
	INT("video",video);
	BOOL("fullScreen",fullScreen);
	BOOL("disableMMX",disableMMX);
	BOOL("useBios",useBios);
	STRING("biosFile",biosFile);
	INT("filter",filter);
	BOOL("disableStatus",disableStatus);
	BOOL("borderOn",borderOn);
	INT("emulatorType",emulatorType);
	BOOL("colorOption",colorOption);
	STRING("saveDir",saveDir);
	STRING("captureDir",captureDir);
	STRING("batteryDir",batteryDir);
	BOOL("captureFormat",captureFormat);
	INT("soundQuality",soundQuality);
	BOOL("soundEcho",soundEcho);
	BOOL("soundLowPass",soundLowPass);
	BOOL("soundReverse",soundReverse);
	BOOL("removeIntros",removeIntros);
	INT("saveType",saveType);
	BOOL("flashSize",flashSize);
	INT("soundVolume",soundVolume);
	INT("ifbType",ifbType);
	INT("showSpeed",showSpeed);
	BOOL("showSpeedTransparent",showSpeedTransparent);
	BOOL("autoFrameSkip",autoFrameSkip);
	INT("throttle",throttle);
	BOOL("pauseWhenInactive",pauseWhenInactive);
	BOOL("agbPrint",agbPrint);
	BOOL("rtcEnabled",rtcEnabled);
	BOOL("soundOff",soundOff);
	INTHEX_normal("soundEnable",soundEnable);
	BOOL("borderAutomatic",borderAutomatic);
	BOOL("skipBios",skipBios);
	INT("rewindTimer",rewindTimer);
	BOOL("enhancedDetection",enhancedDetection);

	if(lcfg_save(&lcfg,filename)) return true;

	//et la vrification final de la bonne validit des informations
	
	return false;
}
#undef INT
#undef INTHEX
#undef BOOL
#undef STRING

/*****************************************************
 * Chagement d'un fichier config
 *****************************************************/
#define INT(var_str,var) lcfg_get_int(&lcfg,var_str,&var);
#define INTHEX(var_str,var) if((s=lcfg_get_value(&lcfg,var_str))) { AString tmp; tmp << "0x" << s; var = (int)strtol(s,(char **)NULL,16); }
#define BOOL(var_str,var) if(lcfg_get_int(&lcfg,var_str,&i)) { if(i) var=1; else var=0; }
#define STRING(var_str,var) if((s=lcfg_get_value(&lcfg,var_str))) { var = s; }
bool VbaConfig::LoadConfig(const char *filename)
{
	int i;   //var tmp
	char *s; //var tmp
	
	if(lcfg_loaded) lcfg_free(&lcfg); //dsalloque le prcdent
	if(lcfg_load(&lcfg,filename)) return true; //ERREUR
	lcfg_loaded=1;

	//met les trucs par dfaut
	SetDefault();

	//les keys
	INTHEX("Joy0_Left",Joy0_Left);
	INTHEX("Joy0_Right",Joy0_Right);
	INTHEX("Joy0_Up",Joy0_Up);
	INTHEX("Joy0_Down",Joy0_Down);
	INTHEX("Joy0_A",Joy0_A);
	INTHEX("Joy0_B",Joy0_B);
	INTHEX("Joy0_L",Joy0_L);
	INTHEX("Joy0_R",Joy0_R);
	INTHEX("Joy0_Start",Joy0_Start);
	INTHEX("Joy0_Select",Joy0_Select);
	INTHEX("Joy0_Speed",Joy0_Speed);
	INTHEX("Joy0_Capture",Joy0_Capture);
	INTHEX("Motion_Left",Motion_Left);
	INTHEX("Motion_Right",Motion_Right);
	INTHEX("Motion_Up",Motion_Up);
	INTHEX("Motion_Down",Motion_Down);
	
	INT("frameSkip",frameSkip);
	INT("gbFrameSkip",gbFrameSkip);
	INT("video",video);
	BOOL("fullScreen",fullScreen);
	BOOL("disableMMX",disableMMX);
	BOOL("useBios",useBios);
	STRING("biosFile",biosFile);
	INT("filter",filter);
	BOOL("disableStatus",disableStatus);
	BOOL("borderOn",borderOn);
	INT("emulatorType",emulatorType);
	BOOL("colorOption",colorOption);
	STRING("saveDir",saveDir);
	STRING("captureDir",captureDir);
	STRING("batteryDir",batteryDir);
	BOOL("captureFormat",captureFormat);
	INT("soundQuality",soundQuality);
	BOOL("soundEcho",soundEcho);
	BOOL("soundLowPass",soundLowPass);
	BOOL("soundReverse",soundReverse);
	BOOL("removeIntros",removeIntros);
	INT("saveType",saveType);
	BOOL("flashSize",flashSize);
	INT("soundVolume",soundVolume);
	INT("ifbType",ifbType);
	INT("showSpeed",showSpeed);
	BOOL("showSpeedTransparent",showSpeedTransparent);
	BOOL("autoFrameSkip",autoFrameSkip);
	INT("throttle",throttle);
	BOOL("pauseWhenInactive",pauseWhenInactive);
	BOOL("agbPrint",agbPrint);
	BOOL("rtcEnabled",rtcEnabled);
	BOOL("soundOff",soundOff);
	INTHEX("soundEnable",soundEnable);
	BOOL("borderAutomatic",borderAutomatic);
	BOOL("skipBios",skipBios);
	INT("rewindTimer",rewindTimer);
	BOOL("enhancedDetection",enhancedDetection);

	//et la vrification final de la bonne validit des informations
	_fix_and_verify();
	
	return false;
}
#undef INT
#undef INTHEX
#undef BOOL
#undef STRING

/*****************************************************
 * si une variable contient quelque chose
 * d'"anormal" comme par exemple un
 * frame skip de 16543516565 il le fixe 
 * ce qui a t dfini dans le fichier de config.
 ****************************************************/
#define PLAGE(var,begin,end) if(var<begin) var=begin; else if(var>end) var=end;
#define BOOL(v) if(v) v=1; else v=0;
void VbaConfig::_fix_and_verify()
{
	PLAGE(frameSkip,0,5);
	PLAGE(gbFrameSkip,0,5);
	PLAGE(video,0,3);
	BOOL(fullScreen);
	BOOL(disableMMX);
	BOOL(useBios);
	//biosFile=string
	PLAGE(filter,0,12);
	BOOL(disableStatus);
	BOOL(borderOn);
	PLAGE(emulatorType,0,5);
	BOOL(colorOption);
	//String:saveDir,captureDir,batteryDir
	BOOL(captureFormat);
	
	//soundQuality=1 2 4
	PLAGE(soundQuality,1,4);
	if(soundQuality==3) soundQuality=4; //l'intrus

	BOOL(soundEcho);
	BOOL(soundLowPass);
	BOOL(soundReverse);
	BOOL(removeIntros);
	PLAGE(saveType,0,5);
	BOOL(flashSize);
	PLAGE(soundVolume,0,3);
	PLAGE(ifbType,0,2);
	PLAGE(showSpeed,0,2);
	BOOL(showSpeedTransparent);
	BOOL(autoFrameSkip);

	// Throttle 0 ou 5  1000
	PLAGE(throttle,0,1000);
	if(throttle<5 && throttle!=0) throttle=0; //intrus

	BOOL(pauseWhenInactive);
	BOOL(agbPrint);
	BOOL(rtcEnabled);
	BOOL(soundOff);

	//cas exceptionnel
	//soundEnable TODO

	BOOL(borderAutomatic);
	BOOL(skipBios);
	PLAGE(rewindTimer,0,60);
	BOOL(enhancedDetection);
}
#undef PLAGE
#undef BOOL

/*****************************************************
 * Met toutes les options par dfaut (comme dfini
 * dans le fichier de configuration de Visual
 * Boy Advance).
 ****************************************************/
void VbaConfig::SetDefault()
{
	//Controles
	Joy0_Left=0x0114;
	Joy0_Right=0x0113;
	Joy0_Up=0x0111;
	Joy0_Down=0x0112;
	Joy0_A=0x007a;
	Joy0_B=0x0078;
	Joy0_L=0x0061;
	Joy0_R=0x0073;
	Joy0_Start=0x000d;
	Joy0_Select=0x0008;
	Joy0_Speed=0x0020;
	Joy0_Capture=0x0125;
	
	//Left/right/up/down
	Motion_Left=0x0104;
	Motion_Right=0x0106;
	Motion_Up=0x0108;
	Motion_Down=0x0102;

	//Autre
	frameSkip=2;
	gbFrameSkip=0;
	video=1;
	fullScreen=0;
	disableMMX=1;
	useBios=0;
	biosFile="none";
	filter=0;
	disableStatus=0;
	borderOn=0;
	emulatorType=1;
	colorOption=1;
	captureFormat=0;
	soundQuality=2;
	soundEcho=0;
	soundLowPass=0;
	soundReverse=0;
	removeIntros=0;
	saveType=0;
	flashSize=0;
	soundVolume=0;
	ifbType=0;
	showSpeed=1;
	showSpeedTransparent=1;
	autoFrameSkip=0;
	throttle=0;
	pauseWhenInactive=0;
	agbPrint=0;
	rtcEnabled=0;
	soundOff=0;
	soundEnable=0x30f;
	borderAutomatic=0;
	skipBios=0;
	rewindTimer=0;
	enhancedDetection=1;
	
	saveDir="";
	captureDir="";
	batteryDir="";
}

/*****************************************************
 * Fonction pour crer un nouveau fichier 
 * de configuration... Avec commentaires originaux :-)
 *
 * Retourne true si erreur d'ouverture de fichier en
 * criture.
 *****************************************************/
#define ADD(s) fprintf(file,"%s\n",s)
bool VbaConfig::CreateConfig(const char *filename)
{
	FILE *file = fopen(filename, "w");
	if(!file) return 1;
	ADD("# All numeric values are in hexadecimal");
	ADD("# Use TAB or EQUAL sign to separate name from value");
	ADD("");
	ADD("#");
	ADD("# Key configuration (all numbers are in hexadecimal!)");
	ADD("#");
	ADD("# Keys values are in the format YXXX where Y is the device number. 0 means");
	ADD("# keyborad and XXX is the SDL define for the desired key (read SDL_keysym.h).");
	ADD("#");
	ADD("# If Y is greater than 0, it means joystick number Y-1 and it uses the");
	ADD("# following format for XXX:");
	ADD("#");
	ADD("# - if XXX < 20, XXX is the axis number multiplied by 2. An even number means");
	ADD("#   movement to the negative side (on the X axis, it means left). An odd");
	ADD("#   number means movement to the positive side (on the X axis, it mean");
	ADD("#   right). For the Y axis, negative means up and positive means down.");
	ADD("#   X axis is usally axis number 0 and Y is axis number 1.");
	ADD("# - if 20 >= XXX > 30, then XXX is the HAT number multiplied by 4 plus the");
	ADD("#   direction: 0 for up, 1 for down, 2 for right and 3 for left. Example:");
	ADD("#   0021 is HAT 0 down, 0026 is HAT 1 right.");
	ADD("# - if 80 >= XXX > 100, XXX is the joystick button number (XXX-080).");
	ADD("#");
	ADD("# Default key configuration is (value in parenthesis):");
	ADD("#");
	ADD("# Left          Left Arrow  (0114)");
	ADD("# Right         Right Arrow (0113)");
	ADD("# Up            Up Arrow    (0111)");
	ADD("# Down          Down Arrow  (0112)");
	ADD("# A             Z           (007a)");
	ADD("# B             X           (0078)");
	ADD("# L             A           (0061)");
	ADD("# R             S           (0073)");
	ADD("# Start         ENTER       (000d)");
	ADD("# Select        BACKSPACE   (0008)");
	ADD("# Speed up      SPACE       (0020)");
	ADD("# Capture       F12         (0125)");
	ADD("#");
	
	//JOYSTICK
	fprintf(file,"Joy0_Left=%04x\n",Joy0_Left);
	fprintf(file,"Joy0_Right=%04x\n",Joy0_Right);
	fprintf(file,"Joy0_Up=%04x\n",Joy0_Up);
	fprintf(file,"Joy0_Down=%04x\n",Joy0_Down);
	fprintf(file,"Joy0_A=%04x\n",Joy0_A);
	fprintf(file,"Joy0_B=%04x\n",Joy0_B);
	fprintf(file,"Joy0_L=%04x\n",Joy0_L);
	fprintf(file,"Joy0_R=%04x\n",Joy0_R);
	fprintf(file,"Joy0_Start=%04x\n",Joy0_Start);
	fprintf(file,"Joy0_Select=%04x\n",Joy0_Select);
	fprintf(file,"Joy0_Speed=%04x\n",Joy0_Speed);
	fprintf(file,"Joy0_Capture=%04x\n",Joy0_Capture);
	
	// Avant motion
	ADD("");
	ADD("# Motion support keys. Same format as above");
	ADD("#");
	ADD("# Default keys are (value in parenthesis):");
	ADD("#");
	ADD("# Left          Numeric Pad 4 (0104)");
	ADD("# Right         Numeric Pad 6 (0106)");
	ADD("# Up            Numeric Pad 8 (0108)");
	ADD("# Down          Numeric Pad 2 (0102)");
	ADD("#");
	
	// Motion
	fprintf(file,"Motion_Left=%04x\n",Motion_Left);
	fprintf(file,"Motion_Right=%04x\n",Motion_Right);
	fprintf(file,"Motion_Up=%04x\n",Motion_Up);
	fprintf(file,"Motion_Down=%04x\n",Motion_Down);
	
	//frame skipping
	ADD("\n# Frame skip setting. Allowed values are from 0 to 5 only.");
	fprintf(file,"frameSkip=%i\n",frameSkip);
	
	ADD("\n# Gameboy Frame skip setting. Allowed values are from 0 to 5 only.");
	fprintf(file,"gbFrameSkip=%i\n",gbFrameSkip);

	ADD("\n# Video setting. 0=1x, 1=2x, 2=3x, 3=4x.");
	fprintf(file,"video=%i\n",video);

	ADD("\n# Use fullscreen mode. 0=false, any other value means true");
	fprintf(file,"fullScreen=%i\n",fullScreen);

	ADD("\n# Disables MMX support");
	fprintf(file,"disableMMX=%i\n",disableMMX);

	ADD("\n# Use bios file. 0=false, any other value means true");
	fprintf(file,"useBios=%i\n",useBios);


	ADD("\n# Bios file full path and name (ZIP not supported)");
	fprintf(file,"biosFile=%s\n",biosFile.ptr());

	ADD("\n# Filter to use. 0=no filter, 1=TV Mode, 2=2xSaI, 3=Super 2xSaI, 4=Super Eagle");
	ADD("# 5=Pixelate, 6=Motion Blur, 7=AdvanceMAME Scale2x, 8=Simple 2x,");
	ADD("# 9=Bilinear, A=Bilinear Plus, B=hq2x, C=lq2x");
	fprintf(file,"filter=%i\n",filter);

	ADD("\n# Disable status messages. 0=false, any other value means true");
	fprintf(file,"disableStatus=%i\n",disableStatus);

	ADD("\n# Enable Gameboy border. 0=false, any other value means true");
	fprintf(file,"borderOn=%i\n", borderOn);

	ADD("\n# Gameboy emulator type. 0=automatic, 1=CGB/GBC, 2=SGB, 3=GB, 4=GBA, 5=SGB2");
	fprintf(file,"emulatorType=%i\n",emulatorType);

	ADD("\n# Enable washed colors. 0=false, any other value means true");
	fprintf(file,"colorOption=%i\n",colorOption);

	ADD("\n# Directories. Not setting one them makes the file go the rom directory.");
	ADD("\n# Save state directory");

	if(saveDir=="") 
		fprintf(file,"#saveDir=\n");
	else
		fprintf(file,"saveDir=%s\n",saveDir.ptr());

	ADD("\n# Screen shot Capture directory");
	if(captureDir=="") 
		fprintf(file,"captureDir=\n");
	else
		fprintf(file,"captureDir=%s\n",captureDir.ptr());

	ADD("\n# Battery directory");
	if(batteryDir=="") 
		fprintf(file,"batteryDir=\n");
	else
		fprintf(file,"batteryDir=%s\n",batteryDir.ptr());

	ADD("\n# Screen capture format");
	ADD("# 0=PNG, anything else for BMP");
	fprintf(file,"captureFormat=%i\n",captureFormat);

	ADD("\n# Sound quality");
	ADD("# 1=44 Khz, 2=22Khz, 4=11Khz");
	fprintf(file,"soundQuality=%i\n",soundQuality);

	ADD("\n# Sound Echo");
	ADD("# 0=false, anything else for true");
	fprintf(file,"soundEcho=%i\n",soundEcho);

	ADD("\n# Sound Low pass filter");
	ADD("# 0=false, anything else for true");
	fprintf(file,"soundLowPass=%i\n",soundLowPass);

	ADD("\n# Sound reverse stereo");
	ADD("# 0=false, anything else for true");
	fprintf(file,"soundReverse=%i\n",soundReverse);

	ADD("\n# Remove GBA intros (not supported anymore)");
	ADD("# 0=false, anything else for true");
	if(removeIntros==0)
		fprintf(file,"#removeIntros=0\n");
	else
		fprintf(file,"removeIntros=%i\n",removeIntros);

	ADD("\n# Save Type");
	ADD("# 0=automatic, 1=EEPROM, 2=SRAM, 3=Flash, 4=EEPROM+Sensor, 5=NONE");
	fprintf(file,"saveType=%i\n",saveType);

	ADD("\n# Flash size");
	ADD("# 0=64K Flash, 1=128K Flash\n");
	fprintf(file,"flashSize=%i\n",flashSize);

	ADD("\n# Sound volume");
	ADD("# 0=1x, 1=2x, 2=3x, 3=4x");
	fprintf(file,"soundVolume=%i\n",soundVolume);

	ADD("\n# Interframe blending");
	ADD("# 0=none, 1=motion blur, 2=smart");
	fprintf(file,"ifbType=%i\n",ifbType);

	ADD("\n# Show emulation speed");
	ADD("# 0=none, 1=percentage, 2=detailed");
	fprintf(file,"showSpeed=%i\n",showSpeed);

	ADD("\n# Show speed in transparent mode");
	ADD("# 0=normal, anything else for transparent");
	fprintf(file,"showSpeedTransparent=%i\n",showSpeedTransparent);

	ADD("\n# Enable/Disable auto frameskip");
	ADD("# 0=disable, anything else to enable");
	fprintf(file,"autoFrameSkip=%i\n",autoFrameSkip);

	ADD("\n# Sets the desired throttle");
	ADD("# 0=disable, 5...1000 valid throttle speeds");
	fprintf(file,"throttle=%i\n",throttle);

	ADD("\n# Pauses the emulator when the window is inactive");
	ADD("# 0=disable, anything else to enable");
	fprintf(file,"pauseWhenInactive=%i\n",pauseWhenInactive);

	ADD("\n# Enables AGBPrint support");
	ADD("# 0=disable, anything else to enable");
	fprintf(file,"agbPrint=%i\n",agbPrint);

	ADD("\n# Enables GBA RTC support");
	ADD("# 0=disable, anything else to enable");
	fprintf(file,"rtcEnabled=%i\n",rtcEnabled);

	ADD("\n# Sound OFF flag");
	ADD("# 0=sound on, anything else turns off sound");
	fprintf(file,"soundOff=%i\n",soundOff);

	ADD("\n# Sound Enable");
	ADD("# Controls which channels are enabled: (add values)");
	ADD("#   1 - Channel 1");
	ADD("#   2 - Channel 2");
	ADD("#   4 - Channel 3");
	ADD("#   8 - Channel 4");
	ADD("# 100 - DirectSound A");
	ADD("# 200 - DirectSound B");
	ADD("# 30f=all enabled, 0=mute all");
	fprintf(file,"soundEnable=%3x\n",soundEnable);

	ADD("\n# Controls automatic SGB border");
	ADD("# 0=disable, anything else enables automatic SGB border display");
	fprintf(file,"borderAutomatic=%i\n",borderAutomatic);

	ADD("\n# Skip bios code");
	ADD("# 0=disable, anything else skips BIOS code");
	fprintf(file,"skipBios=%i\n",skipBios);

	ADD("\n# The interval between the rewind saves");
	ADD("# Minimum of 0 seconds to disable rewind support, ");
	ADD("# Maximum of 60 minutes. Value in seconds (hexadecimal numbers)");
	fprintf(file,"rewindTimer=%i\n",rewindTimer);

	ADD("\n# Enable enhanced save type detection");
	ADD("# 0=disable, anything else to enable (no longer used)");
	if(enhancedDetection==1)
		fprintf(file,"#enhancedDetection=1\n");
	else
		fprintf(file,"enhancedDetection=%i\n",enhancedDetection);

	fclose(file);
	return false; //aucune erreur!
}


/*****************************************************
 * Ecrire le contenu de la classe VbaConfig dans
 * une interface "i"
 * (communication avec l'interface)
 ****************************************************/
#define HEXA(output,var) sprintf(tmp,"%04x",var); output->value(tmp);
void VbaConfig::Put(Interface *i)
{
	char tmp[256];
	_fix_and_verify(); //... :-)

	// Plein Ecran
	i->check_plein_ecran->value(fullScreen);

	// Interframe
	i->check_interframe_aucune->value(0); 
	i->check_interframe_smart->value(0); 
	i->check_interframe_motion->value(0); 
	if(ifbType==0) i->check_interframe_aucune->value(1);
	else if(ifbType==1) i->check_interframe_motion->value(1);
	else i->check_interframe_smart->value(1);

	// Frame Skip
	i->check_auto_skip->value(autoFrameSkip);
	i->check_auto_skip->do_callback();

	// Slide Frame Skip
	i->slide_frame_skip->value(frameSkip);
	i->slide_gb_skip->value(gbFrameSkip);

	//filtre graphique :-)!
	i->browser_filter->value(filter+1); //+1 car le browser commence par 1

	//Qualit de son
	i->radio_44->value(0); i->radio_22->value(0); i->radio_11->value(0); 
	if(soundQuality==4) i->radio_11->value(1);
	else if(soundQuality==2) i->radio_22->value(1);
	else i->radio_44->value(1);

	//volume
	i->slide_volume->value(soundVolume);

	//soundEnabled
	i->check_son_active->value(!soundOff);
	i->check_son_active->do_callback(); //comme a il fait son travail

	// Reverse Stereo + LowPass
	i->check_reverse_stereo->value(soundReverse);
	i->check_low_pass_filter->value(soundLowPass);

	//echo
	i->check_echo->value(soundEcho);

	// Screen Cature
	i->radio_capture_bmp->value(0); i->radio_capture_png->value(0); 
	if(captureFormat==1) i->radio_capture_bmp->value(1);
	else i->radio_capture_png->value(1);

	//color option
	i->check_color_option->value(colorOption);

	//Pause when inactive
	i->check_pause_si_inactif->value(pauseWhenInactive);

	//agbPrint
	i->check_agb_print->value(agbPrint);

	//show speed
	i->radio_speed_none->value(0);
	i->radio_speed_detailed->value(0);
	i->radio_speed_percentage->value(0);
	if(showSpeed==0) i->radio_speed_none->value(1);
	else if(showSpeed==1) i->radio_speed_percentage->value(1);
	else i->radio_speed_detailed->value(1);

	//transparent speed
	i->check_speed_transparent->value(showSpeedTransparent);

	//disableMMX
	i->check_enable_mmx->value(!disableMMX);

	//disableStatus
	i->check_disable_status->value(disableStatus);

	//les keys
	HEXA(i->output_key_left, Joy0_Left);
	HEXA(i->output_key_right, Joy0_Right);
	HEXA(i->output_key_up, Joy0_Up);
	HEXA(i->output_key_down, Joy0_Down);
	HEXA(i->output_key_a, Joy0_A);
	HEXA(i->output_key_b, Joy0_B);
	HEXA(i->output_key_l, Joy0_L);
	HEXA(i->output_key_r, Joy0_R);
	HEXA(i->output_key_start, Joy0_Start);
	HEXA(i->output_key_select, Joy0_Select);
	HEXA(i->output_key_speed, Joy0_Speed);
	HEXA(i->output_key_capture, Joy0_Capture);

	//video
	i->slide_video->value(video);

	//borderAutomatic
	i->check_bordure_auto->value(borderAutomatic);

	//pour spcifier automatiquement le chemin de sauvegarde...
	i->output_chemin_sauvegardes->value(saveDir.ptr());
	i->output_chemin_captures->value(captureDir.ptr());
	i->output_chemin_gameboy->value(batteryDir.ptr());

	//charger le bios
	if(useBios)
			i->output_chemin_bios->value(biosFile.ptr());
	else
			i->output_chemin_bios->value("");

	//rtc+enhanced
	i->check_enhanced_detection->value(enhancedDetection);
	i->check_enable_rtc->value(rtcEnabled);
}
#undef HEXA

/*****************************************************
 * Lire une interface "i" pour mettre son
 * contenu dans la classe VbaConfig
 * (communication avec l'interface)
 ****************************************************/
#define HEXA(str) (int)strtol(str,(char **)0,16);
void VbaConfig::Get(Interface *i)
{
	//Plein Ecran
	if(i->check_plein_ecran->value()) fullScreen=1; else fullScreen=0;

	// Interframe
	if(i->check_interframe_aucune->value()) ifbType=0;
	else if(i->check_interframe_motion->value()) ifbType=1;
	else ifbType=2;

	//Frame Skip
	if(i->check_auto_skip->value()) autoFrameSkip=1; else autoFrameSkip=0;

	// Slide Frame Skip
	frameSkip=(int)(i->slide_frame_skip->value());
	gbFrameSkip=(int)(i->slide_gb_skip->value());
	
	// Filtre Graphique
	if(i->browser_filter->value()) 
		filter=i->browser_filter->value()-1;
	else 
		filter=0; //aucun si rien de slectionn :-)

	//volume
	soundVolume=(int)i->slide_volume->value();

	//qualit son
	if(i->radio_11->value()) soundQuality=4; //44khz
	else if(i->radio_22->value()) soundQuality=2; //22khz
	else soundQuality=1; //11khz

	//Echo
	if(i->check_echo->value()) soundEcho=1; else soundEcho=0;

	//le son
	if(i->check_son_active->value()) soundOff=0; else soundOff=1;

	// Reverse Stereo + LowPass
	if(i->check_reverse_stereo->value()) soundReverse=1; else soundReverse=0;
	if(i->check_low_pass_filter->value()) soundLowPass=1; else soundLowPass=0;

	// Type de capture
	if(i->radio_capture_png->value()) captureFormat=0; else captureFormat=1;

	//color option
	if(i->check_color_option->value()) colorOption=1; else colorOption=0;
	
	//pause when inactive
	if(i->check_pause_si_inactif->value()) pauseWhenInactive=1; else pauseWhenInactive=0;

	//imprimante game boy
	if(i->check_agb_print->value()) agbPrint=1; else agbPrint=0;

	//speed
	if(i->radio_speed_none->value()) showSpeed=0;
	else if(i->radio_speed_percentage->value()) showSpeed=1;
	else showSpeed=2;

	//speed transparent
	if(i->check_speed_transparent->value()) showSpeedTransparent=1; else showSpeedTransparent=0;

	//mmx
	if(i->check_enable_mmx->value()) disableMMX=0; else disableMMX=1;

	//disable status
	if(i->check_disable_status->value()) disableStatus=1; else disableStatus=0;

	//les keys
	Joy0_Left = HEXA(i->output_key_left->value());
	Joy0_Right = HEXA(i->output_key_right->value());
	Joy0_Up = HEXA(i->output_key_up->value());
	Joy0_Down = HEXA(i->output_key_down->value());
	Joy0_A = HEXA(i->output_key_a->value());
	Joy0_B = HEXA(i->output_key_b->value());
	Joy0_L = HEXA(i->output_key_l->value());
	Joy0_R = HEXA(i->output_key_r->value());
	Joy0_Start = HEXA(i->output_key_start->value());
	Joy0_Select = HEXA(i->output_key_select->value());
	Joy0_Speed = HEXA(i->output_key_speed->value());
	Joy0_Capture = HEXA(i->output_key_capture->value());

	//rtc et enhanced detect
	enhancedDetection = i->check_enhanced_detection->value();
	rtcEnabled = i->check_enable_rtc->value();

	//video
	video = (int)i->slide_video->value();

	//borderAutomatic
	borderAutomatic = i->check_bordure_auto->value();

	//les chemins
	saveDir = i->output_chemin_sauvegardes->value();
	batteryDir = i->output_chemin_gameboy->value();
	captureDir = i->output_chemin_captures->value();

	//on sauve le biosfile
	if(*i->output_chemin_bios->value()) {
			useBios=1;
			biosFile=i->output_chemin_bios->value();
	}
	else {
			useBios=0;
			biosFile="none";
	}
	
	//bon... un petit test au cas ou :-)
	_fix_and_verify();
}
#undef HEXA

