/*
 * unity-webapps-scriptable-object.c
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

#include "unity-webapps-scriptable-object.h"

#include "unity-webapps-binding-dispatcher.h"

#include "unity-webapps-base-js-object.h"



///////////////////////////////////////////////////////
//
//	public
//
///////////////////////////////////////////////////////

NPObject *
unity_webapps_npapi_create_unity_webapps_object (NPP instance)
{
  g_return_val_if_fail (NULL != instance, NULL);

  UnityWebappsJavascriptObjectWrapper * pWrapper =
    (UnityWebappsJavascriptObjectWrapper *) unity_webapps_npapi_create_js_object (instance, "Unity Webapps");

  g_return_val_if_fail (NULL != pWrapper, NULL);

  void on_webapps_binding (const char * const name, UnityWebAppsNpapiMethodPtr method)
  {
    unity_webapps_npapi_add_method (pWrapper, name, method);
  }
  webapps_binding_for_each (on_webapps_binding);

  return (NPObject *) pWrapper;
}




///////////////////////////////////////////////////////
//
//	private
//
///////////////////////////////////////////////////////


#if defined(NPAPI_DEBUG_ENABLED)
/**
 * A pScriptable object should be available so that the function can "close" over it
 * 
 */
#   define DEFINE_LOGGER(name)						\
  void name (const char * const s)					\
  {									\
    if (NULL != pScriptable->instance && NULL != pScriptable->logging_browser_object) \
      {									\
	NPVariant message;						\
	STRINGZ_TO_NPVARIANT(s, message);				\
	NPVariant args [] = { message };				\
	NPVariant response;						\
	NPN_InvokeDefault (pScriptable->instance, pScriptable->logging_browser_object, &args[0], 1, &response); \
	NPN_ReleaseVariantValue (&response);				\
      }									\
  }									\
  do {} while (0)

#else // defined(NPAPI_DEBUG_ENABLED)
#   define DEFINE_LOGGER(name) void name (const char * const s) {}
#endif



