/*
 * Copyright 2013-2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef UBUNTUPURCHASE_H
#define UBUNTUPURCHASE_H

#include <QQuickItem>
#include <QString>
#include "purchase_service.h"
#include "purchase_service_adaptor.h"
#include <token.h>

#ifdef TESTS
#include "tests/fakessoservice.h"
#else
#include <ssoservice.h>
#endif

using namespace UbuntuOne;

namespace UbuntuPurchases {

class UbuntuPurchase : public QQuickItem
{
    Q_OBJECT

    Q_PROPERTY(QString url READ url NOTIFY urlChanged)
    
public:
    UbuntuPurchase(QQuickItem *parent = 0);
    ~UbuntuPurchase();

    Q_INVOKABLE void launchService();
    Q_INVOKABLE void purchaseSucceeded();
    Q_INVOKABLE void purchaseCanceled();

    QString url() { return this->m_url; }
    QString getPurchaseUrl() const;

#ifdef TESTS
    PurchaseService* getPurchaseService() { return m_service; }
    FakeSsoService& getFakeService() { return m_ssoService; }
#endif

Q_SIGNALS:
    void urlChanged();
    void serviceRegistrationFailed();
    void credentialsNotFound();

private Q_SLOTS:
    void handleCredentialsFound(Token token);
    void handleCredentialsNotFound();
    void setPurchaseItemId(QString& id);

private:
    PurchaseService* m_service;
    PurchaseServiceAdaptor* m_serviceAdaptor;

    QString m_url;
    QString m_itemPurchaseId;
    Token m_token;
#ifdef TESTS
    FakeSsoService m_ssoService;
#else
    SSOService m_ssoService;
#endif

    void triggerPurchase();
};

}

QML_DECLARE_TYPE(UbuntuPurchases::UbuntuPurchase)

#endif // UBUNTUPURCHASE_H

