# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright 2014 Canonical Ltd.
# Author: Omer Akram <omer.akram@canonical.com>
#
# This file is part of ubuntu-experience-tests.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>

from autopilot.input import Touch, Pointer
from unity8.shell import tests as unity_tests
from unity8.shell.emulators import main_window

from unity8 import process_helpers


class UbuntuExperienceTestCase(unity_tests.UnityTestCase):

    def setUp(self):
        super(UbuntuExperienceTestCase, self).setUp()
        self.pointing_device = Pointer(Touch.create())
        self._qml_mock_enabled = False
        self._data_dirs_mock_enabled = False
        self.unity_proxy = self.launch_unity()
        process_helpers.unlock_unity(self.unity_proxy)
        self.unity = self.unity_proxy.select_single(main_window.QQuickView)
