/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2014 Martin Brehm
                  2012-2014 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef FESA_H
#define FESA_H


#include "xobject.h"
#include "xobarray.h"
#include "atomgroup.h"
#include "df.h"
#include "timestep.h"


class CFESAnalysis : public CxObject
{
public:
	void Finish();
	void ProcessStep(CTimeStep *ts);
	void Create();
	CFESAnalysis();
	~CFESAnalysis();

	void BuildName();
	void Parse();

	CDF *m_pCrossToUpper;
	CDF *m_pCrossToLower;

	int m_iMol1;
	int m_iMol2;
	bool m_bIntra;

	int m_iMolAtomType1;
	int m_iMolAtomType2;
	int m_iMolAtomRealType1;
	int m_iMolAtomRealType2;
	int m_iMolAtom1;
	int m_iMolAtom2;

	float m_fMinDist;
	float m_fMaxDist;
	int m_iResolution;

	float *m_pLastBuffer;

};


#endif

