char tcl_defs[] = "\
# -----------------------------------------\n\
#	File defs.tcl\n\
#	Definitions and pre-start set up.\n\
# -----------------------------------------\n\
proc usage {} {\n\
    puts \"usage: tk707 options...; please read the documentation (html,info,..) and the unix manual.\"\n\
    exit 0\n\
}\n\
set size_factor 1.0;\n\
set input_file_name \"\";\n\
set new_argv \"\"\n\
for {set i 0} {$i < $argc} {incr i} {\n\
        set argi [lindex $argv $i];\n\
#       puts \"defs.tcl: argv($i) = `$argi'\";\n\
        if {$argi == \"--help\"} {\n\
	    usage\n\
        } elseif {$argi == \"-small\"} {\n\
#           puts \"defs.tcl: small!\";\n\
	    set [lindex $argv $i] \"-n\";\n\
	    set size_factor 0.5;\n\
        } elseif {$argi == \"-medium\"} {\n\
#           puts \"defs.tcl: medium!\";\n\
	    set size_factor 0.75;\n\
        } elseif {$argi == \"-normalsize\"} {\n\
#           puts \"defs.tcl: normal!\";\n\
	    set new_argv \"$new_argv $argi\"\n\
	    set size_factor 1;\n\
	} else {\n\
	    # send option to the 2nd C-code pass...\n\
#           puts \"defs.tcl: argv($i) = `$argi'...added\";\n\
	    set new_argv \"$new_argv $argi\"\n\
	}\n\
}\n\
#\n\
# we strip options to avoid mistakes\n\
#  TODO: send -p x:y nd so to C code\n\
set argv $new_argv\n\
set argc [llength $argv]\n\
#puts \"argv := $argv\"\n\
#puts \"argc := $argc\"\n\
# -----------------------------------------\n\
# pixel to centimeter conversion\n\
# -----------------------------------------\n\
package require Tcl 8.0\n\
package require Tk 8.0\n\
set VERSION 0.7\n\
set PKGDATADIR /yama/home/edp/saramito/sys/SunOS/share/tk707
\n\
# uncomment to show sonme boxes:\n\
#set debug_relief \"-borderwidth 2p -relief groove\";\n\
set debug_relief \"\";\n\
# -----------------------------------------\n\
# pixel <--> point/inch/cm\n\
# -----------------------------------------\n\
set cm_per_inch     2.54;\n\
set point_per_inch 72.00;\n\
set point_per_cm [expr $point_per_inch / $cm_per_inch];\n\
set pixel_per_point [tk scaling]\n\
# puts \"dpi $pixel_per_point\"\n\
set pixel_per_inch [expr int($pixel_per_point*$point_per_inch+0.5)]\n\
set pixel_per_cm   [expr $pixel_per_inch/$cm_per_inch]\n\
# -----------------------------------------\n\
# get window max dimension\n\
# -----------------------------------------\n\
set maxsize_in_pixel   [wm maxsize .]\n\
set maxwidth_in_pixel  [lindex $maxsize_in_pixel 0]\n\
set maxheight_in_pixel [lindex $maxsize_in_pixel 1]\n\
set maxwidth_in_cm     [expr $maxwidth_in_pixel * $pixel_per_cm ]\n\
set maxheight_in_cm    [expr $maxheight_in_pixel* $pixel_per_cm ]\n\
# -----------------------------------------\n\
# resize coefficient if window is too small\n\
# -----------------------------------------\n\
if {$size_factor < 0.75} { 	# small screens\n\
    set size_factor 0.5; \n\
    set font8 \"6\";\n\
    set font12 \"6\"; \n\
    set boldfont12 \"6\"; \n\
    set boldfont13 \"6\";\n\
    set courrier_boldfont_i_50 \"10\"; \n\
    set boldr14 \"8\";\n\
    set helvetica_bold_r_12 \"6\"; \n\
    set normal_r_14 \"8\"; \n\
} elseif {$size_factor < 1.0} { # medium screen\n\
    set size_factor 0.75; \n\
    set font8 \"6\";\n\
    set font12 \"8\";\n\
    set boldfont12 \"8\"; \n\
    set boldfont13 \"8\"; \n\
    set courrier_boldfont_i_50 \"adobe-courier-bold-i-*-30\"; \n\
    set boldr14 \"bold-r-*-10\"; \n\
    set helvetica_bold_r_12 \"8\"; \n\
    set normal_r_14 \"10\"; \n\
} else { 			# normal screen\n\
    set size_factor 1.0;\n\
    set font8 \"8\";\n\
    set font12 \"*-helvetica-medium-o-*--8\";\n\
    set boldfont12 \"*-helvetica-bold-r-*--8\"; \n\
    set boldfont13 \"*-helvetica-bold-r-*--12\"; \n\
    set courrier_boldfont_i_50 \"adobe-courier-bold-i-*-50\"; \n\
    set boldr14 \"bold-r-*-14\"; \n\
    set helvetica_bold_r_12 \"helvetica-bold-r-*-12\"; \n\
    set normal_r_14 \"normal-r-*-14\"; \n\
}\n\
# -----------------------------------------\n\
# pixel to centimeter conversion\n\
# -----------------------------------------\n\
set scaling $size_factor;\n\
tk scaling $scaling\n\
set pixel_per_point [tk scaling]\n\
set point_per_pixel [expr 1./$pixel_per_point]\n\
set pixel_per_inch [expr int($pixel_per_point*$point_per_inch+0.5)]\n\
set pixel_per_cm   [expr $pixel_per_inch/$cm_per_inch]\n\
# -----------------------------------------\n\
# set global constants\n\
# -----------------------------------------\n\
set tcl_rcFileName \"~/.tk707rc\"\n\
if {[catch {open $tcl_rcFileName r} fid]} {\n\
} else {\n\
      catch {source $tcl_rcFileName}\n\
}\n\
set res [eval tk7_init $argv]\n\
if {$res == 1 || $res == 3} {\n\
	exit\n\
} elseif {$res ==2} {\n\
	wm iconify .\n\
	port_setup\n\
	tk7_init\n\
}\n\
rename exit exit.old\n\
proc exit {} {\n\
	exit707\n\
	exit.old\n\
}\n\
# -----------------------------------------\n\
# set global constants\n\
# -----------------------------------------\n\
set right_space_width 0.5;\n\
\n\
\n\
set tkxox(VERSION)		\"TK707-$VERSION\"\n\
set tkxox(READ) 		0\n\
set tkxox(WRITE) 		1\n\
set tkxox(TRACK) 		0\n\
set tkxox(PATTERN) 		1\n\
set tkxox(STOP)			0\n\
set tkxox(START)		1\n\
set tkxox(CONT)			2\n\
set tkxox(FILE_UNCHANGED)	0\n\
set tkxox(FILE_MODIFIED)	1\n\
set tkxox(col_on) 		#ffaa00\n\
set tkxox(col_active) 		#ffaaaa\n\
set tkxox(col_def_bg) 		#d9d9d9\n\
set tkxox(col_def_active) 	#ececec\n\
set tkxox(but_grey) 		#888888\n\
set tkxox(but_grey_active) 	#999999\n\
set tkxox(but_grey_on) 		#bbbbbb\n\
set tkxox(lamp_off) 		#882200\n\
set tkxox(lamp_on) 		#ff8800\n\
set tkxox(color_fg_shift)    	#ffffff;       # the text on the shift keys (white)\n\
set tkxox(color_bg_shift)       #000044cffb22; # the box on the shift keys (blue)\n\
set tkxox(vol_trough_color) 	#a5e3a5e3a5e3; # background of the trough for volume\n\
set tkxox(vol_slider_passive)   #570a570a570a; # volume slider when nothing append\n\
set tkxox(vol_slider_active)    #204120412041; # volume slider when we interact\n\
set tkxox(vol_highlightbackground) $tkxox(col_def_bg); # the border outside volumes\n\
\n\
set tkxox(color_score_bg)       #c24d108c09e9;  # the color of rectangles arround notes\n\
set tkxox(score_active_note)    #ffffff; 	# the color of used notes on the score\n\
set tkxox(score_passive_note)   #87cfff; 	# the color of unused  notes (at right)\n\
\n\
set tkxox(color_title_fg)       $tkxox(color_bg_shift);  # the color of \"RHYTHM COMPOSER\"\n\
set tkxox(color_title_logo_fg)  $tkxox(vol_slider_active); # the color of \"TK-707\"\n\
set tkxox(color_title_bg)       $tkxox(col_def_bg); \n\
\n\
set tkxox(tick_flam_duration)	4\n\
#\n\
# color background\n\
#\n\
tk_setPalette $tkxox(col_def_bg)\n\
#\n\
#\n\
# Properties of note elements:\n\
# WARNING: may be as in <util.h>\n\
#\n\
set tkxox(flam)               	[expr 1 << 0]\n\
set tkxox(weak_accent)       	[expr 1 << 1]\n\
set tkxox(strong_accent)     	[expr 1 << 2]\n\
set tkxox(zero_velocity)       	[expr 1 << 3]\n\
set tkxox(velocity_field)       [expr $tkxox(zero_velocity) | \\\n\
				      $tkxox(weak_accent)   | \\\n\
				      $tkxox(strong_accent)]\n\
\n\
set tkxox(col_default_velocity) $tkxox(but_grey)\n\
set tkxox(col_weak_accent)      $tkxox(lamp_on)\n\
set tkxox(col_strong_accent)    #ff0000\n\
set tkxox(col_zero_velocity)    white\n\
\n\
\n\
set mode(rdrw) 			$tkxox(READ)\n\
set mode(patr) 			-1\n\
set mode(stopgo) 		$tkxox(STOP)\n\
set mode(patgroup) 		0\n\
set mode(current_track) 	0\n\
set mode(current_pattern) 	0\n\
set mode(current_instr)		1\n\
set mode(measure) 		-1\n\
set mode(tempo) 		120\n\
set mode(cartridge) 		0\n\
set mode(midi_channel) 		0\n\
set mode(PATTERN_REPEAT) 	false\n\
set mode(TRACK_START) 		false\n\
set mode(REPEAT_INTERVAL) 	5\n\
set mode(showtrack)		true\n\
set mode(current_accent)	0\n\
set mode(file_status)		$tkxox(FILE_UNCHANGED)\n\
\n\
set flash(count) -1\n\
set flash(duration) 20\n\
\n\
# Default sound mapping\n\
#\n\
set sound(1,name) \"Bass 1\"\n\
set sound(1,shortname) \"Bass 1\"\n\
set sound(1,note) 35\n\
set sound(2,name) \"Bass 2\"\n\
set sound(2,shortname) \"Bass 2\"\n\
set sound(2,note) 36\n\
set sound(3,name) \"Snare 1\"\n\
set sound(3,shortname) \"Snare 1\"\n\
set sound(3,note) 38\n\
set sound(4,name) \"Snare 2\"\n\
set sound(4,shortname) \"Snare 2\"\n\
set sound(4,note) 40\n\
set sound(5,name) \"LowTom\"\n\
set sound(5,shortname) \"LowTom\"\n\
set sound(5,note) 41\n\
set sound(6,name) \"MidTom\"\n\
set sound(6,shortname) \"MidTom\"\n\
set sound(6,note) 45\n\
set sound(7,name) \"HighTom\"\n\
set sound(7,shortname) \"HighTom\"\n\
set sound(7,note) 48\n\
set sound(8,name) \"Rim\"\n\
set sound(8,shortname) \"Rim\"\n\
set sound(8,note) 37\n\
set sound(9,name) \"Cowbell\"\n\
set sound(9,shortname) \"Cowbell\"\n\
set sound(9,note) 56\n\
set sound(10,name) \"Hand Clap\"\n\
set sound(10,shortname) \"Clap\"\n\
set sound(10,note) 39\n\
set sound(11,name) \"Tambourine\"\n\
set sound(11,shortname) \"Tamb\"\n\
set sound(11,note) 54\n\
set sound(12,name) \"HH Closed 1\"\n\
set sound(12,shortname) \"HH C1\"\n\
set sound(12,note) 42\n\
set sound(13,name) \"HH Closed 2\"\n\
set sound(13,shortname) \"HH C2\"\n\
set sound(13,note) 42\n\
set sound(14,name) \"HHat Open\"\n\
set sound(14,shortname) \"HH Open\"\n\
set sound(14,note) 46\n\
set sound(15,name) \"Crash\"\n\
set sound(15,shortname) \"Crash\"\n\
set sound(15,note) 49\n\
set sound(16,name) \"Ride\"\n\
set sound(16,shortname) \"Ride\"\n\
set sound(16,note) 51\n\
tk7_set_sounds\n\
#\n\
# instrument(1:16) to volume(1:10) mapping\n\
#\n\
set instrument_to_volume(1) 1\n\
set instrument_to_volume(2) 1\n\
set instrument_to_volume(3) 2\n\
set instrument_to_volume(4) 2\n\
set instrument_to_volume(5) 3\n\
set instrument_to_volume(6) 4\n\
set instrument_to_volume(7) 5\n\
set instrument_to_volume(8) 6\n\
set instrument_to_volume(9) 6\n\
set instrument_to_volume(10) 7\n\
set instrument_to_volume(11) 7\n\
set instrument_to_volume(12) 8\n\
set instrument_to_volume(13) 8\n\
set instrument_to_volume(14) 8\n\
set instrument_to_volume(15) 9\n\
set instrument_to_volume(16) 10\n\
\n\
#\n\
# default abbrevs, for volume labels\n\
#\n\
set sound(1,abbrev)  \"BASS\"\n\
set sound(2,abbrev)  \"\"\n\
set sound(3,abbrev)  \"SNARE\"\n\
set sound(4,abbrev)  \"\"\n\
set sound(5,abbrev)  \"LT\"\n\
set sound(6,abbrev)  \"MT\"\n\
set sound(7,abbrev)  \"HT\"\n\
set sound(8,abbrev)  \"R\"\n\
set sound(9,abbrev)  \"CB\"\n\
set sound(10,abbrev) \"C\"\n\
set sound(11,abbrev) \"T\"\n\
set sound(12,abbrev) \"HH\"\n\
set sound(13,abbrev) \"\"\n\
set sound(14,abbrev) \"\"\n\
set sound(15,abbrev) \"CRASH\"\n\
set sound(16,abbrev) \"RIDE\"\n\
#\n\
# default volume labels\n\
#\n\
set volume_label(0) \"ACCENT\"\n\
set volume_label(1) \"$sound(1,abbrev)\"\n\
set volume_label(2) \"$sound(3,abbrev)\"\n\
set volume_label(3) \"$sound(5,abbrev)\"\n\
set volume_label(4) \"$sound(6,abbrev)\"\n\
set volume_label(5) \"$sound(7,abbrev)\"\n\
set volume_label(6) \"$sound(8,abbrev)/$sound(9,abbrev)\"\n\
set volume_label(7) \"$sound(10,abbrev)/$sound(11,abbrev)\"\n\
set volume_label(8) \"$sound(12,abbrev)\"\n\
set volume_label(9) \"$sound(15,abbrev)\"\n\
set volume_label(10) \"$sound(16,abbrev)\"\n\
#\n\
# default implicit delay (e.g. short sound)\n\
#\n\
set has_delay(1) 0\n\
set has_delay(2) 0\n\
set has_delay(3) 0\n\
set has_delay(4) 0\n\
set has_delay(5) 0\n\
set has_delay(6) 0\n\
set has_delay(7) 0\n\
set has_delay(8) 0\n\
set has_delay(9) 0\n\
set has_delay(10) 0\n\
set has_delay(11) 0\n\
set has_delay(12) 0\n\
set has_delay(13) 0\n\
set has_delay(14) 0\n\
set has_delay(15) 0\n\
set has_delay(16) 0\n\
";
