[comment {-*- tcl -*- doctools manpage}]
[manpage_begin transfer::receiver n 0.3]
[keywords channel]
[keywords copy]
[keywords {data destination}]
[keywords receiver]
[keywords secure]
[keywords ssl]
[keywords tls]
[keywords transfer]
[copyright {2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Data transfer facilities}]
[titledesc {Data source}]
[category  {Transfer module}]
[require Tcl                         "8.5 9"]
[require snit                        [opt 1.0]]
[require transfer::data::destination [opt 0.3]]
[require transfer::connect           [opt 0.3]]
[require transfer::receiver          [opt 0.3]]
[description]
[para]

This package pulls data destinations and connection setup together
into a combined object for the reception of information coming in over
a socket.

These objects understand all the options from objects created by the
packages [package transfer::data::destination] and
[package transfer::connect].

[section API]
[subsection {Package commands}]

[list_begin definitions]

[call [cmd transfer::receiver] \
	[arg object] \
	[opt [arg options]...]]

This command creates a new receiver object with an associated Tcl
command whose name is [arg objectName].

This [term object] command is explained in full detail in the sections
[sectref {Object command}] and [sectref {Object methods}]. The set of
supported [arg options] is explained in section [sectref {Options}].

[para]

The object command will be created under the current namespace if the
[arg objectName] is not fully qualified, and in the specified
namespace otherwise.

The fully qualified name of the object command is returned as the
result of the command.

[call [cmd transfer::receiver] [method {stream channel}] \
     [arg chan] [arg host] [arg port] [opt [arg arg]...]]

This method creates a fire-and-forget transfer for the data coming
from the source at host/port (details below) and writing to the
channel [arg chan], starting at the current seek location. The channel
is configured to use binary translation and encoding for the transfer.

The channel is [emph not] closed when the transfer has completed. This
is left to the completion callback.

[para]

If both [arg host] and [arg port] are provided an [const active]
connection to the data source is made. If only a [arg port] is
specified (with [arg host] the empty string) then a [const passive]
connection is made instead, i.e. the receiver then waits for a
conneciton by the transmitter.

[para]

Any arguments after the port are treated as options and are used to
configure the internal receiver object.

See the section [sectref Options] for a list of the supported options
and their meaning.

[emph Note] however that the signature of the command prefix specified
for the [option -command] callback differs from the signature for the
same option of the receiver object.

This callback is only given the number of bytes and transfered, and
possibly an error message. No reference to the internally used
receiver object is made.

[para]
[vset RETURNER command]
[vset OBJECT {if it was set}]
[vset QUALIFIER {internal receiver}]
[include include/connect_result_ref.inc]

[call [cmd transfer::receiver] [method {stream file}] \
     [arg path] [arg host] [arg port] [opt [arg arg]...]]

This method is like [method {stream channel}], except that the
received data is written to the file [arg path], replacing any prior
content.

[list_end]

[subsection {Object command}]

All objects created by the [cmd ::transfer::receiver] command have the
following general form:

[list_begin definitions]

[call [arg objectName] [method method] [opt [arg "arg arg ..."]]]

The method [method method] and its [arg arg]'uments determine the
exact behavior of the command.

See section [sectref {Object methods}] for the detailed
specifications.

[list_end]

[subsection {Object methods}]

[list_begin definitions]

[call [arg objectName] [method destroy]]

This method destroys the object. Doing so while a reception is on
progress will cause errors later on, when the reception completes
and tries to access the now missing data structures of the destroyed
object.

[call [arg objectName] [method start]]

This method initiates the data reception, setting up the connection
first and then copying the received information into the
destination.

The method will throw an error if a reception is already/still in
progress.

I.e. it is not possible to run two receptions in parallel, only in
sequence.

Errors will also be thrown if the configuration of the data
destination is invalid, or if no completion callback was specified.

[para]
[vset RETURNER method]
[vset OBJECT {for an object configured}]
[vset QUALIFIER {}]
[include include/connect_result_ref.inc]

[call [arg objectName] [method busy]]

This method returns a boolean value telling us whether a reception
is in progress ([const True]), or not ([const False]).

[list_end]

[subsection Options]

All receiver objects support the union of the options supported by
their connect and data destination components, plus one of their own.

See also the documentation for the packages
[package transfer::data::destination] and [package transfer::connect].

[list_begin options]
[vset MODE reception] [include include/complete.inc]

[include include/connect_options.inc]
[include include/ddest_options.inc]
[list_end]

[vset OBJCREATE {transfer::receiver R}]
[include include/secure.inc]

[vset CATEGORY transfer]
[include ../common-text/feedback.inc]
[comment {

This option specifies the command to invoke when the transmission of
the information in the data source has been completed. The arguments
given to this command are the same as given to the completion callback
of method [cmd receive], see package
[package transfer::data::destination].

}]
[manpage_end]
