from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

compilers = _Mock()

division = _Mock()

os = _Mock()

print_function = _Mock()



class GnuFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'gnu'
  description = 'GNU Fortran 77 compiler'
  exe_extension = ''
  g2c = 'g2c'
  library_switch = '-o '
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'
  suggested_f90_compiler = 'gnu95'

class VastFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'vast'
  description = 'Pacific-Sierra Research Fortran 90 Compiler'
  exe_extension = ''
  g2c = 'g2c'
  library_switch = '-o '
  obj_extension = '.o'
  object_switch = ' && function _mvfile { mv -v `basename $1` $1 ; } && _mvfile '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'
  suggested_f90_compiler = 'gnu95'
  version_pattern = '\\s*Pacific-Sierra Research vf90 (Personal|Professional)\\s+(?P<version>[^\\s]*)'

