# Please do not change this hardware control module.
# It provides support for the Charleston Rx1.

import _quisk as QS
import chas_rx1
import quisk_widgets
from quisk_hardware_model import Hardware as BaseHardware

class Hardware(BaseHardware):
  decimations = [1600,800,640,400,320,300,200,160]	# Charleston available decimation rates
  def __init__(self, app, conf):
    BaseHardware.__init__(self, app, conf)
    self.clock = 76800000.0
    self.index = 3
    chas_rx1.set_decimation(self.decimations[self.index])
#    self.rf_gain_labels = ('PGA 0dB', 'PGA 1dB', 'PGA 2.5dB', 'PGA 4dB',
#      'PGA 6dB', 'PGA 8.5dB', 'PGA 12dB')
  def open(self):
    return chas_rx1.open_samples()		# Return a config message
  def close(self):
    chas_rx1.close_samples()
  def OnButtonRfGain(self, event):
    btn = event.GetEventObject()
    n = btn.index
    chas_rx1.pga_gain_chas_rx1(n)
  def ChangeFrequency(self, tune, vfo, source='', band='', event=None):
    if vfo:
      chas_rx1.freq_chas_rx1(vfo)
    return tune, vfo
  def ChangeBand(self, band):
    # band is a string: "60", "40", "WWV", etc.
#    btn = self.application.BtnRfGain
    btn = chas_rx1.pga_gain_chas_rx1
#    btn = BottomWidgets.OnBtnPGA
#    if btn:
    if band in ('160', '80', '60', '40'):
#        btn.SetLabel('PGA 0dB', True)
        chas_rx1.pga_gain_chas_rx1(6)
    elif band in ('20',):
#        btn.SetLabel('PGA 2.5dB', True)
        chas_rx1.pga_gain_chas_rx1(6)
    else:
#        btn.SetLabel('PGA 4dB', True)
        chas_rx1.pga_gain_chas_rx1(6)
  def VarDecimGetChoices(self): # return text labels for the control
    l = [] # a list of sample rates
    for dec in self.decimations:
      l.append(str(int(float(self.clock) / dec / 1e3 + 0.5)))
    return l
  def VarDecimGetLabel(self): # return a text label for the control
    return "Sample rate ksps"
  def VarDecimGetIndex(self): # return the current index
    return self.index
  def VarDecimSet(self, index=None): # set decimation, return sample rate
    if index is not None:
      self.index = index
      chas_rx1.set_decimation(self.decimations[index])
    return int(float(self.clock) / self.decimations[self.index] + 0.5)

