/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakevideodeviceselectorcontrol.h"
#include "fakecameraflashcontrol.h"
#include "fakecameraservice.h"
#include "fakecamerazoomcontrol.h"
#include "fakevideorenderercontrol.h"
#include <QDebug>

FakeVideoDeviceSelectorControl::FakeVideoDeviceSelectorControl(FakeCameraService *service, QObject *parent)
    : QVideoDeviceSelectorControl(parent),
      m_service(service),
      m_currentCamera(0)
{
}

int FakeVideoDeviceSelectorControl::defaultDevice() const
{
    return 0;
}

int FakeVideoDeviceSelectorControl::deviceCount() const
{
    return 2;
}

QString FakeVideoDeviceSelectorControl::deviceDescription(int index) const
{
    switch (index) {
    case 0: return QString("Back camera");
    case 1: return QString("Front camera");
    default: return QString();
    }
}

QString FakeVideoDeviceSelectorControl::deviceName(int index) const
{
    switch (index) {
    case 0: return QString("Back");
    case 1: return QString("Front");
    default: return QString();
    }
}

int FakeVideoDeviceSelectorControl::selectedDevice() const
{
    return m_currentCamera;
}

void FakeVideoDeviceSelectorControl::setSelectedDevice(int index)
{
    if (index >= 0 && index < deviceCount() && index != m_currentCamera) {
        m_currentCamera = index;

        Q_EMIT devicesChanged();
        Q_EMIT selectedDeviceChanged(m_currentCamera);
        Q_EMIT selectedDeviceChanged(deviceName(m_currentCamera));

        m_service->fakeSensor().stopMove();
        m_service->fakeSensor().setSelectedCamera(index);
        m_service->zoomControl()->resetZoom();
        m_service->flashControl()->setFlashMode(QCameraExposure::FlashOff);
        m_service->videoOutputControl()->stopViewfinder();
        m_service->fakeSensor().startMove();
    }
}
