/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include <QAbstractItemModel>
#include <QFileInfo>
#include <QList>
#include <QSet>
#include <QStringList>

namespace QmlDesigner {
namespace Internal {

class AssetImportUpdateTreeItem;

class AssetImportUpdateTreeModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    AssetImportUpdateTreeModel(QObject *parent = nullptr);
    ~AssetImportUpdateTreeModel() override;

    Qt::ItemFlags flags(const QModelIndex &index) const override;
    QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const override;
    QModelIndex parent(const QModelIndex &child) const override;
    int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    int columnCount(const QModelIndex &parent = QModelIndex()) const override;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const override;
    bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole) override;

    void createItems(const QList<QFileInfo> &infos, const QSet<QString> &preselectedFiles);
    QStringList checkedFiles() const;

    static AssetImportUpdateTreeItem *treeItemAtIndex(const QModelIndex &idx);

public slots:
    void clear();

private:
    QModelIndex index(AssetImportUpdateTreeItem *item) const;
    QVariant data(const AssetImportUpdateTreeItem *row, int role) const;
    bool setCheckState(const QModelIndex &idx, Qt::CheckState checkState, bool firstCall = true);

    AssetImportUpdateTreeItem *m_rootItem;
    QList<AssetImportUpdateTreeItem *> m_fileItems;
};

} // namespace Internal
} // namespace QmlDesigner
