/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include <cplusplus/Token.h>

#include <QString>

QT_BEGIN_NAMESPACE
class QTextDocument;
QT_END_NAMESPACE

namespace TextEditor { class AssistInterface; }

namespace ClangCodeModel {
namespace Internal {

class ClangCompletionAssistInterface;

class ClangCompletionContextAnalyzer
{
public:
    ClangCompletionContextAnalyzer() = delete;
    ClangCompletionContextAnalyzer(const ClangCompletionAssistInterface *assistInterface,
                                   CPlusPlus::LanguageFeatures languageFeatures);
    ClangCompletionContextAnalyzer(QTextDocument *document, int position, bool isFunctionHint,
                                   CPlusPlus::LanguageFeatures languageFeatures);
    void analyze();

    enum CompletionAction {
        PassThroughToLibClang,
        PassThroughToLibClangAfterLeftParen,
        CompleteDoxygenKeyword,
        CompleteIncludePath,
        CompletePreprocessorDirective,
        CompleteSignal,
        CompleteSlot,
        CompleteNone
    };
    CompletionAction completionAction() const { return m_completionAction; }
    unsigned completionOperator() const { return m_completionOperator; }
    int positionForProposal() const { return m_positionForProposal; }
    int positionForClang() const { return m_positionForClang; }
    int functionNameStart() const { return m_functionNameStart; }
    int positionEndOfExpression() const { return m_positionEndOfExpression; }
    bool addSnippets() const { return m_addSnippets; }

private:
    int startOfFunctionCall(int endOfExpression) const;

    void setActionAndClangPosition(CompletionAction action,
                                   int position,
                                   int functionNameStart = -1);
    void setAction(CompletionAction action);

    bool handleNonFunctionCall(int position);
    void handleCommaInFunctionCall();
    void handleFunctionCall(int endOfOperator);

private:
    QTextDocument * const m_document;
    const int m_position;
    const bool m_isFunctionHint;
    const CPlusPlus::LanguageFeatures m_languageFeatures;

    // Results
    CompletionAction m_completionAction = PassThroughToLibClang;
    CPlusPlus::Kind m_completionOperator = CPlusPlus::T_EOF_SYMBOL;
    int m_positionForProposal = -1;
    int m_positionForClang = -1;
    int m_functionNameStart = -1;
    int m_positionEndOfExpression = -1;
    bool m_addSnippets = false;
};

} // namespace Internal
} // namespace ClangCodeModel
