#
# This script was written by Eli Kara <elik@beyondsecurity.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(12639);  
 script_bugtraq_id(10654, 10655);
 script_version ("$Revision: 7711 $");

 name = "MySQL Authentication bypass through a zero-length password";
 script_name(name);
 script_tag(name:"risk_factor", value:"None");
 
 desc = "It is possible to bypass password authentication for a database
 user using a crafted authentication packet with a zero-length password
 
Note: In order to use this script, the MySQL daemon has to allow connection from the
scanning IP address";
 script_description(desc);
 
 summary = "Log in to MySQL with a zero-length password";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2004 Beyond Security");
 
 family = "Remote file access";
 script_family(family);
 
 script_dependencie("find_service2.nasl");
 script_require_ports("Services/mysql", 3306);
 exit(0);
}

# tested by mysql_unpassworded.nasl
exit (0);
