# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:108 (zsh)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63950);
 script_cve_id("CVE-2009-1214", "CVE-2009-1215");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.9");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Mandrake Security Advisory MDVSA-2009:108 (zsh)";
 script_name(name);

 desc = "The remote host is missing an update to zsh
announced via advisory MDVSA-2009:108.

A stack-based buffer overflow was found in the zsh command
interpreter. An attacker could use this flaw to cause a denial of
service (zsh crash), when providing a specially-crafted string as
input to the zsh shell (CVE-2009-1214, CVE-2009-1215).

The updated packages have been patched to prevent this.

Affected: 2008.1, 2009.0, Corporate 3.0, Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:108

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:108 (zsh)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"zsh", rpm:"zsh~4.3.5~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zsh-doc", rpm:"zsh-doc~4.3.5~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zsh", rpm:"zsh~4.3.6~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zsh-doc", rpm:"zsh-doc~4.3.6~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zsh", rpm:"zsh~4.1.1~6.1.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zsh-doc", rpm:"zsh-doc~4.1.1~6.1.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zsh", rpm:"zsh~4.2.5~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zsh-doc", rpm:"zsh-doc~4.2.5~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
