###############################################################################
# OpenVAS Vulnerability Test
# $Id: barracuda_im_firewall_37248.nasl 7197 2010-04-01 09:20:01Z chandra $
#
# Barracuda IM Firewall 'smtp_test.cgi' Cross-Site Scripting Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100393);
 script_bugtraq_id(37248);
 script_version ("1.0-$Revision: 7197 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Barracuda IM Firewall 'smtp_test.cgi' Cross-Site Scripting Vulnerabilities");

desc = "Overview:
Barracuda IM Firewall is prone to multiple cross-site scripting
vulnerabilities because the application fails to properly sanitize user-
supplied input.

An attacker may leverage these issues to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site. This may help the attacker steal cookie-based authentication
credentials and launch other attacks.

Barracuda IM Firewall 620 Firmware v4.0.01.003 is vulnerable; other
versions may also be affected.

References:
http://www.securityfocus.com/bid/37248
http://www.barracudanetworks.com/ns/products/im_overview.php

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Barracuda IM Firewall version is 4.0.01.003");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("barracuda_im_firewall_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/barracuda_im_firewall")))exit(0);

if(!isnull(version) && version >!< "unknown") {

  if(version_is_equal(version: version, test_version: "4.0.01.003")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
