/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package xmlObjects;

import java.util.ArrayList;

/******
 * 
 * @author Mathias Korepkat
***/
/***
 *	This class contains informations about enumerations given by the gui_VTSetup.xml.
 *  You can set if one of the enums is required or not.
 */

public class EnumSelectionClass {
	private String id = new String();
	/****
	 * true if the user has to choice one, false if no choice is required. 
	 */
	private boolean oneRequired = true;
	private ArrayList<String> entry = new ArrayList<String>();
	
	
	/***
	 * initialization
	 * @param id String that represent a individual id
	 */
	public EnumSelectionClass(String id)
	{
		this.id = id;
	}
	
	/***
	 * initialization
	 * @param id String that represent a individual id
	 * @param oneRequired  true if one selection is needed otherwise false
	 */
	public EnumSelectionClass(String id,boolean oneRequired)
	{
		this.id = id;
		this.oneRequired = oneRequired;
	}
	
	/***
	 * returns all entries of this enumerations
	 * @return ArrayList of all 
	 */
	public ArrayList<String> getEntrys()
	{
		return this.entry;
	}
	
	/***
	 * returns the id
	 * @return String that represent an individual id of this enumeration
	 */
	public String getId()
	{
		return this.id;
	}
	
	/***
	 * set if one choose is needed or not 
	 * @param req true if one selection is needed otherwise false
	 */
	public void setRequired(boolean req)
	{
		this.oneRequired = req;
	}
	
	/***
	 * get if one selection is needed or not 
	 */
	public boolean isOneRequired()
	{
		return this.oneRequired;
	}
}
