/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "config.h"
#import "PlatformUtilities.h"
#import <WebKit/WebCache.h>

namespace TestWebKitAPI {

TEST(WebKit1, MemoryCacheAddImageToCache)
{
    CGColorSpaceRef rgb = CGColorSpaceCreateDeviceRGB();
    uint32_t pixel = 0;
    CGDataProviderRef provider = CGDataProviderCreateWithData(nullptr, &pixel, 4, nullptr);
    CGImageRef image = CGImageCreate(1, 1, 8, 32, 4, rgb, kCGImageAlphaFirst | kCGBitmapByteOrderDefault, provider, nullptr, false, kCGRenderingIntentDefault);
    NSURL *url = [NSURL URLWithString:@"about:blank"];
    EXPECT_TRUE([WebCache addImageToCache:image forURL:url]);
    EXPECT_EQ(image, [WebCache imageForURL:url]);
    // By design, removeImageFromCacheForURL doesn't necessarily remove the resource from the cache,
    // just makes it pruneable, so we can't really test remove.
    CGImageRelease(image);
    CGDataProviderRelease(provider);
    CGColorSpaceRelease(rgb);
}

} // namespace TestWebKitAPI
