/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTestSerialization.h"

#include "JSDOMBinding.h"
#include "JSDOMBindingCaller.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvert.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSTestException.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/ObjectConstructor.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTestSerializationPrototypeFunctionToJSON(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTestSerializationFirstStringAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestSerializationFirstStringAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestSerializationSecondLongAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestSerializationSecondLongAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestSerializationThirdUnserializableAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestSerializationThirdUnserializableAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestSerializationFourthUnrestrictedDoubleAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestSerializationFourthUnrestrictedDoubleAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestSerializationFifthLongAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestSerializationFifthLongAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestSerializationSixthTypedefAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestSerializationSixthTypedefAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestSerializationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestSerializationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTestSerializationPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTestSerializationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTestSerializationPrototype* ptr = new (NotNull, JSC::allocateCell<JSTestSerializationPrototype>(vm.heap)) JSTestSerializationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTestSerializationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

using JSTestSerializationConstructor = JSDOMConstructorNotConstructable<JSTestSerialization>;

template<> JSValue JSTestSerializationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTestSerializationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTestSerialization::prototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TestSerialization"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTestSerializationConstructor::s_info = { "TestSerialization", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestSerializationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTestSerializationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestSerializationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestSerializationConstructor) } },
    { "firstStringAttribute", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestSerializationFirstStringAttribute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestSerializationFirstStringAttribute) } },
    { "secondLongAttribute", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestSerializationSecondLongAttribute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestSerializationSecondLongAttribute) } },
    { "thirdUnserializableAttribute", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestSerializationThirdUnserializableAttribute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestSerializationThirdUnserializableAttribute) } },
    { "fourthUnrestrictedDoubleAttribute", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestSerializationFourthUnrestrictedDoubleAttribute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestSerializationFourthUnrestrictedDoubleAttribute) } },
    { "fifthLongAttribute", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestSerializationFifthLongAttribute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestSerializationFifthLongAttribute) } },
    { "sixthTypedefAttribute", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestSerializationSixthTypedefAttribute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestSerializationSixthTypedefAttribute) } },
    { "toJSON", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTestSerializationPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSTestSerializationPrototype::s_info = { "TestSerializationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestSerializationPrototype) };

void JSTestSerializationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTestSerializationPrototypeTableValues, *this);
}

const ClassInfo JSTestSerialization::s_info = { "TestSerialization", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestSerialization) };

JSTestSerialization::JSTestSerialization(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TestSerialization>&& impl)
    : JSDOMWrapper<TestSerialization>(structure, globalObject, WTFMove(impl))
{
}

void JSTestSerialization::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

}

JSObject* JSTestSerialization::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTestSerializationPrototype::create(vm, globalObject, JSTestSerializationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTestSerialization::prototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTestSerialization>(vm, globalObject);
}

void JSTestSerialization::destroy(JSC::JSCell* cell)
{
    JSTestSerialization* thisObject = static_cast<JSTestSerialization*>(cell);
    thisObject->JSTestSerialization::~JSTestSerialization();
}

template<> inline JSTestSerialization* BindingCaller<JSTestSerialization>::castForAttribute(ExecState& state, EncodedJSValue thisValue)
{
    return jsDynamicDowncast<JSTestSerialization*>(state.vm(), JSValue::decode(thisValue));
}

template<> inline JSTestSerialization* BindingCaller<JSTestSerialization>::castForOperation(ExecState& state)
{
    return jsDynamicDowncast<JSTestSerialization*>(state.vm(), state.thisValue());
}

static inline JSValue jsTestSerializationFirstStringAttributeGetter(ExecState&, JSTestSerialization&, ThrowScope& throwScope);

EncodedJSValue jsTestSerializationFirstStringAttribute(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestSerialization>::attribute<jsTestSerializationFirstStringAttributeGetter>(state, thisValue, "firstStringAttribute");
}

static inline JSValue jsTestSerializationFirstStringAttributeGetter(ExecState& state, JSTestSerialization& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(state, impl.firstStringAttribute());
    return result;
}

static inline JSValue jsTestSerializationSecondLongAttributeGetter(ExecState&, JSTestSerialization&, ThrowScope& throwScope);

EncodedJSValue jsTestSerializationSecondLongAttribute(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestSerialization>::attribute<jsTestSerializationSecondLongAttributeGetter>(state, thisValue, "secondLongAttribute");
}

static inline JSValue jsTestSerializationSecondLongAttributeGetter(ExecState& state, JSTestSerialization& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(impl.secondLongAttribute());
    return result;
}

static inline JSValue jsTestSerializationThirdUnserializableAttributeGetter(ExecState&, JSTestSerialization&, ThrowScope& throwScope);

EncodedJSValue jsTestSerializationThirdUnserializableAttribute(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestSerialization>::attribute<jsTestSerializationThirdUnserializableAttributeGetter>(state, thisValue, "thirdUnserializableAttribute");
}

static inline JSValue jsTestSerializationThirdUnserializableAttributeGetter(ExecState& state, JSTestSerialization& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TestException>>(state, *thisObject.globalObject(), impl.thirdUnserializableAttribute());
    return result;
}

static inline JSValue jsTestSerializationFourthUnrestrictedDoubleAttributeGetter(ExecState&, JSTestSerialization&, ThrowScope& throwScope);

EncodedJSValue jsTestSerializationFourthUnrestrictedDoubleAttribute(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestSerialization>::attribute<jsTestSerializationFourthUnrestrictedDoubleAttributeGetter>(state, thisValue, "fourthUnrestrictedDoubleAttribute");
}

static inline JSValue jsTestSerializationFourthUnrestrictedDoubleAttributeGetter(ExecState& state, JSTestSerialization& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(impl.fourthUnrestrictedDoubleAttribute());
    return result;
}

static inline JSValue jsTestSerializationFifthLongAttributeGetter(ExecState&, JSTestSerialization&, ThrowScope& throwScope);

EncodedJSValue jsTestSerializationFifthLongAttribute(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestSerialization>::attribute<jsTestSerializationFifthLongAttributeGetter>(state, thisValue, "fifthLongAttribute");
}

static inline JSValue jsTestSerializationFifthLongAttributeGetter(ExecState& state, JSTestSerialization& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(impl.fifthLongAttribute());
    return result;
}

static inline JSValue jsTestSerializationSixthTypedefAttributeGetter(ExecState&, JSTestSerialization&, ThrowScope& throwScope);

EncodedJSValue jsTestSerializationSixthTypedefAttribute(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestSerialization>::attribute<jsTestSerializationSixthTypedefAttributeGetter>(state, thisValue, "sixthTypedefAttribute");
}

static inline JSValue jsTestSerializationSixthTypedefAttributeGetter(ExecState& state, JSTestSerialization& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(impl.sixthTypedefAttribute());
    return result;
}

EncodedJSValue jsTestSerializationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = state->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    JSTestSerializationPrototype* domObject = jsDynamicDowncast<JSTestSerializationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!domObject))
        return throwVMTypeError(state, throwScope);
    return JSValue::encode(JSTestSerialization::getConstructor(state->vm(), domObject->globalObject()));
}

bool setJSTestSerializationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = state->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    JSValue value = JSValue::decode(encodedValue);
    JSTestSerializationPrototype* domObject = jsDynamicDowncast<JSTestSerializationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

static inline bool setJSTestSerializationFirstStringAttributeFunction(ExecState&, JSTestSerialization&, JSValue, ThrowScope&);

bool setJSTestSerializationFirstStringAttribute(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestSerialization>::setAttribute<setJSTestSerializationFirstStringAttributeFunction>(state, thisValue, encodedValue, "firstStringAttribute");
}

static inline bool setJSTestSerializationFirstStringAttributeFunction(ExecState& state, JSTestSerialization& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(state, value, StringConversionConfiguration::Normal);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setFirstStringAttribute(WTFMove(nativeValue));
    return true;
}


static inline bool setJSTestSerializationSecondLongAttributeFunction(ExecState&, JSTestSerialization&, JSValue, ThrowScope&);

bool setJSTestSerializationSecondLongAttribute(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestSerialization>::setAttribute<setJSTestSerializationSecondLongAttributeFunction>(state, thisValue, encodedValue, "secondLongAttribute");
}

static inline bool setJSTestSerializationSecondLongAttributeFunction(ExecState& state, JSTestSerialization& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(state, value, IntegerConversionConfiguration::Normal);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setSecondLongAttribute(WTFMove(nativeValue));
    return true;
}


static inline bool setJSTestSerializationThirdUnserializableAttributeFunction(ExecState&, JSTestSerialization&, JSValue, ThrowScope&);

bool setJSTestSerializationThirdUnserializableAttribute(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestSerialization>::setAttribute<setJSTestSerializationThirdUnserializableAttributeFunction>(state, thisValue, encodedValue, "thirdUnserializableAttribute");
}

static inline bool setJSTestSerializationThirdUnserializableAttributeFunction(ExecState& state, JSTestSerialization& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLInterface<TestException>>(state, value, [](JSC::ExecState& state, JSC::ThrowScope& scope) { throwAttributeTypeError(state, scope, "TestSerialization", "thirdUnserializableAttribute", "TestException"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setThirdUnserializableAttribute(*nativeValue);
    return true;
}


static inline bool setJSTestSerializationFourthUnrestrictedDoubleAttributeFunction(ExecState&, JSTestSerialization&, JSValue, ThrowScope&);

bool setJSTestSerializationFourthUnrestrictedDoubleAttribute(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestSerialization>::setAttribute<setJSTestSerializationFourthUnrestrictedDoubleAttributeFunction>(state, thisValue, encodedValue, "fourthUnrestrictedDoubleAttribute");
}

static inline bool setJSTestSerializationFourthUnrestrictedDoubleAttributeFunction(ExecState& state, JSTestSerialization& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(state, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setFourthUnrestrictedDoubleAttribute(WTFMove(nativeValue));
    return true;
}


static inline bool setJSTestSerializationFifthLongAttributeFunction(ExecState&, JSTestSerialization&, JSValue, ThrowScope&);

bool setJSTestSerializationFifthLongAttribute(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestSerialization>::setAttribute<setJSTestSerializationFifthLongAttributeFunction>(state, thisValue, encodedValue, "fifthLongAttribute");
}

static inline bool setJSTestSerializationFifthLongAttributeFunction(ExecState& state, JSTestSerialization& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(state, value, IntegerConversionConfiguration::Normal);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setFifthLongAttribute(WTFMove(nativeValue));
    return true;
}


static inline bool setJSTestSerializationSixthTypedefAttributeFunction(ExecState&, JSTestSerialization&, JSValue, ThrowScope&);

bool setJSTestSerializationSixthTypedefAttribute(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestSerialization>::setAttribute<setJSTestSerializationSixthTypedefAttributeFunction>(state, thisValue, encodedValue, "sixthTypedefAttribute");
}

static inline bool setJSTestSerializationSixthTypedefAttributeFunction(ExecState& state, JSTestSerialization& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(state, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setSixthTypedefAttribute(WTFMove(nativeValue));
    return true;
}


JSValue JSTestSerialization::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTestSerializationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC::JSObject* JSTestSerialization::serialize(ExecState* state, JSTestSerialization* thisObject, ThrowScope& throwScope)
{
    auto& vm = state->vm();
    auto* result = constructEmptyObject(state);

    auto firstStringAttributeValue = jsTestSerializationFirstStringAttributeGetter(*state, *thisObject, throwScope);
    ASSERT(!throwScope.exception());
    result->putDirect(vm, Identifier::fromString(&vm, "firstStringAttribute"), firstStringAttributeValue);

    auto secondLongAttributeValue = jsTestSerializationSecondLongAttributeGetter(*state, *thisObject, throwScope);
    ASSERT(!throwScope.exception());
    result->putDirect(vm, Identifier::fromString(&vm, "secondLongAttribute"), secondLongAttributeValue);

    auto fourthUnrestrictedDoubleAttributeValue = jsTestSerializationFourthUnrestrictedDoubleAttributeGetter(*state, *thisObject, throwScope);
    ASSERT(!throwScope.exception());
    result->putDirect(vm, Identifier::fromString(&vm, "fourthUnrestrictedDoubleAttribute"), fourthUnrestrictedDoubleAttributeValue);

    auto fifthLongAttributeValue = jsTestSerializationFifthLongAttributeGetter(*state, *thisObject, throwScope);
    ASSERT(!throwScope.exception());
    result->putDirect(vm, Identifier::fromString(&vm, "fifthLongAttribute"), fifthLongAttributeValue);

    auto sixthTypedefAttributeValue = jsTestSerializationSixthTypedefAttributeGetter(*state, *thisObject, throwScope);
    ASSERT(!throwScope.exception());
    result->putDirect(vm, Identifier::fromString(&vm, "sixthTypedefAttribute"), sixthTypedefAttributeValue);

    return result;
}

static inline EncodedJSValue jsTestSerializationPrototypeFunctionToJSONCaller(ExecState* state, JSTestSerialization* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSTestSerialization::serialize(state, thisObject, throwScope));
}

EncodedJSValue JSC_HOST_CALL jsTestSerializationPrototypeFunctionToJSON(ExecState* state)
{
    return BindingCaller<JSTestSerialization>::callOperation<jsTestSerializationPrototypeFunctionToJSONCaller>(state, "toJSON");
}

bool JSTestSerializationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTestSerializationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTestSerialization = static_cast<JSTestSerialization*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTestSerialization->wrapped(), jsTestSerialization);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TestSerialization@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17TestSerializationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Ref<TestSerialization>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl.ptr()));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7TestSerialization@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17TestSerializationE[2];
#if COMPILER(CLANG)
    // If this fails TestSerialization does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(__is_polymorphic(TestSerialization), "TestSerialization is not polymorphic");
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // TestSerialization has subclasses. If TestSerialization has subclasses that get passed
    // to toJS() we currently require TestSerialization you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<TestSerialization>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::ExecState* state, JSDOMGlobalObject* globalObject, TestSerialization& impl)
{
    return wrap(state, globalObject, impl);
}

TestSerialization* JSTestSerialization::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicDowncast<JSTestSerialization*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
