
/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _COLOR_WRAP_P_H_
#define _COLOR_WRAP_P_H_

#include <GTLCore/Color.h>
#include "GTLCore/wrappers/StructWrap.h"
#include "GTLFragment/Export.h"
#include <GTLCore/StdTypes.h>

namespace GTLCore {
  class AbstractColorConverter;
}

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// its llvm declaration must be changed too in         //
// Wrapper::createColorType !                          //
//---------------------- WARNING ----------------------//
struct ColorWrap {
  STRUCT_HEADER
  float red, green, blue, opacity;
  /**
   * Enum used to access an element
   */
  enum ColorIndexes {
    INDEX_RED = 0,
    INDEX_GREEN = 1,
    INDEX_BLUE = 2,
    INDEX_OPACITY = 3
  };
  /**
   * Position of an element in the structure memory
   */
  enum ColorPoses {
    POS_RED = STRUCT_FIRST_ELEMENT + INDEX_RED,
    POS_GREEN = STRUCT_FIRST_ELEMENT + INDEX_GREEN,
    POS_BLUE = STRUCT_FIRST_ELEMENT + INDEX_BLUE,
    POS_OPACITY = STRUCT_FIRST_ELEMENT + INDEX_OPACITY
  };
};

GTLFRAGMENT_EXPORT void wrapColor(ColorWrap& color, float red, float green, float blue, float opacity);
GTLFRAGMENT_EXPORT GTLCore::Color colorWrapToGTLCoreColor(const ColorWrap& wrap);

extern "C" {
  GTLFRAGMENT_EXPORT void wrapConvertPixelToColor(const GTLCore::AbstractColorConverter* _acc, const float* _pixel, GTLCore::RgbaF* _rgba, gtl_int32 _nbChannels);
  GTLFRAGMENT_EXPORT void wrapConvertColorToPixel(const GTLCore::AbstractColorConverter* _acc, const GTLCore::RgbaF* _rgba, float* _pixel, gtl_int32 _nbChannels);
}

#endif
