/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "../ASTBackend/GenerationVisitor.h"
#include "../ASTBackend/ExpressionResult.h"
#include "../AST/Annotation.h"

#define G_AST_VALUE result.scast< ASTBackend::ExpressionResult >( )->value()
#define M_AST_VALUE(_V_) new ASTBackend::ExpressionResult(_V_)
#define AST_CHECK_EQUAL( _R_ ) GTLTEST_CHECK_EQUAL( G_AST_VALUE, _R_ )
#define AST_TEST_BINARY( _NAME_, _VAL1_, _VAL2, _RESULT_ ) \
      result = visitor._NAME_( M_AST_VALUE(_VAL1_), M_AST_VALUE(_VAL2), annotation ); \
      AST_CHECK_EQUAL( _RESULT_ );

#define AST_TEST_UNARY( _NAME_, _VAL_, _RESULT_ ) \
      result = visitor._NAME_( M_AST_VALUE(_VAL_), annotation); \
      AST_CHECK_EQUAL( _RESULT_ );

class TestASTBackendBinaryExpression : public GTLTest::Case {
  public:
    TestASTBackendBinaryExpression() : GTLTest::Case("ASTBackendBinaryExpression")
    {
    }
    virtual void runTest()
    {
      ASTBackend::GenerationVisitor visitor;
      GTLCore::AST::Annotation annotation;
      GTLCore::AST::ExpressionResultSP result = 0;
      AST_TEST_BINARY(generateAndExpresion, true, false, false);
      AST_TEST_BINARY(generateAndExpresion, true, true, true);
      AST_TEST_BINARY(generateAndExpresion, false, false, false);
      AST_TEST_BINARY(generateOrExpresion, true, false, true);
      AST_TEST_BINARY(generateOrExpresion, true, true, true);
      AST_TEST_BINARY(generateOrExpresion, false, false, false);
      AST_TEST_BINARY(generateBitOrExpresion, 0x11100, 0x11010, 0x11110);
      AST_TEST_BINARY(generateBitXorExpresion, 0x11100, 0x11010, 0x00110);
      AST_TEST_BINARY(generateBitAndExpresion, 0x11100, 0x11010, 0x11000);
      AST_TEST_BINARY(generateEqualExpresion, 10, 10, true);
      AST_TEST_BINARY(generateEqualExpresion, 10, 11, false);
      AST_TEST_BINARY(generateEqualExpresion, 10.0f, 10.0f, true);
      AST_TEST_BINARY(generateEqualExpresion, 10.0f, 12.0f, false);
      AST_TEST_BINARY(generateEqualExpresion, 10.0f, 10, true);
      AST_TEST_BINARY(generateDifferentExpresion, 10, 10, false);
      AST_TEST_BINARY(generateDifferentExpresion, 10, 11, true);
      AST_TEST_BINARY(generateDifferentExpresion, 10.0f, 10.0f, false);
      AST_TEST_BINARY(generateDifferentExpresion, 10.0f, 12.0f, true);
      AST_TEST_BINARY(generateDifferentExpresion, 10.0f, 10, false);
      AST_TEST_BINARY(generateInferiorExpresion, 11, 10, false);
      AST_TEST_BINARY(generateInferiorExpresion, 10, 10, false);
      AST_TEST_BINARY(generateInferiorExpresion, 10, 11, true);
      AST_TEST_BINARY(generateInferiorExpresion, 10.0f, 10.0f, false);
      AST_TEST_BINARY(generateInferiorExpresion, 10, 10.01f, true);
      AST_TEST_BINARY(generateInferiorEqualExpresion, 11, 10, false);
      AST_TEST_BINARY(generateInferiorEqualExpresion, 10, 10, true);
      AST_TEST_BINARY(generateInferiorEqualExpresion, 10, 11, true);
      AST_TEST_BINARY(generateInferiorEqualExpresion, 10.0f, 10.0f, true);
      AST_TEST_BINARY(generateInferiorEqualExpresion, 10, 10.01f, true);
      AST_TEST_BINARY(generateSupperiorExpresion, 11, 10, true);
      AST_TEST_BINARY(generateSupperiorExpresion, 10, 10, false);
      AST_TEST_BINARY(generateSupperiorExpresion, 10, 11, false);
      AST_TEST_BINARY(generateSupperiorExpresion, 10.0f, 10.0f, false);
      AST_TEST_BINARY(generateSupperiorExpresion, 10, 10.01f, false);
      AST_TEST_BINARY(generateSupperiorEqualExpresion, 11, 10, true);
      AST_TEST_BINARY(generateSupperiorEqualExpresion, 10, 10, true);
      AST_TEST_BINARY(generateSupperiorEqualExpresion, 10, 11, false);
      AST_TEST_BINARY(generateSupperiorEqualExpresion, 10.0f, 10.0f, true);
      AST_TEST_BINARY(generateSupperiorEqualExpresion, 10, 10.01f, false);
      AST_TEST_BINARY(generateRightShiftExpresion, 10, 2, 2);
      AST_TEST_BINARY(generateLeftShiftExpresion, 2, 2, 8);
      AST_TEST_BINARY(generateAdditionExpresion, 2, 4, 6);
      AST_TEST_BINARY(generateSubtractionExpresion, 2, 3, -1);
      AST_TEST_BINARY(generateDivisionExpresion, 2, 4, 0);
      AST_TEST_BINARY(generateDivisionExpresion, 11, 2, 5);
      AST_TEST_BINARY(generateDivisionExpresion, 11.0f, 2, 5.5f);
      AST_TEST_BINARY(generateMultiplicationExpresion, 2, 4, 8);
      AST_TEST_BINARY(generateModuloExpresion, 10, 2, 0);
      AST_TEST_BINARY(generateModuloExpresion, 11, 2, 1);
      
      AST_TEST_UNARY(generateTildExpression, 0x11010, -0x11011);
      AST_TEST_UNARY(generateMinusExpression, 10, -10);
      AST_TEST_UNARY(generateMinusExpression, -10.2f, 10.2f);
      AST_TEST_UNARY(generateNotExpression, true, false);
    }
};


class TestASTBackend : public GTLTest::Suite {
  public:
    TestASTBackend() : GTLTest::Suite("ASTBackend")
    {
      addCase( new TestASTBackendBinaryExpression);
    }
};


