#!/bin/sh -e

# Extract and repack upstream source (zip in upstream zip package)
# $2 = version
# $3 = file
DIR=olap4j-$2
TAR=olap4j_$2.orig.tar.gz

# Repack upstream source to tar.gz
mkdir $DIR
(
cd $DIR
unzip -j ../$3 olap4j-*/olap4j-*-src.zip
unzip -d . olap4j-*-src.zip
mv olap4j-*/* .
rm olap4j-*-src.zip
)
GZIP=--best tar czf $TAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR
