/*
 * $Id: RESTTestCase.java 11179 2008-03-05 13:46:23Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.http.components;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class RESTTestCase extends FunctionalTestCase
{
    
    protected String getConfigResources()
    {
        return "rest-functional-test.xml";
    }
    
    public void testRest1ParamPost() throws Exception
    {
        MuleClient client = new MuleClient();
        MuleMessage reply  = client.send("vm://in1", new DefaultMuleMessage("IBM"));
        
        assertNotNull(reply);
        assertNotNull(reply.getPayloadAsString());
        assertTrue(reply.getPayloadAsString().indexOf("Symbol&gt;IBM&lt;") > -1);
    }
    
    public void testRest2ParamsPost() throws Exception
    {
        MuleClient client = new MuleClient();
        MuleMessage reply  = client.send("vm://in2", new DefaultMuleMessage(new Object[]{"MTL","MTL"}));
        
        assertNotNull(reply.getPayloadAsString());
        assertTrue(reply.getPayloadAsString().indexOf(">1</double>") > -1);
    }
    
    public void testRest1ParamGet() throws Exception
    {
        MuleClient client = new MuleClient();
        MuleMessage reply  = client.send("vm://in3", new DefaultMuleMessage(new Object[]{"IBM"}));
        
        assertNotNull(reply);
        assertNotNull(reply.getPayloadAsString());
        assertTrue(reply.getPayloadAsString().indexOf("Symbol&gt;IBM&lt;") > -1);
    }
    
    public void testRest2ParamsGet() throws Exception
    {
        MuleClient client = new MuleClient();
        MuleMessage reply  = client.send("vm://in4", new DefaultMuleMessage(new Object[]{"MTL","MTL"}));
        
        assertNotNull(reply.getPayloadAsString());
        assertTrue(reply.getPayloadAsString().indexOf(">1</double>") > -1);
    }

}


