/* init.c main program initalization 

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "ftpd.h"

/* Initalializes the program, and reads configuration */

void ftpd_setnogroups(void)
{
	setgroups(0, NULL);
}

void ftpd_preinit(void)
{
	config = NULL;
}

void ftpd_init(char *filename, int verbose) 
{
	int result = TRUE;
	char *scratchfile;
	
	ftpd_preinit();

	if (verbose)
	{
		printf("Starting "PROGNAME" server. (Version "VERSTR")\n");
		printf("Copyright (C) 1999,2000 Beau Kuiper\n");
		printf("License under GPL. See the http://www.fsf.org for more info.\n\n");

		printf("LOADING CONFIG FILE: %s\n", filename);
	}
	 
 	config = ftpd_loadconfig(filename, FALSE, umask(0));
	if (config)
		result = ftpd_checkconfig(config);
	if ((!config) || (!result))
		ERRORMSGFATAL("Errors loading config file, cannot continue!");
	log_setcontext(config->logout, config->defaults->loglevel);

	if (verbose)
	{
		if (config->rootmode)
			printf("Running as root, using full capibilities.\n");
		else
			printf("Running as normal user, change uid not possible.\n");
	}

	result = getsectionid(config->configfile, "main");
	loadstrfromconfig(config->configfile, result, "scratchfile", 
			  &scratchfile, SCRATCHFILE);
	if (scratchfile[0] != '/')
		ERRORMSGFATAL("Scratchfile is not a valid absolute filename");

	shinfo_init(scratchfile);
	
	ftpd_setnogroups();
}
