/*
 * MSPBLS_RAM_BSL.00.05.04.34
 *
 * An array holding the bytes to be programmed into device RAM for full USB BSL cabability
 *
 * Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include "loadbsl_fw.h"

/* program start addr 0x2504
 * first mem addr 0x2500
 */

static const uint8_t RAM_BSL_00_05_04_34[] = {
	0x00, 0x05, 0x04, 0x34, 0x31, 0x40, 0x90, 0x33,
	0xB0, 0x13, 0x5E, 0x2E, 0x0C, 0x93, 0x00, 0x24,
	0xB0, 0x13, 0xF4, 0x2D, 0xFF, 0x3F, 0x12, 0x01,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x08, 0x47, 0x20,
	0x00, 0x02, 0x04, 0x01, 0x00, 0x00, 0x00, 0x01,
	0x06, 0x00, 0xFF, 0x09, 0x01, 0xA1, 0x01, 0x85,
	0x3F, 0x95, 0x3F, 0x75, 0x08, 0x25, 0x01, 0x15,
	0x01, 0x09, 0x01, 0x81, 0x02, 0x85, 0x3F, 0x95,
	0x3F, 0x75, 0x08, 0x25, 0x01, 0x15, 0x01, 0x09,
	0x01, 0x91, 0x02, 0xC0, 0x09, 0x02, 0x29, 0x00,
	0x01, 0x01, 0x00, 0x80, 0x32, 0x09, 0x04, 0x00,
	0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x09, 0x21,
	0x01, 0x01, 0x00, 0x01, 0x22, 0x24, 0x00, 0x07,
	0x05, 0x81, 0x03, 0x40, 0x00, 0x01, 0x07, 0x05,
	0x01, 0x03, 0x40, 0x00, 0x01, 0x57, 0xF2, 0xD2,
	0x20, 0x09, 0xF2, 0xD2, 0x22, 0x09, 0x10, 0x01,
	0x5E, 0x42, 0x02, 0x24, 0x7E, 0x93, 0x25, 0x24,
	0x7E, 0x90, 0x09, 0x00, 0x04, 0x28, 0x7D, 0x42,
	0x7E, 0x82, 0x5F, 0x43, 0x0C, 0x3C, 0x7E, 0x92,
	0x02, 0x2C, 0x4D, 0x4E, 0x06, 0x3C, 0x7D, 0x42,
	0xD2, 0x93, 0x0E, 0x24, 0x02, 0x20, 0x4E, 0x43,
	0xF4, 0x3F, 0x7E, 0x43, 0x4F, 0x43, 0xC2, 0x4F,
	0x10, 0x24, 0xC2, 0x4E, 0x02, 0x24, 0x4F, 0x43,
	0x07, 0x3C, 0x1E, 0x42, 0x06, 0x24, 0xEF, 0x4E,
	0x78, 0x23, 0x92, 0x53, 0x06, 0x24, 0x5F, 0x53,
	0x4F, 0x9D, 0xF7, 0x2B, 0xC2, 0x4D, 0x21, 0x09,
	0x10, 0x01, 0xC2, 0x43, 0x10, 0x24, 0x10, 0x01,
	0x82, 0x4C, 0x06, 0x24, 0x5E, 0x42, 0x86, 0x23,
	0xC2, 0x9E, 0x02, 0x24, 0x04, 0x28, 0xC2, 0x4E,
	0x02, 0x24, 0x4E, 0x43, 0x01, 0x3C, 0x5E, 0x43,
	0xC2, 0x4E, 0x0E, 0x24, 0x80, 0x00, 0x80, 0x25,
	0xF2, 0xB0, 0x0F, 0x00, 0x84, 0x23, 0x14, 0x20,
	0xC2, 0x93, 0x84, 0x23, 0x03, 0x34, 0x5E, 0x42,
	0x20, 0x09, 0x02, 0x3C, 0x5E, 0x42, 0x22, 0x09,
	0x7E, 0xF2, 0xC2, 0x4E, 0x60, 0x24, 0x5E, 0x42,
	0x60, 0x24, 0x42, 0x19, 0x4E, 0x10, 0xC2, 0x4E,
	0x60, 0x24, 0xB0, 0x13, 0xC4, 0x27, 0x09, 0x3C,
	0xC2, 0x93, 0x84, 0x23, 0x03, 0x34, 0x5E, 0x42,
	0xC8, 0x23, 0xEE, 0x3F, 0x5E, 0x42, 0x88, 0x23,
	0xEB, 0x3F, 0x3C, 0x40, 0x60, 0x24, 0x80, 0x00,
	0xD8, 0x25, 0xF2, 0x43, 0x02, 0x24, 0xC2, 0x43,
	0x10, 0x24, 0xC2, 0x43, 0x21, 0x09, 0x10, 0x01,
	0xC2, 0x93, 0x82, 0x23, 0x12, 0x20, 0x5E, 0x42,
	0x84, 0x23, 0x7E, 0xF0, 0x0F, 0x00, 0x02, 0x20,
	0x80, 0x00, 0x42, 0x26, 0x5E, 0x93, 0x0B, 0x20,
	0xC2, 0x93, 0x84, 0x23, 0x03, 0x34, 0xF2, 0xD2,
	0xC8, 0x23, 0xF6, 0x3F, 0xF2, 0xD2, 0x88, 0x23,
	0xF3, 0x3F, 0xB0, 0x13, 0x76, 0x25, 0x10, 0x01,
	0xC2, 0x93, 0x80, 0x23, 0x04, 0x34, 0x1F, 0x43,
	0xD2, 0xD3, 0x3C, 0x09, 0x03, 0x3C, 0x0F, 0x43,
	0xD2, 0xC3, 0x3C, 0x09, 0x5E, 0x42, 0x80, 0x23,
	0x7E, 0xB0, 0x60, 0x00, 0x90, 0x20, 0x5D, 0x42,
	0x81, 0x23, 0x4D, 0x83, 0x81, 0x24, 0x5D, 0x83,
	0x6B, 0x24, 0x6D, 0x83, 0x67, 0x24, 0x6D, 0x83,
	0x45, 0x24, 0x5D, 0x83, 0x09, 0x24, 0x6D, 0x83,
	0x52, 0x24, 0x5D, 0x83, 0x46, 0x24, 0x5D, 0x83,
	0x33, 0x24, 0x5D, 0x83, 0x54, 0x24, 0x7B, 0x3C,
	0x0F, 0x93, 0x79, 0x24, 0x5E, 0x42, 0x83, 0x23,
	0x5E, 0x83, 0x08, 0x24, 0x5E, 0x83, 0x0F, 0x24,
	0x7E, 0x80, 0x1F, 0x00, 0x1C, 0x24, 0x5E, 0x83,
	0x13, 0x24, 0x6D, 0x3C, 0xC2, 0x43, 0x23, 0x09,
	0xF2, 0x40, 0x12, 0x00, 0x02, 0x24, 0x3C, 0x40,
	0x16, 0x25, 0x80, 0x00, 0xD8, 0x25, 0xC2, 0x43,
	0x23, 0x09, 0xF2, 0x40, 0x29, 0x00, 0x02, 0x24,
	0x3C, 0x40, 0x4C, 0x25, 0x80, 0x00, 0xD8, 0x25,
	0xF2, 0x40, 0x24, 0x00, 0x02, 0x24, 0x3C, 0x40,
	0x28, 0x25, 0x80, 0x00, 0xD8, 0x25, 0xC2, 0x43,
	0x23, 0x09, 0xF2, 0x40, 0x09, 0x00, 0x02, 0x24,
	0x3C, 0x40, 0x5E, 0x25, 0x80, 0x00, 0xD8, 0x25,
	0x0F, 0x93, 0x49, 0x24, 0xB0, 0x13, 0xC4, 0x27,
	0xC2, 0x43, 0x60, 0x24, 0xD2, 0x42, 0x01, 0x24,
	0x61, 0x24, 0x3B, 0x3C, 0xB0, 0x13, 0xCE, 0x27,
	0xD2, 0x42, 0x82, 0x23, 0x3F, 0x09, 0x80, 0x00,
	0x42, 0x26, 0xB0, 0x13, 0xCE, 0x27, 0xD2, 0x42,
	0x82, 0x23, 0x00, 0x24, 0xB0, 0x13, 0x42, 0x26,
	0xD2, 0x43, 0x12, 0x24, 0x10, 0x01, 0xC2, 0x43,
	0x23, 0x09, 0xD2, 0x43, 0x02, 0x24, 0x3C, 0x40,
	0x00, 0x24, 0x80, 0x00, 0xD8, 0x25, 0xB0, 0x13,
	0xCE, 0x27, 0xD2, 0x42, 0x84, 0x23, 0x01, 0x24,
	0x80, 0x00, 0x42, 0x26, 0x80, 0x00, 0x50, 0x26,
	0x5E, 0x42, 0x84, 0x23, 0x7E, 0xF0, 0x0F, 0x00,
	0x02, 0x20, 0x80, 0x00, 0x42, 0x26, 0x5E, 0x93,
	0x18, 0x20, 0xC2, 0x93, 0x84, 0x23, 0x04, 0x34,
	0xF2, 0xF0, 0xD7, 0x00, 0xC8, 0x23, 0xF5, 0x3F,
	0xF2, 0xF0, 0xD7, 0x00, 0x88, 0x23, 0xF1, 0x3F,
	0x7E, 0x90, 0x80, 0x00, 0x03, 0x20, 0xB0, 0x13,
	0xC4, 0x27, 0x43, 0x3F, 0x7E, 0x90, 0x82, 0x00,
	0x02, 0x20, 0x80, 0x00, 0xF8, 0x25, 0xB0, 0x13,
	0x76, 0x25, 0x10, 0x01, 0xC2, 0x43, 0x23, 0x09,
	0xE2, 0x43, 0x02, 0x24, 0x10, 0x01, 0xD5, 0x3E,
	0x1B, 0x15, 0x1F, 0x42, 0x5A, 0x24, 0x5B, 0x4F,
	0x03, 0x00, 0x5E, 0x4F, 0x01, 0x00, 0x5C, 0x4F,
	0x02, 0x00, 0x8C, 0x10, 0x0C, 0xDE, 0x0D, 0x4B,
	0x0E, 0x4F, 0x2E, 0x52, 0x6A, 0x4F, 0x7A, 0x80,
	0x10, 0x00, 0x29, 0x24, 0x5A, 0x83, 0x14, 0x24,
	0x5A, 0x83, 0x2A, 0x24, 0x5A, 0x83, 0x2E, 0x24,
	0x6A, 0x83, 0x23, 0x24, 0x5A, 0x83, 0x3A, 0x24,
	0x5A, 0x83, 0x15, 0x24, 0x5A, 0x83, 0x3B, 0x24,
	0x5A, 0x83, 0x3E, 0x24, 0x6A, 0x83, 0x41, 0x20,
	0x5F, 0x43, 0xB0, 0x13, 0xE2, 0x2B, 0x41, 0x3C,
	0x1F, 0x53, 0x0C, 0x4F, 0xB0, 0x13, 0x38, 0x2C,
	0x4C, 0x93, 0x02, 0x20, 0x4C, 0x43, 0x37, 0x3C,
	0x7C, 0x40, 0x05, 0x00, 0x34, 0x3C, 0xB0, 0x13,
	0x66, 0x2E, 0x03, 0x20, 0xB0, 0x13, 0x6E, 0x2E,
	0xF5, 0x3F, 0x6C, 0x42, 0x2C, 0x3C, 0x4F, 0x43,
	0xE8, 0x3F, 0xB0, 0x13, 0xD4, 0x2D, 0x27, 0x3C,
	0x0E, 0x4C, 0x0F, 0x4B, 0x4C, 0x43, 0xB0, 0x13,
	0xD4, 0x2C, 0x21, 0x3C, 0xB0, 0x13, 0x66, 0x2E,
	0xF0, 0x23, 0x4C, 0x43, 0x1F, 0x42, 0x58, 0x24,
	0x3F, 0x50, 0x40, 0x00, 0x1B, 0x42, 0x44, 0x01,
	0x3B, 0xF0, 0x10, 0x00, 0x0F, 0x5B, 0x82, 0x4F,
	0x44, 0x01, 0x11, 0x3C, 0xB0, 0x13, 0x3C, 0x2E,
	0xB0, 0x13, 0x12, 0x2B, 0x0E, 0x3C, 0xB0, 0x13,
	0x3C, 0x2E, 0xB0, 0x13, 0x66, 0x29, 0x09, 0x3C,
	0x2E, 0x42, 0x3C, 0x40, 0x00, 0x25, 0x0D, 0x43,
	0xF8, 0x3F, 0x7C, 0x40, 0x07, 0x00, 0xB0, 0x13,
	0x12, 0x2E, 0x1A, 0x17, 0x10, 0x01, 0xE2, 0xB2,
	0x3E, 0x09, 0x14, 0x28, 0xF2, 0x40, 0x80, 0x00,
	0x23, 0x09, 0x03, 0x3C, 0xF2, 0xF0, 0xFA, 0x00,
	0x3E, 0x09, 0xC2, 0x43, 0x10, 0x24, 0xC2, 0x43,
	0x60, 0x24, 0xC2, 0x43, 0x61, 0x24, 0xB0, 0x13,
	0x80, 0x26, 0xD2, 0xB3, 0x3E, 0x09, 0xF2, 0x2F,
	0xE2, 0xC2, 0x3E, 0x09, 0x1F, 0x42, 0x32, 0x09,
	0x7F, 0x90, 0x0A, 0x00, 0x0C, 0x20, 0xB0, 0x13,
	0x4A, 0x2E, 0xB0, 0x13, 0x86, 0x2C, 0xB0, 0x13,
	0x08, 0x2A, 0xB2, 0xF0, 0xF9, 0xFF, 0x08, 0x09,
	0xA2, 0xD3, 0x02, 0x09, 0x10, 0x01, 0x7F, 0x90,
	0x0C, 0x00, 0x06, 0x20, 0xB0, 0x13, 0x4A, 0x2E,
	0xB2, 0x40, 0x04, 0xA5, 0x20, 0x01, 0x10, 0x01,
	0x7F, 0x90, 0x12, 0x00, 0x0A, 0x20, 0xC2, 0x43,
	0x23, 0x09, 0xD2, 0x93, 0x10, 0x24, 0x02, 0x20,
	0x80, 0x00, 0x80, 0x25, 0xF2, 0xD2, 0x20, 0x09,
	0x10, 0x01, 0x7F, 0x90, 0x16, 0x00, 0x02, 0x20,
	0x80, 0x00, 0x08, 0x2A, 0x7F, 0x90, 0x18, 0x00,
	0x0C, 0x20, 0xD2, 0x43, 0x11, 0x24, 0xF2, 0xC0,
	0x40, 0x00, 0x3E, 0x09, 0xB2, 0x40, 0x80, 0x00,
	0x10, 0x09, 0xF2, 0x40, 0x20, 0x00, 0x3D, 0x09,
	0x10, 0x01, 0x7F, 0x90, 0x1A, 0x00, 0x0A, 0x20,
	0xB0, 0x13, 0x86, 0x2C, 0xF2, 0xF0, 0x9F, 0x00,
	0x3E, 0x09, 0xF2, 0x40, 0xC0, 0x00, 0x3D, 0x09,
	0xC2, 0x43, 0x11, 0x24, 0x10, 0x01, 0x7B, 0x15,
	0x0A, 0x4C, 0x0B, 0x4D, 0x0F, 0x4E, 0x3F, 0xE3,
	0x0F, 0x5F, 0x0F, 0x7F, 0x08, 0x4C, 0x09, 0x4D,
	0x08, 0x5E, 0x09, 0x6F, 0x47, 0x43, 0x0B, 0x3C,
	0x1F, 0x42, 0x5C, 0x24, 0xFF, 0x40, 0x3A, 0x00,
	0x00, 0x00, 0x0C, 0x46, 0x1C, 0x53, 0xB0, 0x13,
	0x2A, 0x2E, 0x0A, 0x56, 0x0B, 0x63, 0x0B, 0x99,
	0x03, 0x28, 0x34, 0x20, 0x0A, 0x98, 0x32, 0x2C,
	0x47, 0x93, 0x30, 0x20, 0x0E, 0x48, 0x0F, 0x49,
	0x0E, 0x8A, 0x0F, 0x7B, 0x03, 0x20, 0x3E, 0x90,
	0x3E, 0x00, 0x03, 0x28, 0x36, 0x40, 0x3D, 0x00,
	0x02, 0x3C, 0x06, 0x48, 0x06, 0x8A, 0x14, 0x42,
	0x5C, 0x24, 0x14, 0x53, 0x0E, 0x46, 0x0F, 0x46,
	0x3F, 0xE3, 0x0F, 0x5F, 0x0F, 0x7F, 0x0E, 0x5A,
	0x0F, 0x6B, 0x09, 0x3C, 0x1F, 0x15, 0x0D, 0x16,
	0x6C, 0x4D, 0x0D, 0x4E, 0x0D, 0x8A, 0x05, 0x44,
	0x05, 0x5D, 0xC5, 0x4C, 0x00, 0x00, 0x3E, 0x53,
	0x3F, 0x63, 0x0F, 0x9B, 0xC9, 0x2B, 0x02, 0x20,
	0x0E, 0x9A, 0xC6, 0x2B, 0xB0, 0x13, 0x66, 0x2E,
	0xED, 0x27, 0x67, 0x42, 0x6C, 0x42, 0xB0, 0x13,
	0x12, 0x2E, 0xC7, 0x3F, 0x74, 0x17, 0x10, 0x01,
	0xF2, 0x40, 0x10, 0x00, 0x3C, 0x09, 0xC2, 0x43,
	0x12, 0x24, 0xC2, 0x43, 0x11, 0x24, 0xC2, 0x43,
	0x00, 0x24, 0xC2, 0x43, 0x01, 0x24, 0xC2, 0x43,
	0x3C, 0x09, 0xF2, 0x43, 0x02, 0x24, 0xF2, 0x43,
	0x04, 0x24, 0xC2, 0x43, 0x10, 0x24, 0x7E, 0x40,
	0x80, 0x00, 0xC2, 0x4E, 0x21, 0x09, 0xC2, 0x4E,
	0x23, 0x09, 0xF2, 0x40, 0x8C, 0x00, 0x20, 0x09,
	0xF2, 0x40, 0x8C, 0x00, 0x22, 0x09, 0xF2, 0x40,
	0x03, 0x00, 0x2F, 0x09, 0xF2, 0x40, 0x03, 0x00,
	0x2E, 0x09, 0xC2, 0x4E, 0xC8, 0x23, 0xF2, 0x40,
	0x10, 0x00, 0xC9, 0x23, 0xC2, 0x4E, 0xCA, 0x23,
	0xC2, 0x4E, 0xCE, 0x23, 0xF2, 0x40, 0x40, 0x00,
	0xCF, 0x23, 0xC2, 0x4E, 0x88, 0x23, 0xC2, 0x43,
	0x89, 0x23, 0xC2, 0x43, 0x8A, 0x23, 0xF2, 0x40,
	0x40, 0x00, 0x8F, 0x23, 0xF2, 0x40, 0x40, 0x00,
	0x3C, 0x09, 0xC2, 0x43, 0x3E, 0x09, 0xF2, 0x40,
	0xC0, 0x00, 0x3D, 0x09, 0x10, 0x01, 0x7B, 0x15,
	0x08, 0x4C, 0x07, 0x4D, 0x04, 0x4F, 0x4C, 0x43,
	0x0A, 0x48, 0x0B, 0x4D, 0x0F, 0x4E, 0x3F, 0xE3,
	0x0F, 0x5F, 0x0F, 0x7F, 0x06, 0x48, 0x06, 0x5E,
	0x07, 0x6F, 0x02, 0x3C, 0x1A, 0x53, 0x0B, 0x63,
	0x0B, 0x97, 0x03, 0x28, 0x2C, 0x20, 0x0A, 0x96,
	0x2A, 0x2C, 0x18, 0xB3, 0x08, 0x2C, 0x0E, 0x46,
	0x0F, 0x47, 0x3E, 0x53, 0x3F, 0x63, 0x0A, 0x9E,
	0x19, 0x20, 0x0B, 0x9F, 0x17, 0x20, 0x6E, 0x44,
	0xB0, 0x13, 0x66, 0x2E, 0x10, 0x20, 0x4C, 0x43,
	0xB0, 0x13, 0x56, 0x2E, 0x1B, 0x15, 0x0F, 0x16,
	0xCF, 0x4E, 0x00, 0x00, 0xB0, 0x13, 0x56, 0x2E,
	0x1B, 0x15, 0x0F, 0x16, 0x6D, 0x4F, 0x4E, 0x9D,
	0x03, 0x24, 0x5C, 0x43, 0x01, 0x3C, 0x6C, 0x42,
	0x14, 0x53, 0x07, 0x3C, 0x3E, 0x44, 0x0C, 0x4A,
	0x0D, 0x4B, 0xB0, 0x13, 0x64, 0x2D, 0x1A, 0x53,
	0x0B, 0x63, 0x4C, 0x93, 0xCF, 0x27, 0x74, 0x17,
	0x10, 0x01, 0x3B, 0x15, 0x0A, 0x4E, 0xB2, 0x43,
	0x54, 0x01, 0x08, 0x4C, 0x09, 0x4D, 0x07, 0x3C,
	0x19, 0x15, 0x0E, 0x16, 0x6F, 0x4E, 0xC2, 0x4F,
	0x52, 0x01, 0x18, 0x53, 0x09, 0x63, 0x0E, 0x4C,
	0x0F, 0x4D, 0x0E, 0x5A, 0x0F, 0x63, 0x09, 0x9F,
	0x03, 0x28, 0x09, 0x20, 0x08, 0x9E, 0x07, 0x2C,
	0xB0, 0x13, 0x66, 0x2E, 0xED, 0x27, 0x6C, 0x42,
	0xB0, 0x13, 0x12, 0x2E, 0x15, 0x3C, 0x1E, 0x42,
	0x54, 0x01, 0x1F, 0x42, 0x5C, 0x24, 0xFF, 0x40,
	0x3A, 0x00, 0x00, 0x00, 0x1B, 0x42, 0x5C, 0x24,
	0xCB, 0x4E, 0x01, 0x00, 0x47, 0x18, 0x0E, 0x11,
	0x1F, 0x42, 0x5C, 0x24, 0xCF, 0x4E, 0x02, 0x00,
	0x3C, 0x40, 0x03, 0x00, 0xB0, 0x13, 0x2A, 0x2E,
	0x38, 0x17, 0x10, 0x01, 0x32, 0xC2, 0x03, 0x43,
	0xB2, 0x40, 0x02, 0x1C, 0x5A, 0x24, 0xB2, 0x40,
	0x17, 0x24, 0x5C, 0x24, 0xB2, 0x40, 0x28, 0x96,
	0x00, 0x09, 0x82, 0x43, 0x02, 0x09, 0x82, 0x43,
	0x60, 0x01, 0xB2, 0x40, 0xF3, 0x10, 0x64, 0x01,
	0xB2, 0x40, 0x40, 0x00, 0x62, 0x01, 0xB2, 0x40,
	0x44, 0x02, 0x68, 0x01, 0xC2, 0x43, 0x0E, 0x24,
	0xC2, 0x43, 0x11, 0x24, 0xB2, 0x40, 0x28, 0x96,
	0x00, 0x09, 0xB2, 0x40, 0x40, 0x1E, 0x08, 0x09,
	0xB2, 0x40, 0x80, 0x00, 0x04, 0x09, 0xB0, 0x13,
	0x4A, 0x2E, 0xC2, 0x43, 0x12, 0x24, 0xB2, 0xB2,
	0x08, 0x09, 0x06, 0x28, 0xB0, 0x13, 0x86, 0x2C,
	0xB0, 0x13, 0x08, 0x2A, 0xA2, 0xD3, 0x02, 0x09,
	0x10, 0x01, 0x3B, 0x15, 0x4A, 0x4F, 0x6F, 0x42,
	0x3B, 0x40, 0x58, 0x24, 0xB0, 0x13, 0x66, 0x2E,
	0x08, 0x20, 0x4F, 0x43, 0xA2, 0x4B, 0x44, 0x01,
	0x28, 0x4B, 0x38, 0x50, 0x40, 0x00, 0x82, 0x48,
	0x40, 0x01, 0x4F, 0x93, 0x0B, 0x20, 0xB2, 0x90,
	0x05, 0x00, 0x5E, 0x24, 0x07, 0x38, 0x0F, 0x4E,
	0x1E, 0x42, 0x5E, 0x24, 0x2E, 0x82, 0xB0, 0x13,
	0x8E, 0x2A, 0x4F, 0x4C, 0x4A, 0x93, 0x03, 0x20,
	0x4C, 0x4F, 0xB0, 0x13, 0x12, 0x2E, 0xA2, 0x4B,
	0x40, 0x01, 0x2F, 0x4B, 0x3F, 0x50, 0x10, 0x00,
	0x82, 0x4F, 0x44, 0x01, 0x38, 0x17, 0x10, 0x01,
	0x1B, 0x15, 0x21, 0x83, 0x0D, 0x43, 0x3A, 0x40,
	0xE0, 0xFF, 0x0B, 0x43, 0x7E, 0x4A, 0x0F, 0x4C,
	0x0F, 0x5B, 0x6F, 0x4F, 0x0E, 0xEF, 0x0D, 0xDE,
	0x1B, 0x53, 0x3B, 0x90, 0x20, 0x00, 0xF6, 0x2B,
	0x0D, 0x93, 0x0E, 0x20, 0xB1, 0x40, 0xFF, 0x7F,
	0x00, 0x00, 0x02, 0x3C, 0xB1, 0x53, 0x00, 0x00,
	0x91, 0x93, 0x00, 0x00, 0xFB, 0x37, 0xB2, 0x40,
	0xA5, 0xA5, 0x56, 0x24, 0x4C, 0x43, 0x04, 0x3C,
	0xB0, 0x13, 0xD4, 0x2D, 0x7C, 0x40, 0x05, 0x00,
	0x21, 0x53, 0x1A, 0x17, 0x10, 0x01, 0x21, 0x82,
	0x81, 0x43, 0x02, 0x00, 0xB2, 0x40, 0x28, 0x96,
	0x00, 0x09, 0x92, 0xD3, 0x02, 0x09, 0x92, 0x42,
	0x14, 0x24, 0x12, 0x09, 0xB2, 0x40, 0x00, 0x13,
	0x10, 0x09, 0x82, 0x43, 0x14, 0x09, 0x81, 0x43,
	0x00, 0x00, 0x02, 0x3C, 0x91, 0x53, 0x00, 0x00,
	0xB1, 0x90, 0x64, 0x00, 0x00, 0x00, 0xFA, 0x2B,
	0x1F, 0x41, 0x02, 0x00, 0x0E, 0x4F, 0x1E, 0x53,
	0x81, 0x4E, 0x02, 0x00, 0x3F, 0x90, 0xE9, 0x03,
	0x03, 0x2C, 0x82, 0x93, 0x14, 0x09, 0xE9, 0x23,
	0x21, 0x52, 0x10, 0x01, 0xB0, 0x13, 0x66, 0x2E,
	0x0E, 0x20, 0x4C, 0x43, 0xB0, 0x13, 0xFA, 0x2C,
	0x1D, 0x42, 0x58, 0x24, 0x2D, 0x53, 0x82, 0x4D,
	0x40, 0x01, 0x1F, 0x15, 0x0D, 0x16, 0xCD, 0x43,
	0x00, 0x00, 0x80, 0x00, 0x08, 0x2D, 0x6C, 0x42,
	0x10, 0x01, 0x92, 0xB3, 0x44, 0x01, 0xFD, 0x2F,
	0x92, 0x42, 0x58, 0x24, 0x44, 0x01, 0x10, 0x01,
	0x92, 0xB3, 0x44, 0x01, 0xFD, 0x2F, 0x1F, 0x42,
	0x58, 0x24, 0x3F, 0x50, 0x10, 0x00, 0x82, 0x4F,
	0x44, 0x01, 0x10, 0x01, 0x82, 0x43, 0x5E, 0x24,
	0xC2, 0x43, 0x8A, 0x23, 0xB0, 0x13, 0xA6, 0x28,
	0xD2, 0x93, 0x12, 0x24, 0x0D, 0x20, 0xC2, 0x93,
	0x11, 0x24, 0x0A, 0x20, 0x4F, 0x43, 0xC2, 0x93,
	0x8A, 0x23, 0x04, 0x34, 0x5F, 0x42, 0x8A, 0x23,
	0x7F, 0xF0, 0x7F, 0x00, 0x82, 0x4F, 0x5E, 0x24,
	0x82, 0x93, 0x5E, 0x24, 0xEB, 0x27, 0x92, 0x93,
	0x5E, 0x24, 0x06, 0x38, 0x5F, 0x42, 0x01, 0x1C,
	0x82, 0x4F, 0x5E, 0x24, 0x5C, 0x43, 0x10, 0x01,
	0x4C, 0x43, 0x10, 0x01, 0x1B, 0x15, 0xB0, 0x13,
	0x66, 0x2E, 0x15, 0x20, 0x4F, 0x43, 0xB0, 0x13,
	0x56, 0x2E, 0x1D, 0x15, 0x0A, 0x16, 0x8A, 0x4E,
	0x00, 0x00, 0xB0, 0x13, 0x56, 0x2E, 0x1D, 0x15,
	0x0A, 0x16, 0x2B, 0x4A, 0x0E, 0x9B, 0x01, 0x24,
	0x5F, 0x43, 0x92, 0xB3, 0x46, 0x01, 0x04, 0x28,
	0x7F, 0x40, 0x03, 0x00, 0x01, 0x3C, 0x6F, 0x42,
	0x4C, 0x4F, 0x1A, 0x17, 0x10, 0x01, 0x0A, 0x12,
	0x7E, 0x40, 0x3F, 0x00, 0xC2, 0x93, 0xCA, 0x23,
	0x11, 0x34, 0xC2, 0x4E, 0x80, 0x1C, 0x3D, 0x40,
	0x81, 0x1C, 0x4F, 0x43, 0x0A, 0x4C, 0x0A, 0x5F,
	0xED, 0x4A, 0x00, 0x00, 0x1D, 0x53, 0x5F, 0x53,
	0x4F, 0x9E, 0xF8, 0x2B, 0xF2, 0x40, 0x40, 0x00,
	0xCA, 0x23, 0x01, 0x3C, 0x4E, 0x43, 0x4C, 0x4E,
	0x3A, 0x41, 0x10, 0x01, 0xB0, 0x13, 0xFA, 0x2C,
	0xB0, 0x13, 0x56, 0x2E, 0x1F, 0x42, 0x58, 0x24,
	0x3F, 0x50, 0x06, 0x00, 0x82, 0x4F, 0x40, 0x01,
	0xC2, 0x43, 0xE0, 0xFF, 0xB0, 0x13, 0x08, 0x2D,
	0x4C, 0x43, 0x10, 0x01, 0xB2, 0x40, 0xA5, 0xA5,
	0x56, 0x24, 0xB2, 0x40, 0x00, 0xA5, 0x58, 0x24,
	0xB0, 0x13, 0x7C, 0x2B, 0xB0, 0x13, 0x1C, 0x2D,
	0x5C, 0xB3, 0xFC, 0x2B, 0xB0, 0x13, 0xD0, 0x27,
	0xF9, 0x3F, 0x1F, 0x42, 0x5C, 0x24, 0xFF, 0x40,
	0x3B, 0x00, 0x00, 0x00, 0x1F, 0x42, 0x5C, 0x24,
	0xCF, 0x4C, 0x01, 0x00, 0x2C, 0x43, 0x80, 0x00,
	0x2A, 0x2E, 0xC2, 0x4C, 0x16, 0x24, 0x3C, 0x40,
	0x16, 0x24, 0xB0, 0x13, 0x9E, 0x2D, 0x4C, 0x93,
	0xFA, 0x27, 0x10, 0x01, 0x6E, 0x4E, 0x5F, 0x4F,
	0x05, 0x00, 0x47, 0x18, 0x0F, 0x5F, 0x0E, 0xDF,
	0x10, 0x01, 0x03, 0x43, 0x3F, 0x40, 0xDE, 0x2E,
	0x3F, 0x53, 0xFE, 0x2F, 0x10, 0x01, 0x92, 0xB3,
	0x44, 0x01, 0xFD, 0x2F, 0x10, 0x01, 0xB2, 0x40,
	0x80, 0x5A, 0x5C, 0x01, 0x10, 0x01, 0xB2, 0x90,
	0xA5, 0xA5, 0x56, 0x24, 0x10, 0x01, 0x1D, 0x15,
	0x10, 0x01
};

const struct loadbsl_fw loadbsl_fw_usb5xx = {
	.data		= RAM_BSL_00_05_04_34,
	.size		= sizeof(RAM_BSL_00_05_04_34),
	.prog_addr	= 0x2500,
	.entry_point	= 0x2504
};
