
/*
 * $Header: /cvsroot/mpdist/mpdist/mimep/ertf2latex/ertf2latex.c,v 1.1.1.1 2002/04/12 16:47:26 richbastard Exp $
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ertf2latex.h"

static char *usage = "Usage: ertf2latex input_file [-onlybody]\n";

static char taille_car = 4;
static char affiche = True;
static char after_style = False;


static void 
taille(void)
{

/* To put the right character size */

    switch (taille_car) {
        case 0:
            FPRINTF(stdout, "%s", TAILLE0);
            break;
        case 1:
            FPRINTF(stdout, "%s", TAILLE1);
            break;
        case 2:
            FPRINTF(stdout, "%s", TAILLE2);
            break;
        case 3:
            FPRINTF(stdout, "%s", TAILLE3);
            break;
        case 4:
            FPRINTF(stdout, "%s", TAILLE4);
            break;
        case 5:
            FPRINTF(stdout, "%s", TAILLE5);
            break;
        case 6:
            FPRINTF(stdout, "%s", TAILLE6);
            break;
        case 7:
            FPRINTF(stdout, "%s", TAILLE7);
            break;
        case 8:
            FPRINTF(stdout, "%s", TAILLE8);
            break;
        case 9:
            FPRINTF(stdout, "%s", TAILLE9);
            break;
    }
}


static void 
MACRO_1(void)
{
    if (taille_car < 9) {
        taille_car++;
    }
    taille();

}


static void 
MACRO_2(void)
{
    if (taille_car > 0) {
        taille_car--;
    }
    taille();

}


static void 
MACRO_5(void)
{
    if (taille_car > 0) {
        taille_car--;
    }
    FPRINTF(stdout, "%c", FIN_BLOC);
}


static void 
MACRO_6(void)
{
    if (taille_car < 9) {
        taille_car++;
    }
    FPRINTF(stdout, "%c", FIN_BLOC);
}


static void 
MACRO_3(void)
{
    affiche = False;

}


static void 
MACRO_4(void)
{
    affiche = True;

}


static void 
style(int styl)         /* Outputs the right style */
{
    switch (styl) {
        case 1:
            FPRINTF(stdout, "%s", BOLD);
            break;
        case 2:
            FPRINTF(stdout, "%s", ITALIC);
            break;
        case 3:
            FPRINTF(stdout, "%s", FIXED);
            break;
    }
    after_style = True;
}


static void 
Appel_Macro(int no_macro)
{
    switch (no_macro) {
        case 1:
            if (affiche) {
                MACRO_1();
            }
            break;
        case 2:
            if (affiche) {
                MACRO_2();
            }
            break;
        case 3:
            MACRO_3();
            break;
        case 4:
            MACRO_4();
            break;
        case 5:
            MACRO_5();
            break;
        case 6:
            MACRO_6();
            break;
        case 7:
            style(1);
            break;
        case 8:
            style(2);
            break;
        case 9:
            style(3);
            break;
    }
}


/* To produce an entire LaTeX document, outputs the prologue of this document.
 */

static void 
entete(void)
{
    P("\\documentclass [a4paper,12pt] {article}");
    P("\\usepackage{graphics}");
    P("\\usepackage{moreverb}");

    P("\\newenvironment{ident}{\\begin{list}%");
    P("{}{\\rightmargin=0mm}\\item[]}%");
    P("{\\end{list}}");

    P("\\newenvironment{indentright}{\\begin{list}%");
    P("{}{\\rightmargin=\\leftmargin%");
    P("\\leftmargin=0mm}\\item[]}%");
    P("{\\end{list}}");

    P("\\newenvironment{nofill}{\\parindent=0mm\\obeylines}{\\par}");

    P("\\begin{document}");
}


/* Same with the end of the document */

static void 
piedpage(void)
{
    P("\\end{document}");
}


/* Converts a string into lower case. Returns a pointer to this string... */

static char *
strtolower(char *src_str)
{
    char *tgt_str;
    int j;

    tgt_str = (char *) malloc(sizeof(char) * (strlen(src_str) + 1));
    for (j = 0; j < strlen(src_str); j++) {
        if (isupper((int) (*(src_str + j)))) {
            tgt_str[j] = (char) tolower((int) (*(src_str + j)));
        } else {
            tgt_str[j] = *(src_str + j);
        }
    }
    tgt_str[j] = '\0';

    return(tgt_str);
}


static int 
convert(char *filename)
{
    char *ERR[] = {
        "Erreur lors de l'ouverture du fichier source\n",
        "Erreur de syntaxe...\n",
        "Erreur grammaticale...\n"
    };

/* The text/enriched commands with their translations in LaTeX */

    char *corresp[] = {
        "<underline>",    "\\underline{",
        "</underline>",   "}",
        "<bold>",         "MACRO_7",
        "</bold>",        "}",
        "<italic>",       "MACRO_8",
        "</italic>",      "}",
        "<fixed>",        "MACRO_9",
        "</fixed>",       "}",
        "<center>",       "\\begin{center}",
        "</center>",      "\\end{center}",
        "<flushleft>",    "\\begin{flushleft}",
        "</flushleft>",   "\\end{flushleft}",
        "<flushright>",   "\\begin{flushright}",
        "</flushright>",  "\\end{flushright}",
        "<flushboth>",    "",
        "</flushboth>",   "",
        "<nofill>",       "\\begin{nofill}",
        "</nofill>",      "\\end{nofill}",
        "<indent>",       "\\begin{indent}",
        "</indent>",      "\\end{indent}",
        "<indentright>",  "\\begin{indentright}",
        "</indentright>", "\\end{indentright}",
        "<<",             "$<$",
        "<bigger>",       "MACRO_1",
        "</bigger>",      "MACRO_5",
        "<smaller>",      "MACRO_2",
        "</smaller>",     "MACRO_6",
        "<param>",        "MACRO_3",
        "</param>",       "MACRO_4",
        NULL,             NULL
    };

/* The special symbols of LaTeX and the elements which may replace them */

    char *specar[] = {
        "$",  "\\$",
        "&",  "\\&",
        "%",  "\\%",
        "#",  "\\#",
        "_",  "\\_",
        "{",  "\\{",
        "}",  "\\}",
        "\\", "$\\backslash$",
        "|",  "$|$",
        "<",  "$<$",
        ">",  "$>$",
        "~",  "$\\sim$",
        "^",  "$\\wedge$",
        NULL, NULL
    };

    FILE       *fp;          /* Pointer on the source file */
    char       carcour;
    char       buffer[256];
    int        buf_ind = 0;
    int        k;
    int        ind = 0;
    char       trouve;
    char       fin_com;
    format_com *comm;
    format_com *com_cour;
    Liste_com  l;

/*
 *  if (_TRACE) {
 *      for ( i = 0; corresp[i]; i++) {
 *          printf("%s\n", corresp[i]);
 *      }
 *  }
 */

    if (!strcmp(filename, "stdin")) {
        fp = stdin;
    } else {

/* If the input is not the standard one, opens the source file 
 * (in text/enriched)
 */

        if (!(fp = fopen(filename, "r"))) {
            FPRINTF(stderr, "%s", ERR[0]);
            FPRINTF(stderr, "%s", usage);
            exit(1);
        }
    }
    if (_TRACE) {
        T("Fichier ouvert!");
    }

/* Creates a list in which will be stored the "last commands" */

    CreeListe(&l);

/* Reads each character in the source file */

    while ((fscanf(fp, "%c", &carcour)) != EOF) {

/* Does it look like the beginning of a text/enriched command ? */

        if (carcour == '<') {      /* yes, it does ... */
            *(buffer + buf_ind) = carcour;
            *(buffer + buf_ind + 1) = '\0';
            buf_ind++;

            if ((fscanf(fp, "%c", &carcour)) != EOF) {
                if (carcour != '<') {

/* Stores the current character in the buffer */

                    *(buffer + buf_ind) = carcour;
                    *(buffer + buf_ind + 1) = '\0';
                    buf_ind++;

/* Does it look like the end of a text/enriched command ? */

                    if (carcour == '>') {
                        fin_com = True;    /* Yes, it does */
                    } else {
                        fin_com = False;    /* No, it doesn't */
                    }

/* Reads each character of the source file until it finds either the end
 * of the command or the end of the file.
 */

                    while ((!fin_com) && 
                           ((fscanf(fp, "%c", &carcour)) != EOF)) {
                        if (buf_ind < 61) {

/* Stores the character in the buffer */

                            *(buffer + buf_ind) = carcour;
                            *(buffer + buf_ind + 1) = '\0';
                            buf_ind++;
                            if (_TRACE) {
                                FPRINTF(stderr, "buffer: %s\n", buffer);
                            }
                        } else {
                            if (affiche) {
                                (void) fprintf(stdout, "%s", buffer);
                            }
                            FPRINTF(stderr, "%s", ERR[1]);
                            FPRINTF(stderr, "Fin de commande introuvable: %s\n",
                                            buffer);
                            buf_ind = 0;
                            break;
                        }

/* Does it look like the end of a text/enriched command? */

                        if (carcour == '>') {
                            fin_com = True;     /* Yes, it does */
                        }
                    }

                    if (fin_com) {
                        trouve = False;

                        if (_TRACE) {
                            FPRINTF(stderr, "Indice: %d\n", ind);
                        }

                        ind = 0;

/* Is this a text/enriched command ? */

                        while ((corresp[ind]) && (!trouve)) {
                            if (!strcmp(corresp[ind], strtolower(buffer))) {
                                trouve = True;
                            }
                            if (!trouve) {
                                ind += 2;
                            }
                        }

                        if (!trouve) {    /* No, it isn't ! */
                            buf_ind = 0;
                            FPRINTF(stderr, "%s", ERR[1]);
                            FPRINTF(stderr, "La commande: %s n'existe pas dans le format enriched/text\n", buffer);
                        } else {

/* It is a text/enriched command ! */

/* Is this the end of a block (block = <bold> text </bold> ) */

                            if (*(buffer + 1) != '/') {

/* No, it isn't the end of a block ! */

/* Do we have to call a MACRO command ? */

                                if (!strncmp(corresp[ind + 1], MACRO, 
                                     strlen(MACRO))) {
                                    Appel_Macro(atoi(corresp[ind + 1] + strlen(MACRO)));    /* Yes, call the MACRO ! */
                                } else {

/* No, replace with the corresponding element */

                                    FPRINTF(stdout, "%s", corresp[ind + 1]);
                                }
                                comm = (format_com *) malloc(sizeof(format_com));
/* Stores the command in the list */

                                remplie_comm(comm, strtolower(buffer), &l);
                                AjouteListe(&l, comm);
                            } else {

/* Yes, it is the end of a block ! */
                                if (corresp[ind - 2]) {

/* Do we have the beginning of the block in the list ? */

                                    if ((com_cour = Trouve(corresp[ind - 2], &l))) {

/* Yes, we do ! */
/* Removes the element from the list */

                                        OteEltListe(&l, com_cour);
                                        if (!strncmp(corresp[ind + 1], MACRO, strlen(MACRO)))
                                            Appel_Macro(atoi(corresp[ind + 1] + strlen(MACRO)));
                                        else
                                            FPRINTF(stdout, "%s", corresp[ind + 1]);
                                    } else {

/* No, we don't have the beginning of the block in the list */

                                        FPRINTF(stderr, "%s", ERR[2]);
                                        FPRINTF(stderr, "%s manquant!\n", 
                                                        corresp[ind - 2]);
                                    }
                                }
                            }
                            buf_ind = 0;
                        }
                    }
                }
            }
        } else {

/* No, we are not in a command (it doesn't look like the beginning of 
 * a command)
 */

            k = 0;
            trouve = False;
            while ((specar[k]) && (!trouve)) {

/* Warning, it is a LaTeX special symbol! */

                if (((char) *specar[k] == carcour) && 
                    (affiche) && (specar[k + 1])) {
                    FPRINTF(stdout, "%s", specar[k + 1]);
                    trouve = True;
                }
                if (!trouve) {
                    k += 2;
                }
            }
            if ((carcour == SPACE) && (after_style)) {
                FPRINTF(stdout, "%s", BLOC);
                after_style = False;
            }
            if ((!trouve) && (affiche)) {
                FPRINTF(stdout, "%c", carcour);
            }
        }
    }

/* It is the end of the document. Are all the blocks closed ? */

    while (!FinListe(&l)) {             /* Closes the blocks */
        com_cour = position_tete(&l);
        ind = 0;
        trouve = False;
        while ((corresp[ind]) && (!trouve)) {
            if (!strcmp(corresp[ind] + 2, strtolower(com_cour->c_name + 1))) {
                trouve = True;
             }
            if (!trouve) {
                ind += 2;
            }
        }

        if (!trouve) {
            FPRINTF(stdout, "%c", FIN_BLOC);
        } else {
            FPRINTF(stdout, "%s", corresp[ind + 1]);
        }

        OteEltListe(&l, com_cour);
    }

    return(0);
}


int 
main(int argc, char *argv[])
{
    char fichier[50];
    char ONLYBODY = False;

/* Analysis of the command line (from stdin or from file, etc. ?) */

    switch (argc) {
        case 1:
            STRCPY(fichier, "stdin");
            break;

        case 2:
            if (!strcmp(argv[1], "-onlybody")) {
                ONLYBODY = True;
                STRCPY(fichier, "stdin");
            } else {
                STRCPY(fichier, argv[1]);
                ONLYBODY = False;
            }
            break;

        case 3:
            if (!strcmp(argv[1], "-onlybody")) {
                ONLYBODY = True;
                STRCPY(fichier, argv[2]);
            } else if (!strcmp(argv[2], "-onlybody")) {
                ONLYBODY = True;
                STRCPY(fichier, argv[1]);
            } else {
                FPRINTF(stderr, "%s", usage);
                exit(1);
            }
            break;

        default:
            FPRINTF(stderr, "%s", usage);
            exit(1);
    }

    if (!ONLYBODY) {
        entete();
    }

/* Translates the text/enriched source into LaTeX */

    (void) convert(fichier);

    if (!ONLYBODY) {
        piedpage();
    }

    return(0);
}
