﻿/*****************************************************
*  
*  Copyright 2010 Adobe Systems Incorporated.  All Rights Reserved.
*  
*****************************************************
*  The contents of this file are subject to the Mozilla Public License
*  Version 1.1 (the "License"); you may not use this file except in
*  compliance with the License. You may obtain a copy of the License at
*  http://www.mozilla.org/MPL/
*   
*  Software distributed under the License is distributed on an "AS IS"
*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
*  License for the specific language governing rights and limitations
*  under the License.
*   
*  
*  The Initial Developer of the Original Code is Adobe Systems Incorporated.
*  Portions created by Adobe Systems Incorporated are Copyright (C) 2010 Adobe Systems 
*  Incorporated. All Rights Reserved. 
*  
*****************************************************/

package
{
	import flash.utils.*;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Stage;
	import flash.display.Graphics;
	import flash.display.MovieClip;
	import flash.display.IBitmapDrawable;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import flash.display.DisplayObject;
	
	/**
	 * Class takes a base symbol, and clones it a number of times in order
	 * to reach the desired width. The surplus width gets masked out.
	 */
	public class MovieClipRow extends Sprite
	{		
		public function MovieClipRow()
		{
			super();
			
			var instanceName:String = getQualifiedClassName(this)+"Base";;
			if (hasOwnProperty(instanceName))
			{
				base = this[instanceName] as MovieClip;
		
				base.visible = false;
				_mask = base.hasOwnProperty("maskMovieClip") ? base.maskMovieClip : base;
				
				addEventListener(Event.ENTER_FRAME, draw);
				
				_width = super.width;
				
				scaleX = 1; 
				scaleY = 1;
			}
		}
		
		override public function set width(value:Number):void
		{
			if (value != _width)
			{
				_width = value;
				
				draw();
			}
		}

		override public function get width():Number
		{
			return _width;
		}
		
		// Internals
		//
		private var base:MovieClip;
		private var _mask:DisplayObject;
		private var _width:Number;
		private var clones:Number;
		
		private function draw(event:Event  = null):void
		{
			var bmpd:BitmapData = new BitmapData(_mask.width, _mask.height);
			bmpd.draw(base, null, null, null, _mask.getBounds(base));
			
			graphics.clear();
			graphics.beginBitmapFill(bmpd);
			graphics.drawRect(0, 0, _width, _mask.height);
			graphics.endFill();
		}
	}
	
}
