.TH MAYAVI2 1
.SH NAME
mayavi2 \- A scientific visualization package for 2-D and 3-D data
.SH SYNOPSIS
.B mayavi2 [options]  [args]

Where arg1, arg2 etc\&. are optional file names that correspond to saved
Mayavi2 visualizations (filename\&.mv2),  Mayavi2 scripts
(filename\&.py) and any data file formats that Mayavi supports\&.

.SH "DESCRIPTION"

.PP
Mayavi2 is a tool for 2-D and 3-D scientific visualization\&. Features
of Mayavi2 include:

.PP
.IP *
Visualization of scalar and vector data in 2 and 3 dimensions
.IP *
Easy scriptability using Python 
.IP *
Easy extendability via sources, components, modules, and data filters
.IP *
Reading several file formats: VTK (legacy and XML), PLOT3D, etc\&.
.IP *
Saving of visualizations 
.IP *
Saving rendered visualization in a variety of image formats\&.


.SH "OPTIONS"
.PP
.B -h

This prints all the available command line options and exits\&.  Also
available through \fB\-\-help\fP\&.

.PP
.B -V

This prints the Mayavi version on the command line and exits\&.  Also
available through \fB\-\-version\fP\&.

.PP
.B -z filename\&.mv2

This loads a previously saved Mayavi2 visualization\&.  Also available
through \fB\-\-viz\fP filename\&.mv2 or \fB\-\-visualization\fP
filename\&.mv2\&.

.PP
.B -d
datafile\&.*

Opens any of the supported data file formats or a non-file related data
source\&.  This includes VTK file formats (*\&.vtk, *\&.xml,
*\&.vt[i,p,r,s,u], *\&.pvt[i,p,r,s,u]), VRML2 (*\&.wrl), 3D Studio
(*\&.3ds), PLOT3D (*\&.xyz), STL, BYU, RAW, PLY, PDB, SLC, FACET, OBJ,
AVSUCD (*\&.inp), GAMBIT (*\&.neu), Exodus (*\&.exii), PNG, JPEG, BMP,
PNM, DCM, DEM, MHA, MHD, MINC, XIMG, TIFF, and various others that are
supported\&.  datafile\&.* can also be a source object not associated
with a file, for example ParametricSurface or PointLoad will load the
corresponding data sources into Mayavi\&.  Also available through
\fB\-\-data\fP\&.

.PP
.B -m
module-name

A module is an object that actually visualizes the data\&.  The given
module-name is loaded in the current ModuleManager\&.  The module name
must be a valid one if not you will get an error message\&.

If a module is specified as 'package\&.sub\&.module\&.SomeModule' then the
module (SomeModule) is imported from 'package\&.sub\&.module'\&.  Standard
modules provided with mayavi2 do not need the full path
specification\&.  For example:
.PP
.RS
\f(CWmayavi2 \-d data\&.vtk \-m Outline \-m m2_user_modules\&.TestModule\fP
.RE

In this example 'Outline' is a standard module 
and 'm2_user_modules\&.TestModule' is some user defined module\&.  See
.B MAYAVI2 MODULES
section below for an exhaustive list of available modules\&.  Also
available through \fB\-\-module\fP\&.

.PP
.B -f
filter-name

A filter is an object that filters out the data in some way or the 
other\&.  The given filter-name is loaded with respect to the current
source/filter object\&.  The filter name must be a valid one if not you
will get an error message\&.

If the filter is specified as 'package\&.sub\&.filter\&.SomeFilter' then the
filter (`SomeFilter`) is imported from 'package\&.sub\&.filter'\&.  Standard
modules provided with mayavi2 do not need the full path
specification\&.  For example:
.PP
.RS
\f(CWmayavi2 \-d data\&.vtk \-f ExtractVectorNorm \-f m2_user_filters\&.TestFilter\fP
.RE

In this example 'ExtractVectorNorm' is a standard filter 
and 'm2_user_filters\&.TestFilter' is some user defined filter\&.

See
.B MAYAVI2 FILTERS
section below for an exhaustive list of available filters\&. Also
available through \fB\-\-filter\fP\&.

.PP
.B -M

Starts up a new module manager on the Mayavi pipeline\&. Also available
through \fB\-\-module\-mgr\fP\&.

.PP
.B -n

Creates a new window/scene\&. Any options passed after this will apply
to this newly created scene\&.  Also available through \fB\-\-new\-window\fP\&.

.PP
.B -t

Runs the mayavi2 test suite and exits\&.  If run as such, this runs
both the TVTK and Mayavi2 unittests\&.  If any additional arguments
are passed they are passed along to the test runner\&.  So this may be
used to run other tests as well\&.  For example:
.PP
.RS
\f(CWmayavi2 \-t enthought\&.persistence\fP
.RE

This will run just the tests inside the enthought\&.persistence
package\&.  You can also specify a directory with test files to run
with this, for example:
.PP
.RS
\f(CWmayavi2 \-t relative_path_to/integrationtests/mayavi\fP
.RE

will run the integration tests from the mayavi sources.   Also available
through \fB\-\-test\fP\&.

.PP
.B -x
script-file

This executes the given script in a namespace where we guarantee that 
the name 'mayavi' is Mayavi's script instance -- just like in the
embedded Python interpreter\&.  Also available through \fB\-\-exec\fP

.B WARNING:
Note that this uses `execfile`, so please note that
this can be dangerous if the script does something nasty!

.PP
.B -s 
python-expression

Execute the expression on the last created object\&.  For example, if
the previous object was a module, and we want to set the color of that
object one can do \-s "actor\&.property\&.color = (1,0,0)".  One should
use quotes for the expression. Also available with \fB\-\-set\fP\&.  For
example: 

.PP
.RS
 \f(CWmayavi2 \-d ParametricSurface \-m Outline \\ \fP
 \f(CW \-s "actor\&.property.color = (1,0,0)" \\ \fP
 \f(CW \-s "scene.save('test\&.png', size=(800, 800))"\fP
.RE

.B WARNING:
Note that this uses `exec`, so please note that this can be dangerous!

.SH "MAYAVI2 MODULES"

.TP
.B Axes
Draws simple axes\&.

.TP
.B ContourGridPlane
A contour grid plane module\&. This module lets one take a slice of
input grid data and view contours of the data\&.

.TP
.B CustomGridPlane
A custom grid plane with a lot more flexibility than GridPlane module\&.

.TP
.B DataSetClipper
This filter clips the dataset in a area.  The area can be
defined interactively as a box, a sphere...

.TP
.B Glyph
Displays different types of glyphs oriented and colored as per scalar 
or vector data at the input points\&.

.TP
.B GridPlane
A simple grid plane module\&.

.TP
.B HyperStreamline
A module that integrates through a tensor field to generate a 
hyperstreamline\&. The integration is along the maximum eigenvector and
the cross section of the hyperstreamline is defined by the two other 
eigenvectors\&. Thus the shape of the hyperstreamline is "tube-like",
with the cross section being elliptical. Hyperstreamlines are used to
visualize tensor fields\&.

.TP
.B ImageActor
A simple module to view image data efficiently\&.

.TP
.B ImagePlaneWidget
A simple module to view image data\&.

.TP
.B IsoSurface
A module that allows the user to make contours of input point data\&.

.TP
.B Labels
Allows a user to label the current dataset or the current actor of the 
active module\&.

.TP
.B OrientationAxes
Creates a small axes on the side that indicates the position of the
co-ordinate axes and thereby marks the orientation of the
scene\&. Requires VTK-4\&.5 and above\&.

.TP
.B Outline
A module that draws an outline for the given data\&.

.TP
.B ScalarCutPlane
Takes a cut plane of any input data set using an implicit plane and
plots the data with optional contouring and scalar warping\&.

.TP
.B SliceUnstructuredGrid
This module takes a slice of the unstructured grid data and shows the 
cells that intersect or touch the slice\&.

.TP
.B Streamline
Allows the user to draw streamlines for given vector data\&. This
supports various types of seed objects (line, sphere, plane and point
seeds)\&. It also allows the user to draw ribbons or tubes and further
supports different types of interactive modes of calculating the
streamlines\&.

.TP
.B StructuredGridOutline
Draws a grid-conforming outline for structured grids\&.

.TP
.B Surface
Draws a surface for any input dataset with optional contouring\&.

.TP
.B TensorGlyph
Displays tensor glyphs oriented and colored as per scalar or vector data at 
the input points\&.

.TP
.B Text
This module allows the user to place text on the screen\&.

.TP
.B VectorCutPlane
Takes an arbitrary slice of the input data using an implicit cut plane 
and places glyphs according to the vector field data\&. The glyphs may
be colored using either the vector magnitude or the scalar attributes\&.

.TP
.B Vectors
Displays different types of glyphs oriented and colored as per vector 
data at the input points\&. This is merely a convenience module that is
entirely based on the Glyph module\&.

.TP
.B Volume
The Volume module visualizes scalar fields using volumetric 
visualization techniques\&.

.TP
.B WarpVectorCutPlane
Takes an arbitrary slice of the input data using an implicit cut plane 
and warps it according to the vector field data\&. The scalars are
displayed on the warped surface as colors\&.


.SH "MAYAVI2 FILTERS"

.TP
.B CellDerivatives
Computes derivatives from input point scalar and vector data and 
produces cell data on the gradients\&.  Can be used to approximately
calcuate the vorticity for example\&.

.TP
.B CellToPointData
Transforms cell attribute data to point data by averaging the cell 
data from the cells at the point\&.

.TP
.B Contour
A contour filter that wraps around the Contour component to generate 
iso-surfaces on any input dataset\&.
    
.TP
.B CutPlane
This class represents a cut plane that can be used to slice through any 
dataset\&.  It also provides a 3D widget interface to position and move
the slice interactively\&.

.TP
.B ElevationFilter
Creates scalar data corresponding to the elevation of the points along a 
line\&.

.TP
.B Delaunay2D
Performs a 2D Delaunay triangulation\&.

.TP
.B Delaunay3D
Performs a 3D Delaunay triangulation\&.

.TP
.B ExtractEdges
This filter extracts cell edges from any input data\&.

.TP
.B ExtractGrid
Allows a user to select a part of a structured grid\&.

.TP
.B ExtractTensorComponents 
Wraps the TVTK ExtractTensorComponents filter to extract components from 
a tensor field\&.

.TP
.B ExtractUnstructuredGrid
Allows a user to select a part of an unstructured grid\&.

.TP
.B ExtractVectorNorm
Computes the norm (Eucliedean) of the input vector data (with optional
scaling between [0, 1])\&. This is useful when the input data has vector
input but no scalar data for the magnitude of the vectors\&.

.TP
.B ExtractVectorComponents
Wraps the TVTK ExtractVectorComponents filter to extract components of
a vector\&. This is useful for analysing individual components of a
vector data\&.

.TP
.B GaussianSplatter
This filter splat points into a volume with an elliptical, Gaussian distribution\&.

.TP
.B MaskPoints
Selectively passes the input points downstream\&. This can be used to
subsample the input points. Note that this does not pass geometry
data, this means all grid information is lost\&.

.TP
.B GreedyTerrainDecimation
Approximates a height field (image data) with a triangle mesh, keeping the 
number of triangles minimum\&.

.TP
.B ImageChangeInformation
A filter that can be used to change the origin, spacing and extents of
an input image dataset without changing the data itself\&.

.TP
.B ImageDataProbe
A filter that can be used to probe any dataset using a Structured Points 
dataset\&.  The filter also allows one to convert the scalar data to an
unsigned short array so that the scalars can be used for volume 
visualization\&.

.TP
.B PointToCellData
Does the inverse of the CellToPointData filter\&.

.TP
.B PolyDataNormals
Computes normals from input data\&. This gives meshes a smoother
appearance\&. This should work for any input dataset\&. Note: this filter
is called "Compute Normals" in Mayavi2 GUI (Visualize/Filters/Compute
Normals)\&.

.TP
.B QuadricDecimation
Reduce triangles in a mesh, forming a good approximation of the original 
mesh\&.

.TP
.B SelectOutput
A filter that allows a user to select one among several of the outputs 
of a given input.  This is typically very useful for a multi-block data 
source\&.

.TP
.B SetActiveAttribute
This filter lets a user set the active data attribute (scalars, vectors 
and tensors) on a VTK dataset\&.  This is particularly useful if you
need to do something like compute contours of one scalar on the contour 
of another scalar\&.

.TP
.B Stripper 
Create triangle strips and/or poly-lines. Useful for regularizing
broken up surfaces, such as those created by the Tube filter.
\&.

.TP
.B Threshold
A simple filter that thresholds on input data\&.

.TP
.B TransformData
Performs a linear transformation to input data\&.

.TP
.B TriangleFilter
Converts input polygons and triangle strips to triangles using 
the tvtk\&.TriangleFilter class\&.  This is useful when you have a
downstream filter that only processes triangles\&.

.TP
.B Tube
Turns lines into tubes\&.

.TP
.B UserDefined
This filter lets the user define their own filter 
dynamically/interactively\&.  It is like FilterBase but allows a user
to specify the class without writing any code\&.
    
.TP
.B Vorticity
This filter computes the vorticity of an input vector field\&.  For
convenience, the filter allows one to optionally pass-through the given
input vector field\&.  The filter also allows the user to show the
component of the vorticity along a particular cartesian co-ordinate
axes\&.  It produces point data on output which is ready to visualize\&.

.TP
.B WarpScalar
Warps the input data along a particular direction (either the normals
or a specified direction) with a scale specified by the local scalar
value\&. Useful for making carpet plots\&.

.TP
.B WarpVector
Warps the input data along a the point vector attribute scaled as per 
a scale factor\&.  Useful for showing flow profiles or displacements\&.

.SH "EXAMPLES"

.PP
.RS
\f(CWmayavi2 \-d heart\&.vtk \-m Axes \-m Outline \-m GridPlane \-m ContourGridPlane \-m IsoSurface\fP
.br
\f(CWmayavi2 \-d fire_ug\&.vtu \-m Axes \-m Outline \-m VectorCutPlane \-f MaskPoints \-m Glyph\fP
.br
.RE

.PP
In the above examples, heart\&.vti and fire_ug\&.vtu VTK files can be
found in /usr/share/doc/mayavi2/examples/data\&. The examples directory
(/usr/share/doc/mayavi2/examples/ on Debian) provides several useful
examples\&.

.SH "AUTHOR"

.PP 
Mayavi was originally developed by Prabhu Ramachandran.  Many people
have later contributed to it.
.PP
More information on Mayavi2 can be obtained from
http://code\&.enthought\&.com/mayavi2
